/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.smarthome.core.events.AbstractEventFactory;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFactory;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.dto.ThingDTO;
import org.eclipse.smarthome.core.thing.dto.ThingDTOMapper;
import org.eclipse.smarthome.core.thing.events.ChannelTriggeredEvent;
import org.eclipse.smarthome.core.thing.events.ThingAddedEvent;
import org.eclipse.smarthome.core.thing.events.ThingRemovedEvent;
import org.eclipse.smarthome.core.thing.events.ThingStatusInfoChangedEvent;
import org.eclipse.smarthome.core.thing.events.ThingStatusInfoEvent;
import org.eclipse.smarthome.core.thing.events.ThingUpdatedEvent;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={EventFactory.class})
public class ThingEventFactory
extends AbstractEventFactory {
    private static final String THING_STATUS_INFO_EVENT_TOPIC = "smarthome/things/{thingUID}/status";
    private static final String THING_STATUS_INFO_CHANGED_EVENT_TOPIC = "smarthome/things/{thingUID}/statuschanged";
    private static final String THING_ADDED_EVENT_TOPIC = "smarthome/things/{thingUID}/added";
    private static final String THING_REMOVED_EVENT_TOPIC = "smarthome/things/{thingUID}/removed";
    private static final String THING_UPDATED_EVENT_TOPIC = "smarthome/things/{thingUID}/updated";
    private static final String CHANNEL_TRIGGERED_EVENT_TOPIC = "smarthome/channels/{channelUID}/triggered";

    public ThingEventFactory() {
        super((Set)Sets.newHashSet((Object[])new String[]{ThingStatusInfoEvent.TYPE, ThingStatusInfoChangedEvent.TYPE, ThingAddedEvent.TYPE, ThingRemovedEvent.TYPE, ThingUpdatedEvent.TYPE, ChannelTriggeredEvent.TYPE}));
    }

    protected Event createEventByType(String eventType, String topic, String payload, String source) throws Exception {
        Object event = null;
        if (eventType.equals(ThingStatusInfoEvent.TYPE)) {
            event = this.createStatusInfoEvent(topic, payload);
        } else if (eventType.equals(ThingStatusInfoChangedEvent.TYPE)) {
            event = this.createStatusInfoChangedEvent(topic, payload);
        } else if (eventType.equals(ThingAddedEvent.TYPE)) {
            event = this.createAddedEvent(topic, payload);
        } else if (eventType.equals(ThingRemovedEvent.TYPE)) {
            event = this.createRemovedEvent(topic, payload);
        } else if (eventType.equals(ThingUpdatedEvent.TYPE)) {
            event = this.createUpdatedEvent(topic, payload);
        } else if (eventType.equals(ChannelTriggeredEvent.TYPE)) {
            event = this.createTriggerEvent(topic, payload, source);
        }
        return event;
    }

    public static ChannelTriggeredEvent createTriggerEvent(String event, ChannelUID channel) {
        TriggerEventPayloadBean bean = new TriggerEventPayloadBean(event, channel.getAsString());
        String payload = ThingEventFactory.serializePayload((Object)bean);
        String topic = ThingEventFactory.buildTopic(CHANNEL_TRIGGERED_EVENT_TOPIC, channel);
        return new ChannelTriggeredEvent(topic, payload, null, event, channel);
    }

    public ChannelTriggeredEvent createTriggerEvent(String topic, String payload, String source) {
        TriggerEventPayloadBean bean = (TriggerEventPayloadBean)ThingEventFactory.deserializePayload((String)payload, TriggerEventPayloadBean.class);
        ChannelUID channel = new ChannelUID(bean.getChannel());
        return new ChannelTriggeredEvent(topic, payload, source, bean.getEvent(), channel);
    }

    private Event createStatusInfoEvent(String topic, String payload) throws Exception {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length != 4) {
            throw new IllegalArgumentException("ThingStatusInfoEvent creation failed, invalid topic: " + topic);
        }
        ThingUID thingUID = new ThingUID(topicElements[2]);
        ThingStatusInfo thingStatusInfo = (ThingStatusInfo)ThingEventFactory.deserializePayload((String)payload, ThingStatusInfo.class);
        return new ThingStatusInfoEvent(topic, payload, thingUID, thingStatusInfo);
    }

    private Event createStatusInfoChangedEvent(String topic, String payload) throws Exception {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length != 4) {
            throw new IllegalArgumentException("ThingStatusInfoChangedEvent creation failed, invalid topic: " + topic);
        }
        ThingUID thingUID = new ThingUID(topicElements[2]);
        ThingStatusInfo[] thingStatusInfo = (ThingStatusInfo[])ThingEventFactory.deserializePayload((String)payload, ThingStatusInfo[].class);
        return new ThingStatusInfoChangedEvent(topic, payload, thingUID, thingStatusInfo[0], thingStatusInfo[1]);
    }

    private Event createAddedEvent(String topic, String payload) throws Exception {
        ThingDTO thingDTO = (ThingDTO)ThingEventFactory.deserializePayload((String)payload, ThingDTO.class);
        return new ThingAddedEvent(topic, payload, thingDTO);
    }

    private Event createRemovedEvent(String topic, String payload) throws Exception {
        ThingDTO thingDTO = (ThingDTO)ThingEventFactory.deserializePayload((String)payload, ThingDTO.class);
        return new ThingRemovedEvent(topic, payload, thingDTO);
    }

    private Event createUpdatedEvent(String topic, String payload) throws Exception {
        ThingDTO[] thingDTO = (ThingDTO[])ThingEventFactory.deserializePayload((String)payload, ThingDTO[].class);
        if (thingDTO.length != 2) {
            throw new IllegalArgumentException("ThingUpdateEvent creation failed, invalid payload: " + payload);
        }
        return new ThingUpdatedEvent(topic, payload, thingDTO[0], thingDTO[1]);
    }

    public static ThingStatusInfoEvent createStatusInfoEvent(ThingUID thingUID, ThingStatusInfo thingStatusInfo) {
        Preconditions.checkArgument((thingUID != null ? 1 : 0) != 0, (Object)"The argument 'thingUID' must not be null.");
        Preconditions.checkArgument((thingStatusInfo != null ? 1 : 0) != 0, (Object)"The argument 'thingStatusInfo' must not be null.");
        String topic = ThingEventFactory.buildTopic(THING_STATUS_INFO_EVENT_TOPIC, thingUID);
        String payload = ThingEventFactory.serializePayload((Object)thingStatusInfo);
        return new ThingStatusInfoEvent(topic, payload, thingUID, thingStatusInfo);
    }

    public static ThingStatusInfoChangedEvent createStatusInfoChangedEvent(ThingUID thingUID, ThingStatusInfo thingStatusInfo, ThingStatusInfo oldThingStatusInfo) {
        Preconditions.checkArgument((thingUID != null ? 1 : 0) != 0, (Object)"The argument 'thingUID' must not be null.");
        Preconditions.checkArgument((thingStatusInfo != null ? 1 : 0) != 0, (Object)"The argument 'thingStatusInfo' must not be null.");
        Preconditions.checkArgument((oldThingStatusInfo != null ? 1 : 0) != 0, (Object)"The argument 'oldThingStatusInfo' must not be null.");
        String topic = ThingEventFactory.buildTopic(THING_STATUS_INFO_CHANGED_EVENT_TOPIC, thingUID);
        String payload = ThingEventFactory.serializePayload((Object)new ThingStatusInfo[]{thingStatusInfo, oldThingStatusInfo});
        return new ThingStatusInfoChangedEvent(topic, payload, thingUID, thingStatusInfo, oldThingStatusInfo);
    }

    public static ThingAddedEvent createAddedEvent(Thing thing) {
        ThingEventFactory.assertValidArgument(thing);
        String topic = ThingEventFactory.buildTopic(THING_ADDED_EVENT_TOPIC, thing.getUID());
        ThingDTO thingDTO = ThingEventFactory.map(thing);
        String payload = ThingEventFactory.serializePayload((Object)thingDTO);
        return new ThingAddedEvent(topic, payload, thingDTO);
    }

    public static ThingRemovedEvent createRemovedEvent(Thing thing) {
        ThingEventFactory.assertValidArgument(thing);
        String topic = ThingEventFactory.buildTopic(THING_REMOVED_EVENT_TOPIC, thing.getUID());
        ThingDTO thingDTO = ThingEventFactory.map(thing);
        String payload = ThingEventFactory.serializePayload((Object)thingDTO);
        return new ThingRemovedEvent(topic, payload, thingDTO);
    }

    public static ThingUpdatedEvent createUpdateEvent(Thing thing, Thing oldThing) {
        ThingEventFactory.assertValidArgument(thing);
        ThingEventFactory.assertValidArgument(oldThing);
        String topic = ThingEventFactory.buildTopic(THING_UPDATED_EVENT_TOPIC, thing.getUID());
        ThingDTO thingDTO = ThingEventFactory.map(thing);
        ThingDTO oldThingDTO = ThingEventFactory.map(oldThing);
        LinkedList thingDTOs = Lists.newLinkedList();
        thingDTOs.add(thingDTO);
        thingDTOs.add(oldThingDTO);
        String payload = ThingEventFactory.serializePayload((Object)thingDTOs);
        return new ThingUpdatedEvent(topic, payload, thingDTO, oldThingDTO);
    }

    private static void assertValidArgument(Thing thing) {
        Preconditions.checkArgument((thing != null ? 1 : 0) != 0, (Object)"The argument 'thing' must not be null.");
        Preconditions.checkArgument((thing.getUID() != null ? 1 : 0) != 0, (Object)"The thingUID of a thing must not be null.");
    }

    private static String buildTopic(String topic, ThingUID thingUID) {
        return topic.replace("{thingUID}", thingUID.getAsString());
    }

    private static String buildTopic(String topic, ChannelUID channelUID) {
        return topic.replace("{channelUID}", channelUID.getAsString());
    }

    private static ThingDTO map(Thing thing) {
        return ThingDTOMapper.map(thing);
    }

    public static class TriggerEventPayloadBean {
        private String event;
        private String channel;

        protected TriggerEventPayloadBean() {
        }

        public TriggerEventPayloadBean(String event, String channel) {
            this.event = event;
            this.channel = channel;
        }

        public String getEvent() {
            return this.event;
        }

        public String getChannel() {
            return this.channel;
        }
    }
}

