/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import org.eclipse.smarthome.core.events.AbstractEvent;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatus;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatusInfo;

public final class FirmwareStatusInfoEvent
extends AbstractEvent {
    public static final String TYPE = FirmwareStatusInfoEvent.class.getSimpleName();
    private final FirmwareStatusInfo firmwareStatusInfo;
    private final ThingUID thingUID;

    protected FirmwareStatusInfoEvent(String topic, String payload, FirmwareStatusInfo firmwareStatusInfo, ThingUID thingUID) {
        super(topic, payload, null);
        this.firmwareStatusInfo = firmwareStatusInfo;
        this.thingUID = thingUID;
    }

    public FirmwareStatusInfo getFirmwareStatusInfo() {
        return this.firmwareStatusInfo;
    }

    public ThingUID getThingUID() {
        return this.thingUID;
    }

    public String getType() {
        return TYPE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firmwareStatusInfo == null ? 0 : this.firmwareStatusInfo.hashCode());
        result = 31 * result + (this.thingUID == null ? 0 : this.thingUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FirmwareStatusInfoEvent other = (FirmwareStatusInfoEvent)((Object)obj);
        if (this.firmwareStatusInfo == null ? other.firmwareStatusInfo != null : !this.firmwareStatusInfo.equals(other.firmwareStatusInfo)) {
            return false;
        }
        return !(this.thingUID == null ? other.thingUID != null : !this.thingUID.equals(other.thingUID));
    }

    public String toString() {
        FirmwareStatus status = this.firmwareStatusInfo.getFirmwareStatus();
        StringBuilder sb = new StringBuilder(String.format("Firmware status of thing %s changed to %s.", this.thingUID, status.name()));
        if (status == FirmwareStatus.UPDATE_EXECUTABLE) {
            sb.append(String.format(" The new updatable firmware version is %s.", this.firmwareStatusInfo.getUpdatableFirmwareUID().getFirmwareVersion()));
        }
        return sb.toString();
    }
}

