/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.i18n;

import java.util.Arrays;
import java.util.Locale;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ThingStatusInfoI18nLocalizationService.class})
public final class ThingStatusInfoI18nLocalizationService {
    private TranslationProvider i18nProvider;

    public ThingStatusInfo getLocalizedThingStatusInfo(Thing thing, Locale locale) {
        if (thing == null) {
            throw new IllegalArgumentException("Thing must not be null.");
        }
        ThingHandler thingHandler = thing.getHandler();
        if (thingHandler == null) {
            return thing.getStatusInfo();
        }
        String description = thing.getStatusInfo().getDescription();
        if (!I18nUtil.isConstant((String)description)) {
            return thing.getStatusInfo();
        }
        Bundle bundle = FrameworkUtil.getBundle(thingHandler.getClass());
        Description desc = new Description(bundle, locale, description, this.i18nProvider);
        String translatedDescription = this.i18nProvider.getText(bundle, desc.key, description, locale, desc.args);
        return new ThingStatusInfo(thing.getStatus(), thing.getStatusInfo().getStatusDetail(), translatedDescription);
    }

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }

    private final class Description {
        private static final int LIMIT = 2;
        private final String key;
        private final Object[] args;

        private Description(Bundle bundle, Locale locale, String description, TranslationProvider theTranslationProvider) {
            String[] parts = description.split("\\s+", 2);
            this.key = I18nUtil.stripConstant((String)parts[0]);
            this.args = parts.length == 1 ? null : Arrays.stream(parts[1].replaceAll("\\[|\\]|\"", "").split(",")).filter(s -> {
                if (s == null) {
                    return false;
                }
                return !s.trim().isEmpty();
            }).map(s -> {
                String input = s.trim();
                return I18nUtil.isConstant((String)input) ? theTranslationProvider.getText(bundle, I18nUtil.stripConstant((String)input), input, locale) : input;
            }).toArray(String[]::new);
        }
    }
}

