/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.RegistryHook;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid="org.eclipse.smarthome.channelitemprovider", immediate=true, configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class ChannelItemProvider
implements ItemProvider {
    private final Logger logger = LoggerFactory.getLogger(ChannelItemProvider.class);
    private final Set<ProviderChangeListener<Item>> listeners = new HashSet<ProviderChangeListener<Item>>();
    private LocaleProvider localeProvider;
    private ThingRegistry thingRegistry;
    private ItemChannelLinkRegistry linkRegistry;
    private ItemRegistry itemRegistry;
    private final Set<ItemFactory> itemFactories = new HashSet<ItemFactory>();
    private Map<String, Item> items = null;
    private boolean enabled = true;
    private boolean initialized = false;
    private volatile long lastUpdate = System.nanoTime();
    RegistryChangeListener<Thing> thingRegistryListener = new RegistryChangeListener<Thing>(){

        public void added(Thing element) {
            for (Channel channel : element.getChannels()) {
                for (ItemChannelLink link : ChannelItemProvider.this.linkRegistry.getLinks(channel.getUID())) {
                    ChannelItemProvider.this.createItemForLink(link);
                }
            }
        }

        public void removed(Thing element) {
            ChannelItemProvider.this.removeItem(element.getUID().toString());
        }

        public void updated(Thing oldElement, Thing element) {
            this.removed(oldElement);
            this.added(element);
        }
    };
    RegistryChangeListener<ItemChannelLink> linkRegistryListener = new RegistryChangeListener<ItemChannelLink>(){

        public void added(ItemChannelLink element) {
            ChannelItemProvider.this.createItemForLink(element);
            ChannelItemProvider.this.lastUpdate = System.nanoTime();
        }

        public void removed(ItemChannelLink element) {
            ChannelItemProvider.this.removeItem(element.getItemName());
        }

        public void updated(ItemChannelLink oldElement, ItemChannelLink element) {
            this.removed(oldElement);
            this.added(element);
        }
    };
    RegistryHook<Item> itemRegistryListener = new RegistryHook<Item>(){

        public void beforeAdding(Item element) {
            for (Item item : ChannelItemProvider.this.items.values()) {
                if (item != element) continue;
                return;
            }
            Item oldElement = (Item)ChannelItemProvider.this.items.get(element.getName());
            if (oldElement != null) {
                for (ProviderChangeListener listener : ChannelItemProvider.this.listeners) {
                    listener.removed((Provider)ChannelItemProvider.this, (Object)oldElement);
                }
                ChannelItemProvider.this.items.remove(element.getName());
            }
            ChannelItemProvider.this.lastUpdate = System.nanoTime();
        }

        public void afterRemoving(Item element) {
            for (Item item : ChannelItemProvider.this.items.values()) {
                if (item != element) continue;
                return;
            }
            for (ChannelUID uid : ChannelItemProvider.this.linkRegistry.getBoundChannels(element.getName())) {
                for (ItemChannelLink link : ChannelItemProvider.this.linkRegistry.getLinks(uid)) {
                    if (ChannelItemProvider.this.itemRegistry.get((Object)link.getItemName()) != null) continue;
                    ChannelItemProvider.this.createItemForLink(link);
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Item> getAll() {
        if (!this.enabled || !this.initialized) {
            return Collections.emptySet();
        }
        ChannelItemProvider channelItemProvider = this;
        synchronized (channelItemProvider) {
            if (this.items == null) {
                this.items = new ConcurrentHashMap<String, Item>();
                for (ItemChannelLink link : this.linkRegistry.getAll()) {
                    this.createItemForLink(link);
                }
            }
        }
        return new HashSet<Item>(this.items.values());
    }

    public void addProviderChangeListener(ProviderChangeListener<Item> listener) {
        this.listeners.add(listener);
        for (Item item : this.getAll()) {
            listener.added((Provider)this, (Object)item);
        }
    }

    public void removeProviderChangeListener(ProviderChangeListener<Item> listener) {
        this.listeners.remove(listener);
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry linkRegistry) {
        this.linkRegistry = linkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry linkRegistry) {
        this.linkRegistry = null;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    @Modified
    protected synchronized void modified(Map<String, Object> properties) {
        if (properties != null) {
            String enabled = (String)properties.get("enabled");
            this.enabled = !"false".equalsIgnoreCase(enabled);
        }
        if (this.enabled) {
            boolean initialDelay;
            boolean bl = initialDelay = properties == null || !"false".equalsIgnoreCase((String)properties.get("initialDelay"));
            if (initialDelay) {
                this.delayedInitialize(Executors.newSingleThreadScheduledExecutor());
            } else {
                this.initialize();
            }
        } else {
            this.logger.debug("Disabling channel item provider.");
            for (ProviderChangeListener<Item> listener : this.listeners) {
                for (Item item : this.getAll()) {
                    listener.removed((Provider)this, (Object)item);
                }
            }
            this.removeRegistryChangeListeners();
        }
    }

    private void delayedInitialize(ScheduledExecutorService executor) {
        long diff = System.nanoTime() - this.lastUpdate - TimeUnit.SECONDS.toNanos(2L);
        if (diff < 0L) {
            executor.schedule(() -> this.delayedInitialize(executor), -diff, TimeUnit.NANOSECONDS);
        } else {
            executor.shutdown();
            this.initialize();
        }
    }

    private void initialize() {
        this.logger.debug("Enabling channel item provider.");
        this.initialized = true;
        this.getAll();
        this.addRegistryChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        this.removeRegistryChangeListeners();
        ChannelItemProvider channelItemProvider = this;
        synchronized (channelItemProvider) {
            this.initialized = false;
            this.items = null;
        }
    }

    private void addRegistryChangeListeners() {
        this.linkRegistry.addRegistryChangeListener(this.linkRegistryListener);
        this.itemRegistry.addRegistryHook(this.itemRegistryListener);
        this.thingRegistry.addRegistryChangeListener(this.thingRegistryListener);
    }

    private void removeRegistryChangeListeners() {
        this.itemRegistry.removeRegistryHook(this.itemRegistryListener);
        this.linkRegistry.removeRegistryChangeListener(this.linkRegistryListener);
        this.thingRegistry.removeRegistryChangeListener(this.thingRegistryListener);
    }

    private void createItemForLink(ItemChannelLink link) {
        if (!this.enabled) {
            return;
        }
        if (this.itemRegistry.get((Object)link.getItemName()) != null) {
            return;
        }
        Channel channel = this.thingRegistry.getChannel(link.getLinkedUID());
        if (channel != null) {
            GenericItem item = null;
            if (channel.getKind() == ChannelKind.STATE) {
                for (ItemFactory itemFactory : this.itemFactories) {
                    item = itemFactory.createItem(channel.getAcceptedItemType(), link.getItemName());
                    if (item != null) break;
                }
            }
            if (item != null && item instanceof GenericItem) {
                GenericItem genericItem = item;
                genericItem.setLabel(this.getLabel(channel));
                genericItem.setCategory(this.getCategory(channel));
                genericItem.addTags(channel.getDefaultTags());
            }
            if (item != null) {
                this.items.put(item.getName(), (Item)item);
                for (ProviderChangeListener providerChangeListener : this.listeners) {
                    providerChangeListener.added((Provider)this, (Object)item);
                }
            }
        }
    }

    private String getCategory(Channel channel) {
        ChannelType channelType;
        if (channel.getChannelTypeUID() != null && (channelType = TypeResolver.resolve(channel.getChannelTypeUID(), this.localeProvider.getLocale())) != null) {
            return channelType.getCategory();
        }
        return null;
    }

    private String getLabel(Channel channel) {
        ChannelType channelType;
        if (channel.getLabel() != null) {
            return channel.getLabel();
        }
        Locale locale = this.localeProvider.getLocale();
        if (channel.getChannelTypeUID() != null && (channelType = TypeResolver.resolve(channel.getChannelTypeUID(), locale)) != null) {
            return channelType.getLabel();
        }
        return null;
    }

    private void removeItem(String key) {
        if (!this.enabled) {
            return;
        }
        Item item = this.items.get(key);
        if (item != null) {
            for (ProviderChangeListener<Item> listener : this.listeners) {
                listener.removed((Provider)this, (Object)item);
            }
            this.items.remove(key);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

