/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.profiles;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.profiles.ProfileCallback;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.SystemProfiles;
import org.eclipse.smarthome.core.thing.profiles.TriggerProfile;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class RawButtonToggleSwitchProfile
implements TriggerProfile {
    private final ProfileCallback callback;
    private @Nullable State previousState;

    public RawButtonToggleSwitchProfile(ProfileCallback callback) {
        this.callback = callback;
    }

    @Override
    public ProfileTypeUID getProfileTypeUID() {
        return SystemProfiles.RAWBUTTON_TOGGLE_SWITCH;
    }

    @Override
    public void onTriggerFromHandler(String event) {
        if ("PRESSED".equals(event)) {
            OnOffType newState = OnOffType.ON.equals((Object)this.previousState) ? OnOffType.OFF : OnOffType.ON;
            this.callback.sendCommand((Command)newState);
            this.previousState = newState;
        }
    }

    @Override
    public void onStateUpdateFromItem(State state) {
        this.previousState = state;
    }
}

