/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.link.AbstractLink;
import org.eclipse.smarthome.core.thing.link.AbstractLinkRegistry;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkProvider;
import org.eclipse.smarthome.core.thing.link.ManagedItemChannelLinkProvider;
import org.eclipse.smarthome.core.thing.link.events.LinkEventFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={ItemChannelLinkRegistry.class})
public class ItemChannelLinkRegistry
extends AbstractLinkRegistry<ItemChannelLink, ItemChannelLinkProvider> {
    private ThingRegistry thingRegistry;
    private ItemRegistry itemRegistry;

    public ItemChannelLinkRegistry() {
        super(ItemChannelLinkProvider.class);
    }

    public Set<ChannelUID> getBoundChannels(String itemName) {
        HashSet<ChannelUID> channelUIDs = new HashSet<ChannelUID>();
        for (ItemChannelLink itemChannelLink : this.getAll()) {
            if (!itemChannelLink.getItemName().equals(itemName)) continue;
            channelUIDs.add(itemChannelLink.getLinkedUID());
        }
        return channelUIDs;
    }

    @Override
    public Set<String> getLinkedItemNames(UID uid) {
        LinkedHashSet<String> linkedItems = new LinkedHashSet<String>();
        for (AbstractLink link : this.getAll()) {
            String itemName = link.getItemName();
            if (!link.getLinkedUID().equals(uid) || this.itemRegistry.get((Object)itemName) == null) continue;
            linkedItems.add(itemName);
        }
        return linkedItems;
    }

    public Set<Item> getLinkedItems(UID uid) {
        LinkedHashSet<Item> linkedItems = new LinkedHashSet<Item>();
        for (AbstractLink link : this.getAll()) {
            String itemName = link.getItemName();
            Item item = (Item)this.itemRegistry.get((Object)itemName);
            if (!link.getLinkedUID().equals(uid) || item == null) continue;
            linkedItems.add(item);
        }
        return linkedItems;
    }

    public Set<Thing> getBoundThings(String itemName) {
        HashSet<Thing> things = new HashSet<Thing>();
        Set<ChannelUID> boundChannels = this.getBoundChannels(itemName);
        for (ChannelUID channelUID : boundChannels) {
            Thing thing = this.thingRegistry.get(channelUID.getThingUID());
            if (thing == null) continue;
            things.add(thing);
        }
        return things;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    protected void setManagedProvider(ManagedItemChannelLinkProvider provider) {
        super.setManagedProvider((ManagedProvider)provider);
    }

    protected void unsetManagedProvider(ManagedItemChannelLinkProvider provider) {
        super.removeManagedProvider((ManagedProvider)provider);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
    }

    public void removeLinksForThing(ThingUID thingUID) {
        if (this.managedProvider == null) {
            throw new IllegalStateException("ManagedProvider is not available");
        }
        ((ManagedItemChannelLinkProvider)this.managedProvider).removeLinksForThing(thingUID);
    }

    protected void notifyListenersAboutAddedElement(ItemChannelLink element) {
        super.notifyListenersAboutAddedElement((Identifiable)element);
        this.postEvent((Event)LinkEventFactory.createItemChannelLinkAddedEvent(element));
    }

    protected void notifyListenersAboutRemovedElement(ItemChannelLink element) {
        super.notifyListenersAboutRemovedElement((Identifiable)element);
        this.postEvent((Event)LinkEventFactory.createItemChannelLinkRemovedEvent(element));
    }

    protected void notifyListenersAboutUpdatedElement(ItemChannelLink oldElement, ItemChannelLink element) {
        super.notifyListenersAboutUpdatedElement((Identifiable)oldElement, (Identifiable)element);
    }
}

