/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

public class ChannelDefinition {
    private String id;
    private ChannelTypeUID channelTypeUID;
    private final Map<String, String> properties;
    private final String label;
    private final String description;

    public ChannelDefinition(String id, ChannelTypeUID channelTypeUID) throws IllegalArgumentException {
        this(id, channelTypeUID, null, null, null);
    }

    public ChannelDefinition(String id, ChannelTypeUID channelTypeUID, Map<String, String> properties, String label, String description) throws IllegalArgumentException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("The ID must neither be null nor empty!");
        }
        if (channelTypeUID == null) {
            throw new IllegalArgumentException("The channel type must not be null");
        }
        this.properties = properties != null ? Collections.unmodifiableMap(properties) : Collections.unmodifiableMap(new HashMap(0));
        this.id = id;
        this.channelTypeUID = channelTypeUID;
        this.label = label;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public ChannelTypeUID getChannelTypeUID() {
        return this.channelTypeUID;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "ChannelDefinition [id=" + this.id + ", type=" + this.channelTypeUID + ", properties=" + this.properties + "]";
    }
}

