/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.cache;

import java.lang.ref.SoftReference;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;

public class ExpiringCache<V> {
    private final long expiry;
    private final Supplier<V> action;
    private SoftReference<V> value;
    private long expiresAt;

    public ExpiringCache(long expiry, Supplier<V> action) {
        if (action == null) {
            throw new IllegalArgumentException("ExpiringCacheItem cannot be created as action is null.");
        }
        this.expiry = TimeUnit.MILLISECONDS.toNanos(expiry);
        this.action = action;
        this.invalidateValue();
    }

    public synchronized @Nullable V getValue() {
        V cachedValue = this.value.get();
        if (cachedValue == null || this.isExpired()) {
            return this.refreshValue();
        }
        return cachedValue;
    }

    public final synchronized void invalidateValue() {
        this.value = new SoftReference<Object>(null);
        this.expiresAt = 0L;
    }

    public synchronized @Nullable V refreshValue() {
        V freshValue = this.action.get();
        this.value = new SoftReference<V>(freshValue);
        this.expiresAt = System.nanoTime() + this.expiry;
        return freshValue;
    }

    public boolean isExpired() {
        return this.expiresAt < System.nanoTime();
    }
}

