/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.cache;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExpiringCacheAsync<V> {
    protected final long expiry;
    protected long expiresAt = 0L;
    protected CompletableFuture<V> currentNewValueRequest = null;
    protected @Nullable V value;

    public ExpiringCacheAsync(long expiry) throws IllegalArgumentException {
        if (expiry <= 0L) {
            throw new IllegalArgumentException("Cache expire time must be greater than 0");
        }
        this.expiry = TimeUnit.MILLISECONDS.toNanos(expiry);
    }

    public CompletableFuture<V> getValue(@NonNull Supplier<CompletableFuture<V>> requestNewValueFuture) {
        if (this.isExpired()) {
            return this.refreshValue(requestNewValueFuture);
        }
        return CompletableFuture.completedFuture(this.value);
    }

    public void invalidateValue() {
        this.expiresAt = 0L;
    }

    protected long getCurrentNanoTime() {
        return System.nanoTime();
    }

    public synchronized @NonNull CompletableFuture<V> refreshValue(@NonNull Supplier<CompletableFuture<V>> requestNewValueFuture) {
        this.expiresAt = 0L;
        if (this.currentNewValueRequest != null) {
            return this.currentNewValueRequest;
        }
        this.currentNewValueRequest = requestNewValueFuture.get();
        if (this.currentNewValueRequest == null) {
            throw new IllegalArgumentException("We expect a CompletableFuture for refreshValue() to work!");
        }
        CompletionStage t = this.currentNewValueRequest.thenApply(newValue -> {
            this.currentNewValueRequest = null;
            this.value = newValue;
            this.expiresAt = this.getCurrentNanoTime() + this.expiry;
            return this.value;
        });
        if (t == null) {
            throw new IllegalArgumentException("We expect a CompletableFuture for refreshValue() to work!");
        }
        return t;
    }

    public boolean isExpired() {
        return this.expiresAt < this.getCurrentNanoTime();
    }

    public @Nullable V getLastKnownValue() {
        return this.value;
    }
}

