/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.cache;

import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.eclipse.smarthome.core.cache.ExpiringCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringCacheMap<K, V> {
    private final Logger logger = LoggerFactory.getLogger(ExpiringCacheMap.class);
    private final long expiry;
    private final ConcurrentMap<K, ExpiringCache<V>> items;

    public ExpiringCacheMap(Duration expiry) {
        this(expiry.toMillis());
    }

    public ExpiringCacheMap(long expiry) {
        this.expiry = expiry;
        this.items = new ConcurrentHashMap<K, ExpiringCache<V>>();
    }

    public void put(K key, Supplier<V> action) {
        this.put(key, new ExpiringCache<V>(this.expiry, action));
    }

    public void put(K key, ExpiringCache<V> item) {
        if (key == null) {
            throw new IllegalArgumentException("Item cannot be added as key is null.");
        }
        if (item == null) {
            throw new IllegalArgumentException("Item cannot be added as item is null.");
        }
        this.items.put(key, item);
    }

    public void putIfAbsent(K key, ExpiringCache<V> item) {
        if (key == null) {
            throw new IllegalArgumentException("Item cannot be added as key is null.");
        }
        if (item == null) {
            throw new IllegalArgumentException("Item cannot be added as item is null.");
        }
        this.items.putIfAbsent(key, item);
    }

    public V putIfAbsentAndGet(K key, Supplier<V> action) {
        return this.putIfAbsentAndGet(key, new ExpiringCache<V>(this.expiry, action));
    }

    public V putIfAbsentAndGet(K key, ExpiringCache<V> item) {
        this.putIfAbsent(key, item);
        return this.get(key);
    }

    public boolean containsKey(K key) {
        return this.items.containsKey(key);
    }

    public void remove(K key) {
        this.items.remove(key);
    }

    public void clear() {
        this.items.clear();
    }

    public synchronized Set<K> keys() {
        LinkedHashSet keys = new LinkedHashSet();
        for (Object key : this.items.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    public V get(K key) {
        ExpiringCache item = (ExpiringCache)this.items.get(key);
        if (item == null) {
            this.logger.debug("No item for key '{}' found", key);
            return null;
        }
        return item.getValue();
    }

    public synchronized Collection<V> values() {
        LinkedList values = new LinkedList();
        for (ExpiringCache item : this.items.values()) {
            values.add(item.getValue());
        }
        return values;
    }

    public synchronized void invalidate(K key) {
        ExpiringCache item = (ExpiringCache)this.items.get(key);
        if (item == null) {
            this.logger.debug("No item for key '{}' found", key);
        } else {
            item.invalidateValue();
        }
    }

    public synchronized void invalidateAll() {
        this.items.values().forEach(item -> item.invalidateValue());
    }

    public synchronized V refresh(K key) {
        ExpiringCache item = (ExpiringCache)this.items.get(key);
        if (item == null) {
            this.logger.debug("No item for key '{}' found", key);
            return null;
        }
        return item.refreshValue();
    }

    public synchronized Collection<V> refreshAll() {
        LinkedList values = new LinkedList();
        for (ExpiringCache item : this.items.values()) {
            values.add(item.refreshValue());
        }
        return values;
    }
}

