/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.common;

import java.lang.reflect.Proxy;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.common.SafeCallerBuilder;
import org.eclipse.smarthome.core.internal.common.AbstractInvocationHandler;
import org.eclipse.smarthome.core.internal.common.InvocationHandlerAsync;
import org.eclipse.smarthome.core.internal.common.InvocationHandlerSync;
import org.eclipse.smarthome.core.internal.common.SafeCallManager;

@NonNullByDefault
public class SafeCallerBuilderImpl<T>
implements SafeCallerBuilder<T> {
    private final T target;
    private final Class<?>[] interfaceTypes;
    private long timeout;
    private Object identifier;
    private @Nullable Consumer<Throwable> exceptionHandler;
    private @Nullable Runnable timeoutHandler;
    private boolean async;
    private final SafeCallManager manager;

    public SafeCallerBuilderImpl(T target, Class<?>[] classes, SafeCallManager manager) {
        this.target = target;
        this.interfaceTypes = classes;
        this.manager = manager;
        this.timeout = SafeCaller.DEFAULT_TIMEOUT;
        this.identifier = target;
        this.async = false;
    }

    @Override
    public T build() {
        AbstractInvocationHandler handler = this.async ? new InvocationHandlerAsync<T>(this.manager, this.target, this.identifier, this.timeout, this.exceptionHandler, this.timeoutHandler) : new InvocationHandlerSync<T>(this.manager, this.target, this.identifier, this.timeout, this.exceptionHandler, this.timeoutHandler);
        return (T)Proxy.newProxyInstance(this.target.getClass().getClassLoader(), this.interfaceTypes, handler);
    }

    @Override
    public SafeCallerBuilder<T> withTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public SafeCallerBuilder<T> withIdentifier(Object identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public SafeCallerBuilder<T> onException(Consumer<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public SafeCallerBuilder<T> onTimeout(Runnable timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        return this;
    }

    @Override
    public SafeCallerBuilder<T> withAsync() {
        this.async = true;
        return this;
    }
}

