/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.i18n;

import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.LocationProvider;
import org.eclipse.smarthome.core.i18n.TimeZoneProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.internal.i18n.LanguageResourceBundleManager;
import org.eclipse.smarthome.core.internal.i18n.ResourceBundleTracker;
import org.eclipse.smarthome.core.library.types.PointType;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid="org.eclipse.smarthome.core.i18nprovider", property={"service.pid=org.eclipse.smarthome.core.i18nprovider", "service.config.description.uri:String=system:i18n", "service.config.label:String=Regional Settings", "service.config.category:String=system"})
public class I18nProviderImpl
implements TranslationProvider,
LocaleProvider,
LocationProvider,
TimeZoneProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final String LANGUAGE = "language";
    static final String SCRIPT = "script";
    static final String REGION = "region";
    static final String VARIANT = "variant";
    private Locale locale;
    private ResourceBundleTracker resourceBundleTracker;
    static final String LOCATION = "location";
    private PointType location;
    static final String TIMEZONE = "timezone";
    private ZoneId timeZone;

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.modified((Map)((Object)componentContext.getProperties()));
        this.resourceBundleTracker = new ResourceBundleTracker(componentContext.getBundleContext(), this);
        this.resourceBundleTracker.open();
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.resourceBundleTracker.close();
    }

    @Modified
    protected synchronized void modified(Map<String, Object> config) {
        String language = this.toStringOrNull(config.get(LANGUAGE));
        String script = this.toStringOrNull(config.get(SCRIPT));
        String region = this.toStringOrNull(config.get(REGION));
        String variant = this.toStringOrNull(config.get(VARIANT));
        String location = this.toStringOrNull(config.get(LOCATION));
        String zoneId = this.toStringOrNull(config.get(TIMEZONE));
        this.setTimeZone(zoneId);
        this.setLocation(location);
        if (StringUtils.isEmpty((String)language)) {
            this.logger.debug("No language set, falling back to the default locale");
            this.locale = null;
            return;
        }
        Locale.Builder builder = new Locale.Builder();
        try {
            builder.setLanguage(language);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Language ({}) is invalid. Cannot create locale, keep old one.", (Object)language, (Object)ex);
            return;
        }
        try {
            builder.setScript(script);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Script ({}) is invalid. Skip it.", (Object)script, (Object)ex);
            return;
        }
        try {
            builder.setRegion(region);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Region ({}) is invalid. Skip it.", (Object)region, (Object)ex);
            return;
        }
        try {
            builder.setVariant(variant);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Variant ({}) is invalid. Skip it.", (Object)variant, (Object)ex);
            return;
        }
        this.locale = builder.build();
        this.logger.info("Locale set to {}, Location set to {}, Time zone set to {}", new Object[]{this.locale, this.location, this.timeZone});
    }

    private String toStringOrNull(Object value) {
        return value == null ? null : value.toString();
    }

    private void setLocation(String location) {
        if (location != null) {
            try {
                this.location = PointType.valueOf(location);
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Could not set new location, keeping old one: ", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void setTimeZone(String zoneId) {
        if (StringUtils.isBlank((String)zoneId)) {
            this.timeZone = TimeZone.getDefault().toZoneId();
            this.logger.debug("No time zone set, falling back to the default time zone '{}'.", (Object)this.timeZone.toString());
        } else {
            try {
                this.timeZone = ZoneId.of(zoneId);
            }
            catch (DateTimeException e) {
                this.timeZone = TimeZone.getDefault().toZoneId();
                this.logger.warn("Error setting time zone '{}', falling back to the default time zone '{}': {}", new Object[]{zoneId, this.timeZone.toString(), e.getMessage()});
            }
        }
    }

    @Override
    public PointType getLocation() {
        return this.location;
    }

    @Override
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public String getText(Bundle bundle, String key, String defaultText, Locale locale) {
        String text;
        LanguageResourceBundleManager languageResource = this.resourceBundleTracker.getLanguageResource(bundle);
        if (languageResource != null && (text = languageResource.getText(key, locale)) != null) {
            return text;
        }
        return defaultText;
    }

    @Override
    public String getText(Bundle bundle, String key, String defaultText, Locale locale, Object ... arguments) {
        String text = this.getText(bundle, key, defaultText, locale);
        if (text != null) {
            return MessageFormat.format(text, arguments);
        }
        return text;
    }
}

