/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.items;

import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.AbstractItemEventSubscriber;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;
import org.eclipse.smarthome.core.types.State;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EventSubscriber.class})
public class ItemUpdater
extends AbstractItemEventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(ItemUpdater.class);
    private ItemRegistry itemRegistry;

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Override
    protected void receiveUpdate(ItemStateEvent updateEvent) {
        String itemName = updateEvent.getItemName();
        State newState = updateEvent.getItemState();
        try {
            GenericItem item = (GenericItem)this.itemRegistry.getItem(itemName);
            boolean isAccepted = false;
            if (item.getAcceptedDataTypes().contains(newState.getClass())) {
                isAccepted = true;
            } else {
                for (Class<? extends State> state : item.getAcceptedDataTypes()) {
                    try {
                        if (state.isEnum() || !state.newInstance().getClass().isAssignableFrom(newState.getClass())) continue;
                        isAccepted = true;
                        break;
                    }
                    catch (InstantiationException e) {
                        this.logger.warn("InstantiationException on {}", (Object)e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        this.logger.warn("IllegalAccessException on {}", (Object)e.getMessage());
                    }
                }
            }
            if (isAccepted) {
                item.setState(newState);
            } else {
                this.logger.debug("Received update of a not accepted type ({}) for item {}", (Object)newState.getClass().getSimpleName(), (Object)itemName);
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.debug("Received update for non-existing item: {}", (Object)e.getMessage());
        }
    }

    @Override
    protected void receiveCommand(ItemCommandEvent commandEvent) {
        try {
            Item item = this.itemRegistry.getItem(commandEvent.getItemName());
            if (item instanceof GroupItem) {
                GroupItem groupItem = (GroupItem)item;
                groupItem.send(commandEvent.getItemCommand());
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.debug("Received command for non-existing item: {}", (Object)e.getMessage());
        }
    }
}

