/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items.events;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;

public abstract class AbstractItemEventSubscriber
implements EventSubscriber {
    private final Set<String> subscribedEventTypes = ImmutableSet.of((Object)ItemStateEvent.TYPE, (Object)ItemCommandEvent.TYPE);

    @Override
    public Set<String> getSubscribedEventTypes() {
        return this.subscribedEventTypes;
    }

    @Override
    public EventFilter getEventFilter() {
        return null;
    }

    @Override
    public void receive(Event event) {
        if (event instanceof ItemStateEvent) {
            this.receiveUpdate((ItemStateEvent)event);
        } else if (event instanceof ItemCommandEvent) {
            this.receiveCommand((ItemCommandEvent)event);
        }
    }

    protected void receiveCommand(ItemCommandEvent commandEvent) {
    }

    protected void receiveUpdate(ItemStateEvent updateEvent) {
    }
}

