/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.library.items.CallItem;
import org.eclipse.smarthome.core.library.items.ColorItem;
import org.eclipse.smarthome.core.library.items.ContactItem;
import org.eclipse.smarthome.core.library.items.DateTimeItem;
import org.eclipse.smarthome.core.library.items.DimmerItem;
import org.eclipse.smarthome.core.library.items.ImageItem;
import org.eclipse.smarthome.core.library.items.LocationItem;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.items.PlayerItem;
import org.eclipse.smarthome.core.library.items.RollershutterItem;
import org.eclipse.smarthome.core.library.items.StringItem;
import org.eclipse.smarthome.core.library.items.SwitchItem;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class CoreItemFactory
implements ItemFactory {
    public static final @NonNull String CALL = "Call";
    public static final @NonNull String COLOR = "Color";
    public static final @NonNull String CONTACT = "Contact";
    public static final @NonNull String DATETIME = "DateTime";
    public static final @NonNull String DIMMER = "Dimmer";
    public static final @NonNull String IMAGE = "Image";
    public static final @NonNull String LOCATION = "Location";
    public static final @NonNull String NUMBER = "Number";
    public static final @NonNull String PLAYER = "Player";
    public static final @NonNull String ROLLERSHUTTER = "Rollershutter";
    public static final @NonNull String STRING = "String";
    public static final @NonNull String SWITCH = "Switch";

    @Override
    public GenericItem createItem(String itemTypeName, String itemName) {
        switch (itemTypeName) {
            case "Call": {
                return new CallItem(itemName);
            }
            case "Color": {
                return new ColorItem(itemName);
            }
            case "Contact": {
                return new ContactItem(itemName);
            }
            case "DateTime": {
                return new DateTimeItem(itemName);
            }
            case "Dimmer": {
                return new DimmerItem(itemName);
            }
            case "Image": {
                return new ImageItem(itemName);
            }
            case "Location": {
                return new LocationItem(itemName);
            }
            case "Number": {
                return new NumberItem(itemName);
            }
            case "Player": {
                return new PlayerItem(itemName);
            }
            case "Rollershutter": {
                return new RollershutterItem(itemName);
            }
            case "String": {
                return new StringItem(itemName);
            }
            case "Switch": {
                return new SwitchItem(itemName);
            }
        }
        return null;
    }

    @Override
    public String[] getSupportedItemTypes() {
        return new String[]{SWITCH, ROLLERSHUTTER, CONTACT, STRING, NUMBER, DIMMER, DATETIME, COLOR, IMAGE, PLAYER, LOCATION, CALL};
    }
}

