/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.net;

import java.net.InetAddress;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public class CidrAddress {
    private final InetAddress address;
    private final int prefix;

    public CidrAddress(@NonNull InetAddress address, short networkPrefixLength) {
        this.address = address;
        this.prefix = networkPrefixLength;
    }

    public String toString() {
        if (this.prefix == 0) {
            return this.address.getHostAddress();
        }
        return String.valueOf(this.address.getHostAddress()) + "/" + String.valueOf(this.prefix);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CidrAddress)) {
            return false;
        }
        CidrAddress c = (CidrAddress)o;
        return c.getAddress().equals(this.getAddress()) && c.getPrefix() == this.getPrefix();
    }

    public int hashCode() {
        return Objects.hash(this.getAddress().hashCode(), this.getPrefix());
    }

    public int getPrefix() {
        return this.prefix;
    }

    public InetAddress getAddress() {
        return this.address;
    }
}

