/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scheduler;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.scheduler.AbstractExpressionPart;
import org.eclipse.smarthome.core.scheduler.Expression;
import org.eclipse.smarthome.core.scheduler.ExpressionPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExpression<E extends AbstractExpressionPart>
implements Expression {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private int minimumCandidates = 1;
    private int maximumCandidates = 100;
    private String expression;
    private String delimiters;
    private List<@NonNull E> expressionParts = Collections.emptyList();
    private boolean continueSearch;
    private List<Date> candidates = new ArrayList<Date>();
    private Date startDate = null;
    private TimeZone timeZone = null;

    public AbstractExpression(String expression, String delimiters, Date startDate, TimeZone timeZone, int minimumCandidates, int maximumCandidates) throws ParseException {
        if (expression == null) {
            throw new IllegalArgumentException("The expression cannot be null");
        }
        this.expression = expression;
        this.delimiters = delimiters;
        this.startDate = startDate;
        this.timeZone = timeZone;
        this.minimumCandidates = minimumCandidates;
        this.maximumCandidates = maximumCandidates;
        if (startDate == null) {
            throw new IllegalArgumentException("The start date of the rule must not be null");
        }
        this.setStartDate(startDate);
        this.setTimeZone(timeZone);
        this.parseExpression(expression);
    }

    @Override
    public final Date getStartDate() {
        if (this.startDate == null) {
            try {
                this.setStartDate(Calendar.getInstance(this.getTimeZone()).getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) throws IllegalArgumentException, ParseException {
        if (startDate == null) {
            throw new IllegalArgumentException("The start date of the rule must not be null");
        }
        this.startDate = startDate;
        this.logger.trace("Setting the start date to {}", (Object)startDate);
        this.parseExpression(this.expression);
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    @Override
    public final void setTimeZone(TimeZone timeZone) throws IllegalArgumentException, ParseException {
        if (timeZone == null) {
            throw new IllegalArgumentException("The time zone must not be null");
        }
        this.timeZone = timeZone;
        this.parseExpression(this.expression);
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String expression) throws ParseException {
        this.expression = expression;
        this.parseExpression(expression);
    }

    public String toString() {
        return this.expression;
    }

    public final void parseExpression(String expression) throws ParseException, IllegalArgumentException {
        this.parseExpression(expression, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseExpression(String expression, boolean searchMode) throws ParseException, IllegalArgumentException {
        Object token;
        StringTokenizer expressionTokenizer = new StringTokenizer(expression, this.delimiters, false);
        int position = 0;
        this.setCandidates(new ArrayList<Date>());
        LinkedList<E> parts = new LinkedList<E>();
        while (expressionTokenizer.hasMoreTokens()) {
            token = expressionTokenizer.nextToken().trim();
            parts.add(this.parseToken((String)token, ++position));
        }
        this.setExpressionParts(parts);
        this.validateExpression();
        if (this.startDate == null) {
            this.setStartDate(Calendar.getInstance().getTime());
        }
        this.applyExpressionParts(searchMode);
        token = this;
        synchronized (token) {
            this.continueSearch = true;
            while (this.getCandidates().size() < this.minimumCandidates && this.continueSearch) {
                this.populateWithSeeds();
                this.getCandidates().clear();
                this.applyExpressionParts(searchMode);
            }
            this.continueSearch = false;
        }
        if (this.logger.isTraceEnabled()) {
            for (Date aDate : this.getCandidates()) {
                this.logger.trace("Final candidate {} is {}", (Object)this.getCandidates().indexOf(aDate), (Object)aDate);
            }
        }
    }

    protected abstract void validateExpression() throws IllegalArgumentException;

    protected void applyExpressionParts(boolean searchMode) {
        for (ExpressionPart part : this.getExpressionParts()) {
            this.logger.trace("Expanding {} from {} candidates", (Object)part.getClass().getSimpleName(), (Object)this.getCandidates().size());
            this.setCandidates(part.apply(this.startDate, this.getCandidates()));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Expanded to {} candidates", (Object)this.getCandidates().size());
                for (Date aDate : this.getCandidates()) {
                    this.logger.trace("Candidate {} is {}", (Object)this.getCandidates().indexOf(aDate), (Object)aDate);
                }
            }
            if (searchMode) {
                this.pruneFarthest();
                continue;
            }
            this.pruneNearest();
        }
    }

    protected void pruneFarthest() {
        Collections.sort(this.getCandidates());
        ArrayList<Date> beforeDates = new ArrayList<Date>();
        for (Date candidate : this.getCandidates()) {
            if (!candidate.before(this.startDate)) continue;
            beforeDates.add(candidate);
        }
        this.getCandidates().removeAll(beforeDates);
        if (this.getCandidates().size() > this.maximumCandidates) {
            this.logger.trace("Pruning from {} to {} nearest candidates", (Object)this.getCandidates().size(), (Object)this.maximumCandidates);
            int size = this.getCandidates().size();
            int i = this.maximumCandidates;
            while (i < size) {
                this.getCandidates().remove(this.getCandidates().size() - 1);
                ++i;
            }
        }
    }

    protected void pruneNearest() {
        Collections.sort(this.getCandidates());
        ArrayList<Date> beforeDates = new ArrayList<Date>();
        for (Date candidate : this.getCandidates()) {
            if (!candidate.before(this.startDate)) continue;
            beforeDates.add(candidate);
        }
        this.getCandidates().removeAll(beforeDates);
        if (this.getCandidates().size() > this.maximumCandidates) {
            this.logger.trace("Pruning from {} to {} farthest candidates", (Object)this.getCandidates().size(), (Object)this.maximumCandidates);
            int size = this.getCandidates().size();
            int i = 1;
            while (i <= size - this.maximumCandidates) {
                this.getCandidates().remove(0);
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Date getTimeAfter(Date afterTime) {
        block11: {
            currentStartDate = this.getStartDate();
            if (this.hasFloatingStartDate()) {
                try {
                    this.clearCandidates();
                    this.setStartDate(afterTime);
                }
                catch (IllegalArgumentException | ParseException e) {
                    this.logger.error("An exception occurred while setting the start date : '{}'", (Object)e.getMessage());
                }
            } else if (this.getCandidates().isEmpty()) {
                try {
                    this.setStartDate(afterTime);
                }
                catch (ParseException e) {
                    this.logger.error("An exception occurred while setting the start date : '{}'", (Object)e.getMessage());
                }
            }
            if (this.getCandidates().isEmpty()) break block11;
            if (this.getCandidates().size() != 1) ** GOTO lbl33
            return this.getCandidates().get(0);
lbl-1000:
            // 1 sources

            {
                Collections.sort(this.getCandidates());
                newStartDate = null;
                try {
                    var5_8 = this.getCandidates().iterator();
                    while (var5_8.hasNext()) {
                        newStartDate = candidate = var5_8.next();
                        if (!candidate.after(afterTime)) continue;
                        this.setStartDate(currentStartDate);
                        return candidate;
                    }
                    this.clearCandidates();
                    this.setStartDate(newStartDate);
                    continue;
                }
                catch (IllegalArgumentException | ParseException e) {
                    this.logger.error("An exception occurred while parsing the expression : '{}'", (Object)e.getMessage());
                }
lbl33:
                // 3 sources

                ** while (this.getCandidates().size() > 1)
            }
        }
        return null;
    }

    @Override
    public Date getFinalFireTime() {
        try {
            this.parseExpression(this.getExpression(), false);
        }
        catch (ParseException e) {
            this.logger.error("An exception occurred while parsing the expression : '{}'", (Object)e.getMessage());
        }
        Date lastCandidate = null;
        if (!this.getCandidates().isEmpty()) {
            lastCandidate = this.getCandidates().get(this.getCandidates().size() - 1);
        }
        return lastCandidate;
    }

    protected abstract E parseToken(String var1, int var2) throws ParseException;

    protected abstract void populateWithSeeds();

    public <T extends ExpressionPart> T getExpressionPart(Class<T> part) {
        for (ExpressionPart aPart : this.getExpressionParts()) {
            if (!aPart.getClass().equals(part)) continue;
            return (T)((ExpressionPart)part.cast(aPart));
        }
        return null;
    }

    protected List<Date> getCandidates() {
        return this.candidates;
    }

    protected void setCandidates(List<Date> candidates) {
        this.candidates = candidates;
    }

    protected void clearCandidates() {
        this.candidates = null;
    }

    public List<@NonNull E> getExpressionParts() {
        return this.expressionParts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpressionParts(List<@NonNull E> expressionParts) {
        AbstractExpression abstractExpression = this;
        synchronized (abstractExpression) {
            Collections.sort(expressionParts);
            this.expressionParts = Collections.unmodifiableList(new LinkedList<E>(expressionParts));
        }
    }
}

