/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scheduler;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.scheduler.AbstractExpression;
import org.eclipse.smarthome.core.scheduler.AbstractExpressionPart;
import org.eclipse.smarthome.core.scheduler.ExpressionPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CronExpression
extends AbstractExpression<CronExpressionPart> {
    private final Logger logger = LoggerFactory.getLogger(CronExpression.class);

    public CronExpression(String expression) throws ParseException {
        this(expression, Calendar.getInstance().getTime(), TimeZone.getDefault());
    }

    public CronExpression(String expression, Date startTime) throws ParseException {
        this(expression, startTime, TimeZone.getDefault());
    }

    public CronExpression(String expression, Date startTime, TimeZone zone) throws ParseException {
        super(expression, " \t", startTime, zone, 0, 2);
    }

    @Override
    public void setStartDate(Date startDate) throws IllegalArgumentException, ParseException {
        if (startDate == null) {
            throw new IllegalArgumentException("The start date of the rule can not be null");
        }
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(startDate);
        if (calendar.get(14) != 0) {
            calendar.add(13, 1);
            calendar.set(14, 0);
        }
        super.setStartDate(calendar.getTime());
    }

    @Override
    public boolean isSatisfiedBy(Date date) {
        Calendar testDateCal = Calendar.getInstance(this.getTimeZone());
        testDateCal.setTime(date);
        testDateCal.set(14, 0);
        Date originalDate = testDateCal.getTime();
        testDateCal.add(13, -1);
        Date timeAfter = this.getTimeAfter(testDateCal.getTime());
        return timeAfter != null && timeAfter.equals(originalDate);
    }

    public static boolean isValidExpression(String cronExpression) {
        try {
            new CronExpression(cronExpression);
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void validateExpression() throws IllegalArgumentException {
        DayOfMonthExpressionPart domPart = this.getExpressionPart(DayOfMonthExpressionPart.class);
        DayOfWeekExpressionPart dowPart = this.getExpressionPart(DayOfWeekExpressionPart.class);
        if (domPart.isNotSpecific() && dowPart.isNotSpecific()) {
            throw new IllegalArgumentException("The DayOfMonth and DayOfWeek rule parts CAN NOT be not specific at the same time.");
        }
        YearsExpressionPart yearsPart = this.getExpressionPart(YearsExpressionPart.class);
        if (yearsPart == null) {
            List<@NonNull E> ep = this.getExpressionParts();
            LinkedList<@NonNull E> parts = new LinkedList();
            parts.addAll(ep);
            try {
                parts.add(new YearsExpressionPart("*"));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Year rule part must contain * as a token");
            }
            this.setExpressionParts(parts);
        }
    }

    @Override
    protected void populateWithSeeds() {
        AbstractExpressionPart.BoundedIntegerSet set;
        YearsExpressionPart thePart = null;
        for (ExpressionPart part : this.getExpressionParts()) {
            if (!(part instanceof YearsExpressionPart)) continue;
            thePart = (YearsExpressionPart)part;
            break;
        }
        YearsExpressionPart yep = null;
        try {
            yep = new YearsExpressionPart("");
        }
        catch (ParseException e) {
            this.logger.error("An exception occurred while creating an expression part : '{}'", (Object)e.getMessage());
            return;
        }
        if (thePart == null) {
            set = yep.getValueSet();
            Calendar cal = Calendar.getInstance(this.getTimeZone());
            cal.setTime(this.getStartDate());
            int currentYear = cal.get(1);
            int i = 0;
            while (i < 10) {
                set.add(currentYear++);
                ++i;
            }
            yep.setValueSet(set);
            this.getExpressionParts().add(yep);
        } else {
            set = thePart.getValueSet();
            int maxYear = (Integer)set.last();
            int i = 0;
            while (i < 10) {
                if (maxYear < 2100) {
                    set.add(maxYear++);
                }
                ++i;
            }
        }
    }

    @Override
    protected CronExpressionPart parseToken(String token, int position) throws ParseException {
        switch (position) {
            case 1: {
                return new SecondsExpressionPart(token);
            }
            case 2: {
                return new MinutesExpressionPart(token);
            }
            case 3: {
                return new HoursExpressionPart(token);
            }
            case 4: {
                return new DayOfMonthExpressionPart(token);
            }
            case 5: {
                return new MonthsExpressionPart(token);
            }
            case 6: {
                return new DayOfWeekExpressionPart(token);
            }
            case 7: {
                return new YearsExpressionPart(token);
            }
        }
        return null;
    }

    @Override
    public boolean hasFloatingStartDate() {
        return true;
    }

    protected abstract class CronExpressionPart
    extends AbstractExpressionPart {
        public CronExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public final void parse() throws ParseException {
            this.setValueSet(this.initializeValueSet());
            StringTokenizer valueTokenizer = new StringTokenizer(this.getPart(), ",");
            while (valueTokenizer.hasMoreTokens()) {
                String v = valueTokenizer.nextToken();
                this.parseToken(v);
            }
        }

        abstract String getSpecialToken(String var1);

        abstract void parseToken(String var1) throws ParseException;
    }

    protected class DayOfMonthExpressionPart
    extends CronExpressionPart {
        protected static final int MIN_MONTHDAY = 1;
        protected static final int MAX_MONTHDAY = 31;
        protected boolean isLastDayOfMonth;
        protected boolean isLastWeekDayOfMonth;
        protected boolean isNearestWeekDay;
        protected boolean isNotSpecific;
        protected int weekDay;
        protected int monthOffset;

        public boolean isLastDayOfMonth() {
            return this.isLastDayOfMonth;
        }

        public boolean isLastWeekDayOfMonth() {
            return this.isLastWeekDayOfMonth;
        }

        public boolean isNearestWeekDay() {
            return this.isNearestWeekDay;
        }

        public boolean isNotSpecific() {
            return this.isNotSpecific;
        }

        public DayOfMonthExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public int order() {
            return 3;
        }

        @Override
        String getSpecialToken(String token) {
            if (token.equals("*") || token.equals("?") || token.equals("LW")) {
                return token;
            }
            if (token.contains("-") && !token.contains("L")) {
                return "-";
            }
            if (token.contains("L") && !token.equals("LW")) {
                return "L";
            }
            if (token.contains("W") && !token.equals("LW")) {
                return "W";
            }
            if (token.contains("/")) {
                return "/";
            }
            return "";
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(this, 1, 31, false, true);
        }

        @Override
        void parseToken(String v) throws ParseException {
            switch (this.getSpecialToken(v)) {
                case "-": {
                    String from = StringUtils.substringBefore((String)v, (String)"-");
                    String to = StringUtils.substringAfter((String)v, (String)"-");
                    this.getValueSet().add(Integer.parseInt(from), Integer.parseInt(to), 1);
                    break;
                }
                case "/": {
                    String from = StringUtils.substringBefore((String)v, (String)"/");
                    String increment = StringUtils.substringAfter((String)v, (String)"/");
                    try {
                        if (Integer.parseInt(increment) > 31) {
                            throw new ParseException("Increment is too large", 0);
                        }
                    }
                    catch (Exception e) {
                        throw new ParseException("Increment '" + v + "' is not a valid value", 0);
                    }
                    int fromValue = from.equals("*") ? 0 : Integer.parseInt(from);
                    this.getValueSet().add(fromValue, 31, Integer.parseInt(increment));
                    break;
                }
                case "*": {
                    this.getValueSet().add(1, Calendar.getInstance(CronExpression.this.getTimeZone()).getActualMaximum(5), 1);
                    break;
                }
                case "?": {
                    this.isNotSpecific = true;
                    break;
                }
                case "L": {
                    this.isLastDayOfMonth = true;
                    int n = this.monthOffset = StringUtils.substringAfter((String)v, (String)"L-").equals("") ? 0 : Integer.parseInt(StringUtils.substringAfter((String)v, (String)"L-"));
                    if (this.monthOffset <= 30) break;
                    throw new ParseException("Offset from last day must be <= 30", 0);
                }
                case "W": {
                    if (StringUtils.substringBefore((String)v, (String)"W").equals("")) {
                        throw new ParseException("'W' option need to specify a number", 0);
                    }
                    this.isNearestWeekDay = true;
                    this.weekDay = Integer.parseInt(StringUtils.substringBefore((String)v, (String)"W"));
                    if (this.weekDay <= 31) break;
                    throw new ParseException("'W' option can not be larger than 31", 0);
                }
                case "LW": {
                    this.isLastWeekDayOfMonth = true;
                    break;
                }
                default: {
                    try {
                        this.getValueSet().add(Integer.parseInt(v));
                        break;
                    }
                    catch (Exception e) {
                        throw new ParseException("'" + v + "' is not a valid token", 0);
                    }
                }
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            if (!this.isNotSpecific) {
                Calendar cal = Calendar.getInstance(CronExpression.this.getTimeZone());
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                ArrayList<Date> oldCandidates = new ArrayList<Date>();
                if (candidates.isEmpty()) {
                    candidates.add(startDate);
                }
                oldCandidates.addAll(candidates);
                for (Date date : candidates) {
                    cal.setTime(date);
                    if (this.isLastDayOfMonth) {
                        cal.set(5, cal.getActualMaximum(5));
                        continue;
                    }
                    if (this.isLastWeekDayOfMonth) {
                        cal.set(7, 6);
                        cal.set(8, -1);
                        continue;
                    }
                    if (this.isNearestWeekDay) {
                        cal.set(5, this.weekDay);
                        if (cal.get(7) == 7) {
                            if (this.weekDay == 1) {
                                cal.add(5, 2);
                                continue;
                            }
                            cal.add(5, -1);
                            continue;
                        }
                        if (cal.get(7) != 1) continue;
                        if (this.weekDay == cal.getActualMaximum(5)) {
                            cal.add(5, -1);
                            continue;
                        }
                        cal.add(5, 1);
                        continue;
                    }
                    for (Integer element : this.getValueSet()) {
                        cal.setTime(date);
                        if (element > cal.getActualMaximum(5)) continue;
                        cal.set(5, element);
                        newCandidates.add(cal.getTime());
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            }
            return candidates;
        }
    }

    protected class DayOfWeekExpressionPart
    extends CronExpressionPart {
        protected static final int MIN_DAYWEEK = 1;
        protected static final int MAX_DAYWEEK = 7;
        protected boolean isLastDayOfMonth;
        protected boolean isLastDayOfWeek;
        protected boolean isNotSpecific;
        protected boolean isInstanceOfWeekday;
        protected int weekDay;
        protected int instanceOfMonth;
        protected int monthOffset;

        public boolean isLastDayOfMonth() {
            return this.isLastDayOfMonth;
        }

        public boolean isLastDayOfWeek() {
            return this.isLastDayOfWeek;
        }

        public boolean isInstanceOfWeekday() {
            return this.isInstanceOfWeekday;
        }

        public boolean isNotSpecific() {
            return this.isNotSpecific;
        }

        public DayOfWeekExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public int order() {
            return 4;
        }

        @Override
        String getSpecialToken(String token) {
            if (token.equals("*") || token.equals("?")) {
                return token;
            }
            if (token.contains("#")) {
                return "#";
            }
            if (token.contains("-") && !token.contains("L")) {
                return "-";
            }
            if (token.contains("L")) {
                return "L";
            }
            if (token.contains("/")) {
                return "/";
            }
            return "";
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(this, 1, 7, false, true);
        }

        protected int dayAsInteger(String dayAsString) throws ParseException {
            try {
                return WeekDay.getWeekDay(dayAsString).getCalendarDay();
            }
            catch (IllegalArgumentException e) {
                try {
                    return Integer.parseInt(dayAsString);
                }
                catch (Exception f) {
                    throw new ParseException("Invalid Day of Week value: '" + dayAsString + "'", 0);
                }
            }
        }

        @Override
        void parseToken(String v) throws ParseException {
            switch (this.getSpecialToken(v)) {
                case "-": {
                    String from = StringUtils.substringBefore((String)v, (String)"-");
                    String to = StringUtils.substringAfter((String)v, (String)"-");
                    this.getValueSet().add(this.dayAsInteger(from), this.dayAsInteger(to), 1);
                    break;
                }
                case "/": {
                    String from = StringUtils.substringBefore((String)v, (String)"/");
                    String increment = StringUtils.substringAfter((String)v, (String)"/");
                    try {
                        if (this.dayAsInteger(increment) > 7) {
                            throw new ParseException("Increment is too large", 0);
                        }
                    }
                    catch (Exception e) {
                        throw new ParseException("Increment '" + v + "' is not a valid value", 0);
                    }
                    int fromValue = from.equals("*") ? 0 : this.dayAsInteger(from);
                    this.getValueSet().add(fromValue, 7, this.dayAsInteger(increment));
                    break;
                }
                case "*": {
                    this.getValueSet().add(1, 7, 1);
                    break;
                }
                case "?": {
                    this.isNotSpecific = true;
                    break;
                }
                case "L": {
                    int n = this.monthOffset = StringUtils.substringBefore((String)v, (String)"L").equals("") ? 0 : Integer.parseInt(StringUtils.substringBefore((String)v, (String)"L"));
                    if (this.monthOffset == 0) {
                        this.isLastDayOfWeek = true;
                        break;
                    }
                    this.isLastDayOfMonth = true;
                    break;
                }
                case "#": {
                    this.weekDay = this.dayAsInteger(StringUtils.substringBefore((String)v, (String)"#"));
                    this.instanceOfMonth = Integer.parseInt(StringUtils.substringAfter((String)v, (String)"#"));
                    if (this.instanceOfMonth < 1 || this.instanceOfMonth > 5) {
                        throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", 0);
                    }
                    this.isInstanceOfWeekday = true;
                    break;
                }
                default: {
                    try {
                        this.getValueSet().add(this.dayAsInteger(v));
                        break;
                    }
                    catch (Exception e) {
                        throw new ParseException("'" + v + "' is not a valid token", 0);
                    }
                }
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            if (!this.isNotSpecific) {
                Calendar cal = Calendar.getInstance(CronExpression.this.getTimeZone());
                ArrayList<Date> oldCandidates = new ArrayList<Date>();
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                if (candidates.isEmpty()) {
                    candidates.add(startDate);
                }
                oldCandidates.addAll(candidates);
                for (Date date : candidates) {
                    cal.setTime(date);
                    if (this.isLastDayOfMonth) {
                        cal.set(7, this.monthOffset);
                        cal.set(8, -1);
                        newCandidates.add(cal.getTime());
                        continue;
                    }
                    if (this.isLastDayOfWeek) {
                        cal.set(7, 7);
                        newCandidates.add(cal.getTime());
                        continue;
                    }
                    if (this.isInstanceOfWeekday) {
                        cal.set(7, this.weekDay);
                        cal.set(8, this.instanceOfMonth);
                        newCandidates.add(cal.getTime());
                        continue;
                    }
                    Calendar current = Calendar.getInstance();
                    current.setTime(date);
                    int i = 1;
                    while (i <= 6) {
                        cal.setTime(date);
                        cal.set(4, i);
                        Date weekInMonth = cal.getTime();
                        for (Integer element : this.getValueSet()) {
                            cal.setTime(weekInMonth);
                            cal.set(7, element);
                            if (cal.get(2) != current.get(2)) continue;
                            newCandidates.add(cal.getTime());
                        }
                        ++i;
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            }
            return candidates;
        }
    }

    protected class HoursExpressionPart
    extends CronExpressionPart {
        protected static final int MIN_HOUR = 0;
        protected static final int MAX_HOUR = 23;

        public HoursExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public int order() {
            return 5;
        }

        @Override
        String getSpecialToken(String token) {
            if (token.equals("*")) {
                return token;
            }
            if (token.contains("-")) {
                return "-";
            }
            if (token.contains("/")) {
                return "/";
            }
            return "";
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(this, 0, 23, false, false);
        }

        @Override
        void parseToken(String v) throws ParseException {
            switch (this.getSpecialToken(v)) {
                case "-": {
                    String from = StringUtils.substringBefore((String)v, (String)"-");
                    String to = StringUtils.substringAfter((String)v, (String)"-");
                    this.getValueSet().add(Integer.parseInt(from), Integer.parseInt(to), 1);
                    break;
                }
                case "/": {
                    String from = StringUtils.substringBefore((String)v, (String)"/");
                    String increment = StringUtils.substringAfter((String)v, (String)"/");
                    try {
                        if (Integer.parseInt(increment) > 23) {
                            throw new ParseException("Increment is too large", 0);
                        }
                    }
                    catch (Exception e) {
                        throw new ParseException("Increment '" + v + "' is not a valid value", 0);
                    }
                    int fromValue = from.equals("*") ? 0 : Integer.parseInt(from);
                    this.getValueSet().add(fromValue, 23, Integer.parseInt(increment));
                    break;
                }
                case "*": {
                    this.getValueSet().add(0, 23, 1);
                    break;
                }
                default: {
                    try {
                        this.getValueSet().add(Integer.parseInt(v));
                        break;
                    }
                    catch (Exception e) {
                        throw new ParseException("'" + v + "' is not a valid token", 0);
                    }
                }
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            Calendar cal = Calendar.getInstance(CronExpression.this.getTimeZone());
            ArrayList<Date> newCandidates = new ArrayList<Date>();
            ArrayList<Date> oldCandidates = new ArrayList<Date>();
            if (candidates.isEmpty()) {
                candidates.add(startDate);
            }
            oldCandidates.addAll(candidates);
            for (Date date : candidates) {
                for (Integer element : this.getValueSet()) {
                    cal.setTime(date);
                    cal.set(11, element);
                    newCandidates.add(cal.getTime());
                }
            }
            candidates.removeAll(oldCandidates);
            candidates.addAll(newCandidates);
            return candidates;
        }
    }

    protected class MinutesExpressionPart
    extends CronExpressionPart {
        protected static final int MIN_MINUTE = 0;
        protected static final int MAX_MINUTE = 59;

        public MinutesExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public int order() {
            return 6;
        }

        @Override
        String getSpecialToken(String token) {
            if (token.equals("*")) {
                return token;
            }
            if (token.contains("-")) {
                return "-";
            }
            if (token.contains("/")) {
                return "/";
            }
            return "";
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(this, 0, 59, false, false);
        }

        @Override
        void parseToken(String v) throws ParseException {
            switch (this.getSpecialToken(v)) {
                case "-": {
                    String from = StringUtils.substringBefore((String)v, (String)"-");
                    String to = StringUtils.substringAfter((String)v, (String)"-");
                    this.getValueSet().add(Integer.parseInt(from), Integer.parseInt(to), 1);
                    break;
                }
                case "/": {
                    String from = StringUtils.substringBefore((String)v, (String)"/");
                    String increment = StringUtils.substringAfter((String)v, (String)"/");
                    try {
                        if (Integer.parseInt(increment) > 59) {
                            throw new ParseException("Increment is too large", 0);
                        }
                    }
                    catch (Exception e) {
                        throw new ParseException("Increment '" + v + "' is not a valid value", 0);
                    }
                    int fromValue = from.equals("*") ? 0 : Integer.parseInt(from);
                    this.getValueSet().add(fromValue, 59, Integer.parseInt(increment));
                    break;
                }
                case "*": {
                    this.getValueSet().add(0, 59, 1);
                    break;
                }
                default: {
                    try {
                        this.getValueSet().add(Integer.parseInt(v));
                        break;
                    }
                    catch (Exception e) {
                        throw new ParseException("'" + v + "' is not a valid token", 0);
                    }
                }
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            Calendar cal = Calendar.getInstance(CronExpression.this.getTimeZone());
            ArrayList<Date> newCandidates = new ArrayList<Date>();
            ArrayList<Date> oldCandidates = new ArrayList<Date>();
            if (candidates.isEmpty()) {
                candidates.add(startDate);
            }
            oldCandidates.addAll(candidates);
            for (Date date : candidates) {
                for (Integer element : this.getValueSet()) {
                    cal.setTime(date);
                    cal.set(12, element);
                    newCandidates.add(cal.getTime());
                }
            }
            candidates.removeAll(oldCandidates);
            candidates.addAll(newCandidates);
            return candidates;
        }
    }

    public static enum Month {
        JANUARY("JAN", 0, 31),
        FEBRUARY("FEB", 1, 28){

            @Override
            public int getNumberOfDays(int year) {
                if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                    return 29;
                }
                return 28;
            }
        }
        ,
        MARCH("MAR", 2, 31),
        APRIL("APR", 3, 30),
        MAY("MAY", 4, 31),
        JUNE("JUN", 5, 30),
        JULY("JUL", 6, 31),
        AUGUST("AUG", 7, 31),
        SEPTEMBER("SEP", 8, 30),
        OCTOBER("OCT", 9, 31),
        NOVEMBER("NOV", 10, 30),
        DECEMBER("DEC", 11, 31);

        private final String identifier;
        private final int calendarMonth;
        private final int numberOfDays;

        public static Month getMonth(int calendar) {
            return Month.values()[calendar];
        }

        public static Month getMonth(String id) {
            Month[] monthArray = Month.values();
            int n = monthArray.length;
            int n2 = 0;
            while (n2 < n) {
                Month aMonth = monthArray[n2];
                if (aMonth.toString().equals(id)) {
                    return aMonth;
                }
                ++n2;
            }
            throw new IllegalArgumentException("invalid calendar value " + id);
        }

        private Month(String code, int month, int numberOfDays) {
            this.identifier = code;
            this.calendarMonth = month;
            this.numberOfDays = numberOfDays;
        }

        public int getNumberOfDays(int year) {
            return this.numberOfDays;
        }

        public int getCalendarMonth() {
            return this.calendarMonth;
        }

        public String toString() {
            return this.identifier;
        }
    }

    protected class MonthsExpressionPart
    extends CronExpressionPart {
        protected static final int MIN_MONTH = 1;
        protected static final int MAX_MONTH = 12;

        public MonthsExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public int order() {
            return 2;
        }

        @Override
        String getSpecialToken(String token) {
            if (token.equals("*")) {
                return token;
            }
            if (token.contains("-")) {
                return "-";
            }
            if (token.contains("/")) {
                return "/";
            }
            return "";
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(this, 1, 12, false, true);
        }

        protected int monthAsInteger(String monthAsString) throws ParseException {
            try {
                return Month.getMonth(monthAsString).getCalendarMonth();
            }
            catch (IllegalArgumentException e) {
                try {
                    return Integer.parseInt(monthAsString);
                }
                catch (Exception f) {
                    throw new ParseException("Invalid Month value: '" + monthAsString + "'", 0);
                }
            }
        }

        @Override
        void parseToken(String v) throws ParseException {
            switch (this.getSpecialToken(v)) {
                case "-": {
                    String from = StringUtils.substringBefore((String)v, (String)"-");
                    String to = StringUtils.substringAfter((String)v, (String)"-");
                    this.getValueSet().add(this.monthAsInteger(from), this.monthAsInteger(to), 1);
                    break;
                }
                case "/": {
                    String from = StringUtils.substringBefore((String)v, (String)"/");
                    String increment = StringUtils.substringAfter((String)v, (String)"/");
                    try {
                        if (this.monthAsInteger(increment) > 12) {
                            throw new ParseException("Increment is too large", 0);
                        }
                    }
                    catch (Exception e) {
                        throw new ParseException("Increment '" + v + "' is not a valid value", 0);
                    }
                    int fromValue = from.equals("*") ? 0 : this.monthAsInteger(from);
                    this.getValueSet().add(fromValue, 12, this.monthAsInteger(increment));
                    break;
                }
                case "*": {
                    this.getValueSet().add(1, 12, 1);
                    break;
                }
                default: {
                    try {
                        this.getValueSet().add(this.monthAsInteger(v));
                        break;
                    }
                    catch (Exception e) {
                        throw new ParseException("'" + v + "' is not a valid token", 0);
                    }
                }
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            Calendar cal = Calendar.getInstance(CronExpression.this.getTimeZone());
            ArrayList<Date> newCandidates = new ArrayList<Date>();
            ArrayList<Date> oldCandidates = new ArrayList<Date>();
            if (candidates.isEmpty()) {
                candidates.add(startDate);
            }
            oldCandidates.addAll(candidates);
            for (Date date : candidates) {
                for (Integer element : this.getValueSet()) {
                    cal.setTime(date);
                    cal.roll(2, element - 1 - cal.get(2));
                    newCandidates.add(cal.getTime());
                }
            }
            candidates.removeAll(oldCandidates);
            candidates.addAll(newCandidates);
            return candidates;
        }
    }

    protected class SecondsExpressionPart
    extends CronExpressionPart {
        protected static final int MIN_SECOND = 0;
        protected static final int MAX_SECOND = 59;

        public SecondsExpressionPart(String s) throws ParseException {
            super(s);
            this.parse();
        }

        @Override
        public int order() {
            return 7;
        }

        @Override
        String getSpecialToken(String token) {
            if (token.equals("*")) {
                return token;
            }
            if (token.contains("-")) {
                return "-";
            }
            if (token.contains("/")) {
                return "/";
            }
            return "";
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(this, 0, 59, false, false);
        }

        @Override
        void parseToken(String v) throws ParseException {
            switch (this.getSpecialToken(v)) {
                case "-": {
                    String from = StringUtils.substringBefore((String)v, (String)"-");
                    String to = StringUtils.substringAfter((String)v, (String)"-");
                    this.getValueSet().add(Integer.parseInt(from), Integer.parseInt(to), 1);
                    break;
                }
                case "/": {
                    String from = StringUtils.substringBefore((String)v, (String)"/");
                    String increment = StringUtils.substringAfter((String)v, (String)"/");
                    try {
                        if (Integer.parseInt(increment) > 59) {
                            throw new ParseException("Increment is too large", 0);
                        }
                    }
                    catch (Exception e) {
                        throw new ParseException("Increment '" + v + "' is not a valid value", 0);
                    }
                    int fromValue = from.equals("*") ? 0 : Integer.parseInt(from);
                    this.getValueSet().add(fromValue, 59, Integer.parseInt(increment));
                    break;
                }
                case "*": {
                    this.getValueSet().add(0, 59, 1);
                    break;
                }
                default: {
                    try {
                        this.getValueSet().add(Integer.parseInt(v));
                        break;
                    }
                    catch (Exception e) {
                        throw new ParseException("'" + v + "' is not a valid token", 0);
                    }
                }
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            Calendar cal = Calendar.getInstance(CronExpression.this.getTimeZone());
            ArrayList<Date> newCandidates = new ArrayList<Date>();
            ArrayList<Date> oldCandidates = new ArrayList<Date>();
            if (candidates.isEmpty()) {
                candidates.add(startDate);
            }
            oldCandidates.addAll(candidates);
            for (Date date : candidates) {
                for (Integer element : this.getValueSet()) {
                    cal.setTime(date);
                    cal.set(13, element);
                    newCandidates.add(cal.getTime());
                }
            }
            candidates.removeAll(oldCandidates);
            candidates.addAll(newCandidates);
            return candidates;
        }
    }

    public static enum WeekDay {
        SUNDAY("SUN", 1),
        MONDAY("MON", 2),
        TUESDAY("TUE", 3),
        WEDNESDAY("WED", 4),
        THURSDAY("THU", 5),
        FRIDAY("FRI", 6),
        SATURDAY("SAT", 7);

        private final String identifier;
        private final int calendarDay;

        public static WeekDay getWeekDay(int calendar) {
            return WeekDay.values()[calendar];
        }

        public static WeekDay getWeekDay(String id) {
            WeekDay[] weekDayArray = WeekDay.values();
            int n = weekDayArray.length;
            int n2 = 0;
            while (n2 < n) {
                WeekDay aDay = weekDayArray[n2];
                if (aDay.toString().equals(id)) {
                    return aDay;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid calendar value " + id);
        }

        private WeekDay(String code, int day) {
            this.identifier = code;
            this.calendarDay = day;
        }

        public int getCalendarDay() {
            return this.calendarDay;
        }

        public String toString() {
            return this.identifier;
        }
    }

    protected class YearsExpressionPart
    extends CronExpressionPart {
        protected static final int MIN_YEAR = 1970;
        protected static final int MAX_YEAR = 2100;

        public YearsExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public int order() {
            return 1;
        }

        @Override
        String getSpecialToken(String token) {
            if (token.equals("*")) {
                return token;
            }
            if (token.contains("-")) {
                return "-";
            }
            if (token.contains("/")) {
                return "/";
            }
            return "";
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(this, 1970, 2100, false, false);
        }

        @Override
        void parseToken(String v) throws ParseException {
            switch (this.getSpecialToken(v)) {
                case "-": {
                    String from = StringUtils.substringBefore((String)v, (String)"-");
                    String to = StringUtils.substringAfter((String)v, (String)"-");
                    this.getValueSet().add(Integer.parseInt(from), Integer.parseInt(to), 1);
                    break;
                }
                case "/": {
                    String from = StringUtils.substringBefore((String)v, (String)"/");
                    String increment = StringUtils.substringAfter((String)v, (String)"/");
                    try {
                        if (Integer.parseInt(increment) > 2100) {
                            throw new ParseException("Increment is too large", 0);
                        }
                    }
                    catch (Exception e) {
                        throw new ParseException("Increment '" + v + "' is not a valid value", 0);
                    }
                    int fromValue = from.equals("*") ? 0 : Integer.parseInt(from);
                    this.getValueSet().add(fromValue, 2100, Integer.parseInt(increment));
                    break;
                }
                case "*": {
                    this.getValueSet().add(1970, 2100, 1);
                    break;
                }
                default: {
                    try {
                        this.getValueSet().add(Integer.parseInt(v));
                        break;
                    }
                    catch (Exception e) {
                        throw new ParseException("'" + v + "' is not a valid token", 0);
                    }
                }
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            Calendar cal = Calendar.getInstance(CronExpression.this.getTimeZone());
            ArrayList<Date> newCandidates = new ArrayList<Date>();
            ArrayList<Date> oldCandidates = new ArrayList<Date>();
            if (candidates.isEmpty()) {
                candidates.add(startDate);
            }
            oldCandidates.addAll(candidates);
            for (Date date : candidates) {
                for (Integer element : this.getValueSet()) {
                    cal.setTime(date);
                    cal.set(1, element);
                    newCandidates.add(cal.getTime());
                }
            }
            candidates.removeAll(oldCandidates);
            candidates.addAll(newCandidates);
            return candidates;
        }
    }
}

