/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.service;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.service.ReadyMarker;

public final class ReadyMarkerFilter {
    private final String identifier;
    private final String type;

    public ReadyMarkerFilter() {
        this(null, null);
    }

    private ReadyMarkerFilter(String type, String identifier) {
        this.type = type;
        this.identifier = identifier;
    }

    public boolean apply(@NonNull ReadyMarker readyMarker) {
        return this.isTracked(this.type, readyMarker.getType()) && this.isTracked(this.identifier, readyMarker.getIdentifier());
    }

    private boolean isTracked(String trackingSpec, String realValue) {
        return trackingSpec == null || trackingSpec.equals(realValue);
    }

    public @NonNull ReadyMarkerFilter withType(String type) {
        return new ReadyMarkerFilter(type, this.identifier);
    }

    public @NonNull ReadyMarkerFilter withIdentifier(String identifier) {
        return new ReadyMarkerFilter(this.type, identifier);
    }
}

