/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.thing;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.status.ConfigStatusInfo;
import org.eclipse.smarthome.config.core.status.ConfigStatusService;
import org.eclipse.smarthome.config.core.validation.ConfigValidationException;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ManagedItemProvider;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUID;
import org.eclipse.smarthome.core.thing.dto.ChannelDTO;
import org.eclipse.smarthome.core.thing.dto.ChannelDTOMapper;
import org.eclipse.smarthome.core.thing.dto.ThingDTO;
import org.eclipse.smarthome.core.thing.dto.ThingDTOMapper;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatusInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateService;
import org.eclipse.smarthome.core.thing.firmware.dto.FirmwareStatusDTO;
import org.eclipse.smarthome.core.thing.i18n.ThingStatusInfoI18nLocalizationService;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.link.ManagedItemChannelLinkProvider;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.thing.util.ThingHelper;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.Stream2JSONInputStream;
import org.eclipse.smarthome.io.rest.core.thing.EnrichedThingDTO;
import org.eclipse.smarthome.io.rest.core.thing.EnrichedThingDTOMapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="things")
@Api(value="things")
@Component(service={RESTResource.class, ThingResource.class})
public class ThingResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(ThingResource.class);
    public static final String PATH_THINGS = "things";
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private ItemFactory itemFactory;
    private ItemRegistry itemRegistry;
    private ManagedItemChannelLinkProvider managedItemChannelLinkProvider;
    private ManagedItemProvider managedItemProvider;
    private ManagedThingProvider managedThingProvider;
    private ThingRegistry thingRegistry;
    private ConfigStatusService configStatusService;
    private ConfigDescriptionRegistry configDescRegistry;
    private ThingTypeRegistry thingTypeRegistry;
    private ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService;
    private FirmwareUpdateService firmwareUpdateService;
    @Context
    private UriInfo uriInfo;

    @POST
    @RolesAllowed(value={"administrator"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new thing and adds it to the registry.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=String.class), @ApiResponse(code=400, message="A uid must be provided, if no binding can create a thing of this type."), @ApiResponse(code=409, message="A thing with the same uid already exists.")})
    public Response create(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @ApiParam(value="thing data", required=true) ThingDTO thingBean) {
        Configuration configuration;
        Thing thing;
        Thing thing2;
        Locale locale = LocaleUtil.getLocale((String)language);
        ThingUID thingUID = thingBean.UID == null ? null : new ThingUID(thingBean.UID);
        ThingTypeUID thingTypeUID = new ThingTypeUID(thingBean.thingTypeUID);
        if (thingUID != null && (thing2 = this.thingRegistry.get(thingUID)) != null) {
            return this.getThingResponse(Response.Status.CONFLICT, thing2, locale, "Thing " + thingUID.toString() + " already exists!");
        }
        ThingUID bridgeUID = null;
        if (thingBean.bridgeUID != null) {
            bridgeUID = new ThingUID(thingBean.bridgeUID);
        }
        if ((thing = this.thingRegistry.createThingOfType(thingTypeUID, thingUID, bridgeUID, thingBean.label, configuration = new Configuration(this.normalizeConfiguration(thingBean.configuration, thingTypeUID, thingUID)))) != null) {
            if (thingBean.properties != null) {
                for (Map.Entry entry : thingBean.properties.entrySet()) {
                    thing.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (thingBean.channels != null) {
                ArrayList<Channel> channels = new ArrayList<Channel>();
                for (ChannelDTO channelDTO : thingBean.channels) {
                    channels.add(ChannelDTOMapper.map((ChannelDTO)channelDTO));
                }
                ThingHelper.addChannelsToThing((Thing)thing, channels);
            }
            if (thingBean.location != null) {
                thing.setLocation(thingBean.location);
            }
        } else if (thingUID != null) {
            thing = ThingDTOMapper.map((ThingDTO)thingBean);
        } else {
            return this.getThingResponse(Response.Status.BAD_REQUEST, thing, locale, "A UID must be provided, since no binding can create the thing!");
        }
        this.thingRegistry.add((Identifiable)thing);
        return this.getThingResponse(Response.Status.CREATED, thing, locale, null);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available things.", response=EnrichedThingDTO.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EnrichedThingDTO.class, responseContainer="Set")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        Stream<EnrichedThingDTO> thingStream = this.thingRegistry.stream().map(t -> this.convertToEnrichedThingDTO((Thing)t, locale)).distinct();
        return Response.ok((Object)new Stream2JSONInputStream(thingStream)).build();
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets thing by UID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ThingDTO.class), @ApiResponse(code=404, message="Thing not found.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="thingUID") @ApiParam(value="thingUID") String thingUID) {
        Locale locale = LocaleUtil.getLocale((String)language);
        Thing thing = this.thingRegistry.get(new ThingUID(thingUID));
        if (thing != null) {
            return this.getThingResponse(Response.Status.OK, thing, locale, null);
        }
        return ThingResource.getThingNotFoundResponse(thingUID);
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}")
    @ApiOperation(value="Removes a thing from the registry. Set 'force' to __true__ if you want the thing te be removed immediately.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK, was deleted."), @ApiResponse(code=202, message="ACCEPTED for asynchronous deletion."), @ApiResponse(code=404, message="Thing not found."), @ApiResponse(code=409, message="Thing could not be deleted because it's not editable.")})
    public Response remove(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="thingUID") @ApiParam(value="thingUID") String thingUID, @DefaultValue(value="false") @QueryParam(value="force") @ApiParam(value="force") boolean force) {
        Locale locale = LocaleUtil.getLocale((String)language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP DELETE request for update at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Thing managed = (Thing)this.managedThingProvider.get((Object)thingUIDObject);
        if (managed == null) {
            this.logger.info("Received HTTP DELETE request for update at '{}' for an unmanaged thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot delete Thing " + thingUID + " as it is not editable.");
        }
        if (force) {
            if (this.thingRegistry.forceRemove(thingUIDObject) == null) {
                return this.getThingResponse(Response.Status.INTERNAL_SERVER_ERROR, thing, locale, "Cannot delete Thing " + thingUID + " for unknown reasons.");
            }
        } else if (this.thingRegistry.remove(thingUIDObject) != null) {
            return this.getThingResponse(Response.Status.ACCEPTED, thing, locale, null);
        }
        return Response.ok().build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Updates a thing.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ThingDTO.class), @ApiResponse(code=404, message="Thing not found."), @ApiResponse(code=409, message="Thing could not be updated as it is not editable.")})
    public Response update(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="thingUID") @ApiParam(value="thingUID") String thingUID, @ApiParam(value="thing", required=true) ThingDTO thingBean) throws IOException {
        Locale locale = LocaleUtil.getLocale((String)language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP PUT request for update at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Thing managed = (Thing)this.managedThingProvider.get((Object)thingUIDObject);
        if (managed == null) {
            this.logger.info("Received HTTP PUT request for update at '{}' for an unmanaged thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot update Thing " + thingUID + " as it is not editable.");
        }
        thingBean.configuration = this.normalizeConfiguration(thingBean.configuration, thing.getThingTypeUID(), thing.getUID());
        Thing oldthing = (Thing)this.managedThingProvider.update((Identifiable)(thing = ThingHelper.merge((Thing)thing, (ThingDTO)thingBean)));
        if (oldthing == null) {
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        return this.getThingResponse(Response.Status.OK, thing, locale, null);
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}/config")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Updates thing's configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Thing.class), @ApiResponse(code=400, message="Configuration of the thing is not valid."), @ApiResponse(code=404, message="Thing not found"), @ApiResponse(code=409, message="Thing could not be updated as it is not editable.")})
    public Response updateConfiguration(@HeaderParam(value="Accept-Language") String language, @PathParam(value="thingUID") @ApiParam(value="thing") String thingUID, @ApiParam(value="configuration parameters") Map<String, Object> configurationParameters) throws IOException {
        Locale locale = LocaleUtil.getLocale((String)language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP PUT request for update configuration at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Thing managed = (Thing)this.managedThingProvider.get((Object)thingUIDObject);
        if (managed == null) {
            this.logger.info("Received HTTP PUT request for update configuration at '{}' for an unmanaged thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot update Thing " + thingUID + " as it is not editable.");
        }
        try {
            this.thingRegistry.updateConfiguration(thingUIDObject, new Configuration(this.normalizeConfiguration(configurationParameters, thing.getThingTypeUID(), thing.getUID())).getProperties());
        }
        catch (ConfigValidationException ex) {
            this.logger.debug("Config description validation exception occurred for thingUID {} - Messages: {}", (Object)thingUID, (Object)ex.getValidationMessages());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getValidationMessages(locale)).build();
        }
        catch (Exception ex) {
            this.logger.error("Exception during HTTP PUT request for update config at '{}'", (Object)this.uriInfo.getPath(), (Object)ex);
            return JSONResponse.createResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, null, (String)ex.getMessage());
        }
        return this.getThingResponse(Response.Status.OK, thing, locale, null);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{thingUID}/status")
    @ApiOperation(value="Gets thing's status.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=404, message="Thing not found.")})
    public Response getStatus(@HeaderParam(value="Accept-Language") String language, @PathParam(value="thingUID") @ApiParam(value="thing") String thingUID) throws IOException {
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP GET request for thing config status at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        ThingStatusInfo thingStatusInfo = this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, LocaleUtil.getLocale((String)language));
        return Response.ok().entity((Object)thingStatusInfo).build();
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{thingUID}/config/status")
    @ApiOperation(value="Gets thing's config status.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=404, message="Thing not found.")})
    public Response getConfigStatus(@HeaderParam(value="Accept-Language") String language, @PathParam(value="thingUID") @ApiParam(value="thing") String thingUID) throws IOException {
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP GET request for thing config status at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        ConfigStatusInfo info = this.configStatusService.getConfigStatus(thingUID, LocaleUtil.getLocale((String)language));
        if (info != null) {
            return Response.ok().entity((Object)info.getConfigStatusMessages()).build();
        }
        return Response.ok().entity((Object)Collections.EMPTY_SET).build();
    }

    @PUT
    @Path(value="/{thingUID}/firmware/{firmwareVersion}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update thing firmware.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Firmware update preconditions not satisfied."), @ApiResponse(code=404, message="Thing not found.")})
    public Response updateFirmware(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="thingUID") @ApiParam(value="thing") String thingUID, @PathParam(value="firmwareVersion") @ApiParam(value="version") String firmwareVersion) throws IOException {
        Thing thing = this.thingRegistry.get(new ThingUID(thingUID));
        if (thing == null) {
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        FirmwareUID firmwareUID = new FirmwareUID(thing.getThingTypeUID(), firmwareVersion);
        try {
            this.firmwareUpdateService.updateFirmware(thing.getUID(), firmwareUID, LocaleUtil.getLocale((String)language));
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException ex) {
            return JSONResponse.createResponse((Response.Status)Response.Status.BAD_REQUEST, null, (String)"Firmware update preconditions not satisfied.");
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{thingUID}/firmware/status")
    @ApiOperation(value="Gets thing's firmware status.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=204, message="No firmware status provided by this Thing.")})
    public Response getFirmwareStatus(@HeaderParam(value="Accept-Language") String language, @PathParam(value="thingUID") @ApiParam(value="thing") String thingUID) throws IOException {
        ThingUID thingUIDObject = new ThingUID(thingUID);
        FirmwareStatusInfo info = this.firmwareUpdateService.getFirmwareStatusInfo(thingUIDObject);
        if (info == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return Response.ok().entity((Object)this.buildFirmwareStatusDTO(info)).build();
    }

    private FirmwareStatusDTO getThingFirmwareStatus(ThingUID thingUID) {
        FirmwareStatusInfo info = this.firmwareUpdateService.getFirmwareStatusInfo(thingUID);
        if (info != null) {
            return this.buildFirmwareStatusDTO(info);
        }
        return null;
    }

    private FirmwareStatusDTO buildFirmwareStatusDTO(FirmwareStatusInfo info) {
        String updatableFirmwareVersion = info.getUpdatableFirmwareUID() == null ? null : info.getUpdatableFirmwareUID().getFirmwareVersion();
        return new FirmwareStatusDTO(info.getFirmwareStatus().name(), updatableFirmwareVersion);
    }

    private static Response getThingNotFoundResponse(String thingUID) {
        String message = "Thing " + thingUID + " does not exist!";
        return JSONResponse.createResponse((Response.Status)Response.Status.NOT_FOUND, null, (String)message);
    }

    private Response getThingResponse(Response.Status status, Thing thing, Locale locale, String errormessage) {
        ThingStatusInfo thingStatusInfo = this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, locale);
        boolean managed = this.managedThingProvider.get((Object)thing.getUID()) != null;
        EnrichedThingDTO enrichedThingDTO = thing != null ? EnrichedThingDTOMapper.map(thing, thingStatusInfo, this.getThingFirmwareStatus(thing.getUID()), this.getLinkedItemsMap(thing), managed) : null;
        return JSONResponse.createResponse((Response.Status)status, enrichedThingDTO, (String)errormessage);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setItemFactory(ItemFactory itemFactory) {
        this.itemFactory = itemFactory;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedItemChannelLinkProvider(ManagedItemChannelLinkProvider managedItemChannelLinkProvider) {
        this.managedItemChannelLinkProvider = managedItemChannelLinkProvider;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedItemProvider(ManagedItemProvider managedItemProvider) {
        this.managedItemProvider = managedItemProvider;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = managedThingProvider;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    protected void unsetItemFactory(ItemFactory itemFactory) {
        this.itemFactory = null;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void unsetManagedItemChannelLinkProvider(ManagedItemChannelLinkProvider managedItemChannelLinkProvider) {
        this.managedItemChannelLinkProvider = null;
    }

    protected void unsetManagedItemProvider(ManagedItemProvider managedItemProvider) {
        this.managedItemProvider = null;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigStatusService(ConfigStatusService configStatusService) {
        this.configStatusService = configStatusService;
    }

    protected void unsetConfigStatusService(ConfigStatusService configStatusService) {
        this.configStatusService = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setThingStatusInfoI18nLocalizationService(ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService) {
        this.thingStatusInfoI18nLocalizationService = thingStatusInfoI18nLocalizationService;
    }

    protected void unsetThingStatusInfoI18nLocalizationService(ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService) {
        this.thingStatusInfoI18nLocalizationService = null;
    }

    private EnrichedThingDTO convertToEnrichedThingDTO(Thing thing, Locale locale) {
        boolean managed = this.managedThingProvider.get((Object)thing.getUID()) != null;
        ThingStatusInfo thingStatusInfo = this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, locale);
        return EnrichedThingDTOMapper.map(thing, thingStatusInfo, this.getThingFirmwareStatus(thing.getUID()), this.getLinkedItemsMap(thing), managed);
    }

    private Map<String, Set<String>> getLinkedItemsMap(Thing thing) {
        HashMap<String, Set<String>> linkedItemsMap = new HashMap<String, Set<String>>();
        for (Channel channel : thing.getChannels()) {
            Set linkedItems = this.itemChannelLinkRegistry.getLinkedItemNames((UID)channel.getUID());
            linkedItemsMap.put(channel.getUID().getId(), linkedItems);
        }
        return linkedItemsMap;
    }

    private Channel findChannel(String channelId, Thing thing) {
        for (Channel channel : thing.getChannels()) {
            if (!channel.getUID().getId().equals(channelId)) continue;
            return channel;
        }
        return null;
    }

    private void unlinkChannelIfAlreadyLinked(ChannelUID channelUID) {
        Collection links = this.managedItemChannelLinkProvider.getAll();
        for (ItemChannelLink link : links) {
            if (!link.getLinkedUID().equals((Object)channelUID)) continue;
            this.logger.debug("Channel '{}' is already linked to item '{}' and will be unlinked before it will be linked to the new item.", (Object)channelUID, (Object)link.getItemName());
            this.managedItemChannelLinkProvider.remove((Object)link.getUID());
        }
    }

    public static void updateConfiguration(Thing thing, Configuration configuration) {
        for (String parameterName : configuration.keySet()) {
            thing.getConfiguration().put(parameterName, configuration.get(parameterName));
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setFirmwareUpdateService(FirmwareUpdateService firmwareUpdateService) {
        this.firmwareUpdateService = firmwareUpdateService;
    }

    protected void unsetFirmwareUpdateService(FirmwareUpdateService firmwareUpdateService) {
        this.firmwareUpdateService = null;
    }

    private Map<String, Object> normalizeConfiguration(Map<String, Object> properties, ThingTypeUID thingTypeUID, ThingUID thingUID) {
        ConfigDescription thingConfigDesc;
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        ThingType thingType = this.thingTypeRegistry.getThingType(thingTypeUID);
        if (thingType == null) {
            return properties;
        }
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>(2);
        ConfigDescription typeConfigDesc = this.configDescRegistry.getConfigDescription(thingType.getConfigDescriptionURI());
        if (typeConfigDesc != null) {
            configDescriptions.add(typeConfigDesc);
        }
        if ((thingConfigDesc = this.configDescRegistry.getConfigDescription(this.getConfigDescriptionURI(thingUID))) != null) {
            configDescriptions.add(thingConfigDesc);
        }
        if (configDescriptions.isEmpty()) {
            return properties;
        }
        return ConfigUtil.normalizeTypes(properties, configDescriptions);
    }

    private URI getConfigDescriptionURI(ThingUID thingUID) {
        String uriString = "thing:" + thingUID;
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new BadRequestException("Invalid URI syntax: " + uriString);
        }
    }

    public boolean isSatisfied() {
        return this.itemChannelLinkRegistry != null && this.itemFactory != null && this.itemRegistry != null && this.managedItemChannelLinkProvider != null && this.managedItemProvider != null && this.managedThingProvider != null && this.thingRegistry != null && this.configStatusService != null && this.configDescRegistry != null && this.thingTypeRegistry != null && this.firmwareUpdateService != null && this.thingStatusInfoI18nLocalizationService != null;
    }
}

