/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.thing;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTO;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTOMapper;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.firmware.Firmware;
import org.eclipse.smarthome.core.thing.dto.ChannelDefinitionDTO;
import org.eclipse.smarthome.core.thing.dto.ChannelGroupDefinitionDTO;
import org.eclipse.smarthome.core.thing.dto.StrippedThingTypeDTO;
import org.eclipse.smarthome.core.thing.dto.StrippedThingTypeDTOMapper;
import org.eclipse.smarthome.core.thing.dto.ThingTypeDTO;
import org.eclipse.smarthome.core.thing.firmware.FirmwareRegistry;
import org.eclipse.smarthome.core.thing.firmware.dto.FirmwareDTO;
import org.eclipse.smarthome.core.thing.type.BridgeType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.Stream2JSONInputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="thing-types")
@Api(value="thing-types")
@Component(service={RESTResource.class, ThingTypeResource.class})
public class ThingTypeResource
implements RESTResource {
    public static final String PATH_THINGS_TYPES = "thing-types";
    private final Logger logger = LoggerFactory.getLogger(ThingTypeResource.class);
    private ThingTypeRegistry thingTypeRegistry;
    private ConfigDescriptionRegistry configDescriptionRegistry;
    private FirmwareRegistry firmwareRegistry;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setFirmwareRegistry(FirmwareRegistry firmwareRegistry) {
        this.firmwareRegistry = firmwareRegistry;
    }

    protected void unsetFirmwareRegistry(FirmwareRegistry firmwareRegistry) {
        this.firmwareRegistry = null;
    }

    @GET
    @RolesAllowed(value={"user"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all available thing types without config description, channels and properties.", response=StrippedThingTypeDTO.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=StrippedThingTypeDTO.class, responseContainer="Set")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        Stream<StrippedThingTypeDTO> typeStream = this.thingTypeRegistry.getThingTypes(locale).stream().map(t -> this.convertToStrippedThingTypeDTO((ThingType)t, locale));
        return Response.ok((Object)new Stream2JSONInputStream(typeStream)).build();
    }

    @GET
    @RolesAllowed(value={"user"})
    @Path(value="/{thingTypeUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets thing type by UID.", response=ThingTypeDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Thing type with provided thingTypeUID does not exist.", response=ThingTypeDTO.class), @ApiResponse(code=404, message="No content")})
    public Response getByUID(@PathParam(value="thingTypeUID") @ApiParam(value="thingTypeUID") String thingTypeUID, @HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        ThingType thingType = this.thingTypeRegistry.getThingType(new ThingTypeUID(thingTypeUID), locale);
        if (thingType != null) {
            return Response.ok((Object)this.convertToThingTypeDTO(thingType, locale)).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{thingTypeUID}/firmwares")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available firmwares for provided thingType", response=StrippedThingTypeDTO.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=204, message="No firmwares found.")})
    public Response getFirmwares(@PathParam(value="thingTypeUID") @ApiParam(value="thingTypeUID") String thingTypeUID, @HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language) {
        ThingTypeUID athingTypeUID = new ThingTypeUID(thingTypeUID);
        Collection firmwares = this.firmwareRegistry.getFirmwares(athingTypeUID, LocaleUtil.getLocale((String)language));
        if (firmwares.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        Stream<FirmwareDTO> firmwareStream = firmwares.stream().map(this::convertToFirmwareDTO);
        return Response.ok().entity((Object)new Stream2JSONInputStream(firmwareStream)).build();
    }

    private ThingTypeDTO convertToThingTypeDTO(ThingType thingType, Locale locale) {
        ArrayList parameterGroups;
        List parameters;
        ConfigDescription configDescription = thingType.getConfigDescriptionURI() != null ? this.configDescriptionRegistry.getConfigDescription(thingType.getConfigDescriptionURI(), locale) : null;
        if (configDescription != null) {
            ConfigDescriptionDTO configDescriptionDTO = ConfigDescriptionDTOMapper.map(configDescription);
            parameters = configDescriptionDTO.parameters;
            parameterGroups = configDescriptionDTO.parameterGroups;
        } else {
            parameters = new ArrayList(0);
            parameterGroups = new ArrayList(0);
        }
        List<ChannelDefinitionDTO> channelDefinitions = this.convertToChannelDefinitionDTOs(thingType.getChannelDefinitions(), locale);
        if (channelDefinitions == null) {
            return null;
        }
        return new ThingTypeDTO(thingType.getUID().toString(), thingType.getLabel(), thingType.getDescription(), thingType.getCategory(), thingType.isListed(), parameters, channelDefinitions, this.convertToChannelGroupDefinitionDTOs(thingType.getChannelGroupDefinitions(), locale), thingType.getSupportedBridgeTypeUIDs(), thingType.getProperties(), thingType instanceof BridgeType, parameterGroups, thingType.getExtensibleChannelTypeIds());
    }

    private List<ChannelGroupDefinitionDTO> convertToChannelGroupDefinitionDTOs(List<ChannelGroupDefinition> channelGroupDefinitions, Locale locale) {
        ArrayList<ChannelGroupDefinitionDTO> channelGroupDefinitionDTOs = new ArrayList<ChannelGroupDefinitionDTO>();
        for (ChannelGroupDefinition channelGroupDefinition : channelGroupDefinitions) {
            String description;
            String id = channelGroupDefinition.getId();
            ChannelGroupType channelGroupType = TypeResolver.resolve((ChannelGroupTypeUID)channelGroupDefinition.getTypeUID(), (Locale)locale);
            String label = channelGroupDefinition.getLabel();
            if (label == null) {
                label = channelGroupType.getLabel();
            }
            if ((description = channelGroupDefinition.getDescription()) == null) {
                description = channelGroupType.getDescription();
            }
            List channelDefinitions = channelGroupType.getChannelDefinitions();
            List<ChannelDefinitionDTO> channelDefinitionDTOs = this.convertToChannelDefinitionDTOs(channelDefinitions, locale);
            channelGroupDefinitionDTOs.add(new ChannelGroupDefinitionDTO(id, label, description, channelDefinitionDTOs));
        }
        return channelGroupDefinitionDTOs;
    }

    private List<ChannelDefinitionDTO> convertToChannelDefinitionDTOs(List<ChannelDefinition> channelDefinitions, Locale locale) {
        ArrayList<ChannelDefinitionDTO> channelDefinitionDTOs = new ArrayList<ChannelDefinitionDTO>();
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            String description;
            ChannelType channelType = TypeResolver.resolve((ChannelTypeUID)channelDefinition.getChannelTypeUID(), (Locale)locale);
            if (channelType == null) {
                this.logger.warn("Cannot find channel type: {}", (Object)channelDefinition.getChannelTypeUID());
                return null;
            }
            String label = channelDefinition.getLabel();
            if (label == null) {
                label = channelType.getLabel();
            }
            if ((description = channelDefinition.getDescription()) == null) {
                description = channelType.getDescription();
            }
            ChannelDefinitionDTO channelDefinitionDTO = new ChannelDefinitionDTO(channelDefinition.getId(), channelDefinition.getChannelTypeUID().toString(), label, description, channelType.getTags(), channelType.getCategory(), channelType.getState(), channelType.isAdvanced(), channelDefinition.getProperties());
            channelDefinitionDTOs.add(channelDefinitionDTO);
        }
        return channelDefinitionDTOs;
    }

    private StrippedThingTypeDTO convertToStrippedThingTypeDTO(ThingType thingType, Locale locale) {
        StrippedThingTypeDTO strippedThingTypeDTO = StrippedThingTypeDTOMapper.map((ThingType)thingType, (Locale)locale);
        if (strippedThingTypeDTO != null) {
            return strippedThingTypeDTO;
        }
        this.logger.warn("Cannot create DTO for thingType '{}'. Skip it.", (Object)thingType);
        return null;
    }

    private FirmwareDTO convertToFirmwareDTO(Firmware firmware) {
        return new FirmwareDTO(firmware.getUID().toString(), firmware.getVendor(), firmware.getModel(), firmware.isModelRestricted(), firmware.getDescription(), firmware.getVersion(), firmware.getPrerequisiteVersion(), firmware.getChangelog());
    }

    public boolean isSatisfied() {
        return this.thingTypeRegistry != null && this.configDescriptionRegistry != null && this.firmwareRegistry != null;
    }
}

