/*
 * generated by Xtext 2.12.0
 */
package org.eclipse.smarthome.model.thing.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smarthome.model.thing.services.ThingGrammarAccess;
import org.eclipse.smarthome.model.thing.thing.ModelBridge;
import org.eclipse.smarthome.model.thing.thing.ModelChannel;
import org.eclipse.smarthome.model.thing.thing.ModelProperty;
import org.eclipse.smarthome.model.thing.thing.ModelThing;
import org.eclipse.smarthome.model.thing.thing.ThingModel;
import org.eclipse.smarthome.model.thing.thing.ThingPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public abstract class AbstractThingSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private ThingGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == ThingPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ThingPackage.MODEL_BRIDGE:
				sequence_ModelBridge(context, (ModelBridge) semanticObject); 
				return; 
			case ThingPackage.MODEL_CHANNEL:
				sequence_ModelChannel(context, (ModelChannel) semanticObject); 
				return; 
			case ThingPackage.MODEL_PROPERTY:
				sequence_ModelProperty(context, (ModelProperty) semanticObject); 
				return; 
			case ThingPackage.MODEL_THING:
				sequence_ModelThing(context, (ModelThing) semanticObject); 
				return; 
			case ThingPackage.THING_MODEL:
				sequence_ThingModel(context, (ThingModel) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     ModelPropertyContainer returns ModelBridge
	 *     ModelBridge returns ModelBridge
	 *
	 * Constraint:
	 *     (
	 *         bridge?='Bridge' 
	 *         (id=UID | (thingTypeId=UID_SEGMENT thingId=UID_SEGMENT)) 
	 *         label=STRING? 
	 *         location=STRING? 
	 *         properties+=ModelProperty? 
	 *         properties+=ModelProperty* 
	 *         (things+=ModelThing | things+=ModelBridge)* 
	 *         channels+=ModelChannel*
	 *     )
	 */
	protected void sequence_ModelBridge(ISerializationContext context, ModelBridge semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ModelPropertyContainer returns ModelChannel
	 *     ModelChannel returns ModelChannel
	 *
	 * Constraint:
	 *     (
	 *         (((channelKind='State' | channelKind='Trigger')? type=ModelItemType) | channelType=UID_SEGMENT) 
	 *         id=CHANNEL_ID 
	 *         label=STRING? 
	 *         properties+=ModelProperty? 
	 *         properties+=ModelProperty*
	 *     )
	 */
	protected void sequence_ModelChannel(ISerializationContext context, ModelChannel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ModelProperty returns ModelProperty
	 *
	 * Constraint:
	 *     (key=ID value=ValueType)
	 */
	protected void sequence_ModelProperty(ISerializationContext context, ModelProperty semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ThingPackage.Literals.MODEL_PROPERTY__KEY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ThingPackage.Literals.MODEL_PROPERTY__KEY));
			if (transientValues.isValueTransient(semanticObject, ThingPackage.Literals.MODEL_PROPERTY__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ThingPackage.Literals.MODEL_PROPERTY__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getModelPropertyAccess().getKeyIDTerminalRuleCall_0_0(), semanticObject.getKey());
		feeder.accept(grammarAccess.getModelPropertyAccess().getValueValueTypeParserRuleCall_2_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ModelPropertyContainer returns ModelThing
	 *     ModelThing returns ModelThing
	 *
	 * Constraint:
	 *     (
	 *         (id=UID | (thingTypeId=UID_SEGMENT thingId=UID_SEGMENT)) 
	 *         label=STRING? 
	 *         bridgeUID=UID? 
	 *         location=STRING? 
	 *         properties+=ModelProperty? 
	 *         properties+=ModelProperty* 
	 *         channels+=ModelChannel*
	 *     )
	 */
	protected void sequence_ModelThing(ISerializationContext context, ModelThing semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ThingModel returns ThingModel
	 *
	 * Constraint:
	 *     (things+=ModelThing | things+=ModelBridge)+
	 */
	protected void sequence_ThingModel(ISerializationContext context, ThingModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
