/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test.java;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.smarthome.core.autoupdate.AutoUpdateBindingConfigProvider;
import org.eclipse.smarthome.test.java.JavaTest;
import org.eclipse.smarthome.test.storage.VolatileStorageService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class JavaOSGiTest
extends JavaTest {
    private final Map<String, ServiceRegistration<?>> registeredServices = new HashMap();
    protected BundleContext bundleContext;

    @Before
    public void bindBundleContext() {
        this.bundleContext = this.initBundleContext();
        Assert.assertThat((Object)this.bundleContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private BundleContext initBundleContext() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            return bundle.getBundleContext();
        }
        return null;
    }

    private <T> T unrefService(ServiceReference<T> serviceReference) {
        if (serviceReference == null) {
            return null;
        }
        return (T)this.bundleContext.getService(serviceReference);
    }

    protected <T> T getService(Class<T> clazz) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(clazz.getName());
        return this.unrefService(serviceReference);
    }

    protected <T> T getService(Class<T> clazz, Predicate<ServiceReference<T>> filter) {
        ServiceReference<T>[] serviceReferences = this.getServices(clazz);
        if (serviceReferences == null) {
            return null;
        }
        ArrayList<T> filteredServiceReferences = new ArrayList<T>(serviceReferences.length);
        ServiceReference<T>[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<T> serviceReference = serviceReferenceArray[n2];
            if (filter.test(serviceReference)) {
                filteredServiceReferences.add(this.unrefService(serviceReference));
            }
            ++n2;
        }
        if (filteredServiceReferences.size() > 1) {
            Assert.fail((String)"More than 1 service matching the filter is registered.");
        }
        if (filteredServiceReferences.isEmpty()) {
            return null;
        }
        return (T)filteredServiceReferences.get(0);
    }

    private <T> ServiceReference<T>[] getServices(Class<T> clazz) {
        try {
            ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(clazz.getName(), null);
            return serviceReferences;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new Error("Invalid exception for a null filter");
        }
    }

    protected <T, I extends T> I getService(Class<T> clazz, Class<I> implementationClass) {
        T service = this.getService(clazz, (ServiceReference<T> srvRef) -> implementationClass.isInstance(this.unrefService((ServiceReference)srvRef)));
        return (I)service;
    }

    protected ServiceRegistration<?> registerService(Object service) {
        return this.registerService(service, this.getInterfaceName(service), null);
    }

    protected ServiceRegistration<?> registerService(Object service, Dictionary<String, ?> properties) {
        return this.registerService(service, this.getInterfaceName(service), properties);
    }

    protected ServiceRegistration<?> registerService(Object service, String interfaceName) {
        return this.registerService(service, interfaceName, null);
    }

    protected ServiceRegistration<?> registerService(Object service, String interfaceName, Dictionary<String, ?> properties) {
        Assert.assertThat((Object)interfaceName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ServiceRegistration srvReg = this.bundleContext.registerService(interfaceName, service, properties);
        this.registeredServices.put(interfaceName, srvReg);
        return srvReg;
    }

    protected ServiceRegistration<?> registerService(Object service, String[] interfaceNames, Dictionary<String, ?> properties) {
        Assert.assertThat((Object)interfaceNames, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ServiceRegistration srvReg = this.bundleContext.registerService(interfaceNames, service, properties);
        String[] stringArray = interfaceNames;
        int n = interfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            this.registeredServices.put(interfaceName, srvReg);
            ++n2;
        }
        return srvReg;
    }

    protected ServiceRegistration<?> unregisterService(Object service) {
        return this.unregisterService(this.getInterfaceName(service));
    }

    protected ServiceRegistration<?> unregisterService(String interfaceName) {
        ServiceRegistration<?> reg = this.registeredServices.remove(interfaceName);
        if (reg != null) {
            reg.unregister();
            Iterator<ServiceRegistration<?>> regs = this.registeredServices.values().iterator();
            while (regs.hasNext()) {
                ServiceRegistration<?> otherReg = regs.next();
                if (otherReg != reg) continue;
                regs.remove();
            }
        }
        return reg;
    }

    protected String getInterfaceName(Object service) {
        Class<?>[] classes = service.getClass().getInterfaces();
        if (classes.length >= 1) {
            return classes[0].getName();
        }
        return null;
    }

    protected void registerVolatileStorageService() {
        this.registerService(new VolatileStorageService());
    }

    @After
    public void unregisterMocks() {
        this.registeredServices.forEach((interfaceName, service) -> service.unregister());
        this.registeredServices.clear();
    }

    protected void disableItemAutoUpdate() {
        this.registerService(new AutoUpdateBindingConfigProvider(){

            public Boolean autoUpdate(String itemName) {
                return false;
            }
        });
    }
}

