/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.xslt.internal;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltTransformationService
implements TransformationService {
    private final Logger logger = LoggerFactory.getLogger(XsltTransformationService.class);

    public String transform(String filename, String source) throws TransformationException {
        if (filename == null || source == null) {
            throw new TransformationException("the given parameters 'filename' and 'source' must not be null");
        }
        StreamSource xsl = null;
        try {
            String path = String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + "transform" + File.separator + filename;
            xsl = new StreamSource(new File(path));
        }
        catch (Exception e) {
            String message = "opening file '" + filename + "' throws exception";
            this.logger.error("{}", (Object)message, (Object)e);
            throw new TransformationException(message, (Throwable)e);
        }
        this.logger.debug("about to transform '{}' by the function '{}'", (Object)source, (Object)xsl);
        StringReader xml = new StringReader(source);
        StringWriter out = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsl);
            transformer.transform(new StreamSource(xml), new StreamResult(out));
        }
        catch (Exception e) {
            this.logger.error("transformation throws exception", (Throwable)e);
            throw new TransformationException("transformation throws exception", (Throwable)e);
        }
        this.logger.debug("transformation resulted in '{}'", (Object)out.toString());
        return out.toString();
    }
}

