var firmwareFilterModule=angular.module("PaperUI.filters.firmware",[]);firmwareFilterModule.constant("FIRMWARE_STATUS",{UNKNOWN:"UNKNOWN",UP_TO_DATE:"UP_TO_DATE",UPDATE_AVAILABLE:"UPDATE_AVAILABLE",UPDATE_EXECUTABLE:"UPDATE_EXECUTABLE"}),firmwareFilterModule.constant("UPDATE_STEP",{DOWNLOADING:"DOWNLOADING",WAITING:"WAITING",TRANSFERRING:"TRANSFERRING",UPDATING:"UPDATING",REBOOTING:"REBOOTING"}),firmwareFilterModule.filter("firmwareStatusFormat",["FIRMWARE_STATUS",function(FIRMWARE_STATUS){return function(firmwareStatus){switch(firmwareStatus){case FIRMWARE_STATUS.UNKNOWN:return"Unknown";case FIRMWARE_STATUS.UP_TO_DATE:return"Up to date";case FIRMWARE_STATUS.UPDATE_AVAILABLE:return"Update available";case FIRMWARE_STATUS.UPDATE_EXECUTABLE:return"Ready to install"}}}]).filter("firmwareStatusClass",["FIRMWARE_STATUS",function(FIRMWARE_STATUS){return function(firmwareStatus){switch(firmwareStatus){case FIRMWARE_STATUS.UNKNOWN:return"grey";case FIRMWARE_STATUS.UP_TO_DATE:return"online";case FIRMWARE_STATUS.UPDATE_AVAILABLE:return"orange";case FIRMWARE_STATUS.UPDATE_EXECUTABLE:return"blue"}}}]).filter("firmwareUpdateStep",["UPDATE_STEP",function(UPDATE_STEP){return function(updateStep){switch(updateStep){case UPDATE_STEP.DOWNLOADING:return"Downloading";case UPDATE_STEP.WAITING:return"Waiting";case UPDATE_STEP.TRANSFERRING:return"Transfering";case UPDATE_STEP.UPDATING:return"Updating";case UPDATE_STEP.REBOOTING:return"Rebooting"}}}]),angular.module("PaperUI").directive("multiSelect",function($filter){return{restrict:"A",link:function(scope,element,attrs){function searchOptionAndGetLabel(value){var inParam=$.grep(scope.parameter.options,function(option){return option.value==value});return 0==inParam.length?(scope.parameter.optionList.push({value:value,label:value+""}),value):inParam.length>0?inParam[0].label:""}function addOptionToParam(){for(var i=0;i<scope.parameter.options.length;i++){var value="item"==scope.parameter.context?scope.parameter.options[i].name:"thing"==scope.parameter.context?scope.parameter.options[i].UID:scope.parameter.options[i].value,index=searchInOptionList(scope.parameter.optionList,value);-1==index&&(index=scope.parameter.optionList.length),scope.parameter.optionList[index]={value:value,label:scope.parameter.options[i].label+""}}}function searchInOptionList(optionList,searchItem){for(var i=0;i<optionList.length;i++)if(optionList[i].value==searchItem)return i;return-1}scope.parameter.optionList=[];var originalList=[],placeholder=[];if(scope.isNullSelected=!1,scope.configuration[scope.parameter.name])if(Array.isArray(scope.configuration[scope.parameter.name]))for(var i=0;i<scope.configuration[scope.parameter.name].length;i++){var label=searchOptionAndGetLabel(scope.configuration[scope.parameter.name][i]);label&&placeholder.push(label)}else{var label=searchOptionAndGetLabel(scope.configuration[scope.parameter.name]);label&&placeholder.push(label)}$(document).bind("click",function(e){var $clicked=$(e.target);$clicked.parents().hasClass("dropdown")||element.find("dd ul").hide()}),element.find("dd ul li a").on("click",function(e){element.find("dd ul").hide()}),scope.openDropdown=function($event){$event.stopImmediatePropagation();var visible=element.find("dd ul").is(":visible");angular.element(document).find("dd ul").hide(),visible?element.find("dd ul").slideUp("fast"):element.find("dd ul").slideDown("fast")},scope.addItemToList=function($event){var inParam=$.grep(scope.parameter.optionList,function(option){return option.value==scope.parameter.filterText}).length>0;inParam||(scope.parameter.filterText&&scope.parameter.optionList.push({value:scope.parameter.filterText,label:scope.parameter.filterText}),scope.updateInConfig(scope.parameter.filterText),scope.parameter.filterText=""),$event.preventDefault()},scope.onEnterPress=function($event){(0==scope.parameter.options.length||scope.parameter.options.length>0&&!scope.parameter.limitToOptions)&&13==$event.keyCode&&scope.addItemToList($event),setTimeout(function(){element.find("dd ul").slideDown("fast")}),$event.stopImmediatePropagation()},scope.searchInConfig=function(optionValue){if(optionValue){if(scope.configuration&&scope.configuration[scope.parameter.name]){if(Array.isArray(scope.configuration[scope.parameter.name])&&-1!==scope.configuration[scope.parameter.name].indexOf(optionValue))return!0;if(scope.configuration[scope.parameter.name]==optionValue)return!0}return!1}return scope.isNullSelected},scope.updateInConfig=function(optionValue,optionLabel){if(void 0!=optionValue&&null!=optionValue&&(optionValue=""+optionValue),optionLabel=optionLabel?optionLabel:optionValue,scope.parameter.multiple&&scope.configuration&&!scope.configuration[scope.parameter.name]&&(scope.configuration[scope.parameter.name]=[]),optionValue)if(this.searchInConfig(optionValue)){var index=scope.configuration[scope.parameter.name].indexOf(optionValue);if(-1!=index){Array.isArray(scope.configuration[scope.parameter.name])?scope.configuration[scope.parameter.name].splice(index,1):scope.configuration[scope.parameter.name]="";var p_index=placeholder.indexOf(optionLabel);-1!=p_index&&placeholder.splice(p_index,1)}}else Array.isArray(scope.configuration[scope.parameter.name])?scope.configuration[scope.parameter.name].push(optionValue):(scope.configuration[scope.parameter.name]=optionValue,placeholder=[]),scope.isNullSelected=!1,placeholder.push(optionLabel);else scope.parameter.multiple||(scope.configuration[scope.parameter.name]="",scope.isNullSelected?scope.isNullSelected=!1:scope.isNullSelected=!0);scope.parameter.multiple||element.find("dd ul").slideUp("fast")},scope.$watch("parameter.options",function(){"$promise"in scope.parameter.options?scope.parameter.options.$promise.then(function(){addOptionToParam()}):addOptionToParam()}),scope.$watch("parameter.filterText",function(){if(scope.parameter.optionList&&scope.parameter.optionList.length>0){originalList=0==originalList.length?scope.parameter.optionList:originalList;for(var i=0;i<scope.parameter.optionList.length;i++)-1==searchInOptionList(originalList,scope.parameter.optionList[i].value)&&originalList.push({value:scope.parameter.optionList[i].value,label:scope.parameter.optionList[i].label+""});var filteredOptions=$.grep(originalList,function(option){var optionValue=(option.label+"").toLowerCase();return-1!=optionValue.indexOf((""+scope.parameter.filterText).toLowerCase())});scope.parameter.optionList=filteredOptions&&filteredOptions.length>0?filteredOptions:originalList}}),scope.getPlaceHolderText=function(configuration,parameter){return configuration[parameter.name]&&(""+configuration[parameter.name]).length>0?"thing"==parameter.context||"item"==parameter.context?1==configuration[parameter.name].length?"1 option selected":configuration[parameter.name].length+" options selected":placeholder.toString():0==parameter.options.length||parameter.options.length>0&&!parameter.limitToOptions?"Add or search":"Search"},element.find(".multiList").on("mousewheel",function(e){var event=e.originalEvent,d=event.wheelDelta||-event.detail;this.scrollTop+=5*(0>d?1:-1),e.preventDefault()})}}}).directive("selectValidation",function(){return{restrict:"A",require:"ngModel",link:function(scope,element,attrs,ctrl){scope.$watch(attrs.ngModel,function(value){(void 0===value||""===value||Array.isArray(value)&&0==value.length)&&"true"==attrs.selectValidation?(element.addClass("border-invalid"),ctrl.$setValidity("required",!1)):(element.removeClass("border-invalid"),ctrl.$setValidity("required",!0))},!0)}}}),angular.module("PaperUI.directive.thingConfiguration",[]).directive("thingConfiguration",function(){var controller=function($scope,thingTypeService,thingRepository){$scope.$watch("thing",function(thing){thing.thingTypeUID&&getThingType(thing.thingTypeUID)}),$scope.bridges=[];var refreshBridges=function(supportedBridgeTypeUIDs){thingRepository.getAll(function(things){$scope.bridges=things.filter(function(thing){return supportedBridgeTypeUIDs.includes(thing.thingTypeUID)})})},getThingType=function(thingTypeUID){thingTypeService.getByUid({thingTypeUID:thingTypeUID},function(thingType){thingType.supportedBridgeTypeUIDs&&thingType.supportedBridgeTypeUIDs.length>0&&refreshBridges(thingType.supportedBridgeTypeUIDs)})}};return{restrict:"E",scope:{thing:"=",isEditing:"=?",form:"=?"},controller:controller,templateUrl:"partials/directive.thingConfiguration.html"}}),angular.module("PaperUI.directive.searchField",[]).directive("searchField",function(){return{restrict:"E",scope:{model:"=",placeholder:"=?"},templateUrl:"partials/directive.searchField.html",link:function(scope,element,attrs,controllers){scope.placeholder=attrs.placeholder?attrs.placeholder:"Search",scope.clearSearchField=function(event){event&&27!==event.keyCode||(scope.model="")}}}}),angular.module("PaperUI.directive.parameterDescription",[]).directive("parameterDescription",function(){return{restrict:"E",scope:{description:"="},templateUrl:"partials/directive.parameterDescription.html",link:function(scope,element,attrs,controllers){scope.showMore=function(event){event.target===event.currentTarget&&element.addClass("show-more")},scope.showLess=function(){element.removeClass("show-more")}}}}),angular.module("PaperUI.directive.configDescription",[]).directive("configDescription",function(){var controller=function($scope){$scope.getName=function(parameter,option){return option?option.name?option.name:"thing"==parameter.context?option.UID:"channel"==parameter.context?option.id:void 0:void 0}};return{restrict:"E",scope:{configuration:"=",parameters:"=",expertMode:"=?",configArray:"=?",form:"=?"},templateUrl:"partials/directive.configDescription.html",controller:controller}}),angular.module("PaperUI.controllers.things",["PaperUI.constants","PaperUI.controllers.firmware","PaperUI.controllers.configurableServiceDialog","PaperUI.directive.thingConfiguration"]).controller("EditThingController",function($scope,$mdDialog,toastService,thingRepository,configService,configDescriptionService,thingService){$scope.setSubtitle(["Things"]),$scope.setHeaderText("Click the 'Save' button to apply the changes.");var thingUID=$scope.path[4];$scope.thing={},$scope.groups=[],$scope.isEditing=!0;var originalThing={};$scope.parameters=void 0,$scope.configuration={},$scope.update=function(thing){thing.configuration=configService.setConfigDefaults(thing.configuration,$scope.parameters,!0),JSON.stringify(originalThing.configuration)!==JSON.stringify(thing.configuration)&&(thing.configuration=configService.replaceEmptyValues(thing.configuration),thingService.updateConfig({thingUID:thing.UID},thing.configuration)),originalThing.configuration=thing.configuration,originalThing.channels=thing.channels,JSON.stringify(originalThing)!==JSON.stringify(thing)&&thingService.update({thingUID:thing.UID},thing),toastService.showDefaultToast("Thing updated"),$scope.navigateTo("view/"+thing.UID)};var getThing=function(refresh){thingRepository.getOne(function(thing){return thing.UID===thingUID},function(thing){$scope.thing=thing,angular.copy(thing,originalThing),$scope.setSubtitle(["Things","Edit",thing.label]),configDescriptionService.getByUri({uri:"thing:"+thing.UID},function(configDescription){configDescription&&($scope.parameters=configService.getRenderingModel(configDescription.parameters,configDescription.parameterGroups),$scope.configuration=configService.setConfigDefaults($scope.thing.configuration,$scope.parameters))})},refresh)};$scope.$watch("configuration",function(){$scope.configuration&&($scope.thing.configuration=$scope.configuration)}),getThing(!0)}),angular.module("PaperUI.controllers.things").controller("ViewThingController",function($scope,$mdDialog,toastService,thingTypeService,thingRepository,thingService,linkService,channelTypeRepository,configService,thingConfigService,util,itemRepository){function getItemNameSuggestion(channelID,label){var itemName=getInCamelCase($scope.thing.label);if(channelID){var id=channelID.split("#");id.length>1&&id[0].length>0&&(itemName+="_"+getInCamelCase(id[0])),itemName+="_"+getInCamelCase(label)}return itemName}function getInCamelCase(str){var camelStr="";if(str)for(var arr=str.split(/[^a-zA-Z0-9_]/g),i=0;i<arr.length;i++)arr[i]&&arr[i].length>0&&(camelStr+=arr[i][0].toUpperCase()+(arr[i].length>1?arr[i].substring(1,arr[i].length):""));return camelStr}function checkAdvance(channels){var advancedChannels=channels.filter(function(channel){var channelType=$scope.getChannelTypeByUID(channel.channelTypeUID);return channelType&&channelType.advanced});return advancedChannels.length>0}function checkThingProperties(thing){if(thing.properties){var hasFirmwareVersion=thing.properties.firmwareVersion;Object.keys(thing.properties).length>0&&!hasFirmwareVersion||Object.keys(thing.properties).length>1&&hasFirmwareVersion?$scope.thing.hasProperties=!0:$scope.thing.hasProperties=!1}else $scope.thing.hasProperties=!1}function getThingType(){thingTypeService.getByUid({thingTypeUID:$scope.thingTypeUID},function(thingType){$scope.thingType=thingType,thingType&&($scope.thingTypeChannels=thingType.channels&&thingType.channels.length>0?thingType.channels:thingType.channelGroups,$scope.setHeaderText(thingType.description)),$scope.refreshChannels($scope.showAdvanced)})}$scope.setSubtitle(["Things"]);var thingUID=$scope.path[4];$scope.thingTypeUID=null,$scope.advancedMode,$scope.thing,$scope.thingType,$scope.thingChannels=[],$scope.showAdvanced=!1,$scope.channelTypes,$scope.items,channelTypeRepository.getAll(function(channels){$scope.channelTypes=channels,$scope.refreshChannels(!1)}),itemRepository.getAll(function(items){$scope.items=items}),$scope.remove=function(thing,event){event.stopImmediatePropagation(),$mdDialog.show({controller:"RemoveThingDialogController",templateUrl:"partials/dialog.removething.html",targetEvent:event,hasBackdrop:!0,locals:{thing:thing}}).then(function(){$scope.navigateTo("")})},$scope.enableChannel=function(thingUID,channelID,event,longPress){var channel=$scope.getChannelById(channelID);event.stopImmediatePropagation(),$scope.advancedMode?channel.linkedItems.length>0?$scope.getLinkedItems(channel,event):$scope.linkChannel(channelID,event,longPress):0==channel.linkedItems.length&&linkService.link({itemName:$scope.thing.UID.replace(/[^a-zA-Z0-9_]/g,"_")+"_"+channelID.replace(/[^a-zA-Z0-9_]/g,"_"),channelUID:$scope.thing.UID+":"+channelID},function(newItem){$scope.getThing(!0),toastService.showDefaultToast("Channel linked")})},$scope.disableChannel=function(thingUID,channelID,itemName,event){var channel=$scope.getChannelById(channelID);event.stopImmediatePropagation();channel.linkedItems[0];$scope.advancedMode?$scope.unlinkChannel(channelID,itemName,event):linkService.unlink({itemName:$scope.thing.UID.replace(/[^a-zA-Z0-9_]/g,"_")+"_"+channelID.replace(/[^a-zA-Z0-9_]/g,"_"),channelUID:$scope.thing.UID+":"+channelID},function(){$scope.getThing(!0),toastService.showDefaultToast("Channel unlinked")})},$scope.linkChannel=function(channelID,event,preSelect){var channel=$scope.getChannelById(channelID),channelType=$scope.getChannelTypeByUID(channel.channelTypeUID),params={linkedItems:channel.linkedItems.length>0?channel.linkedItems:"",acceptedItemType:channel.itemType,category:channelType.category?channelType.category:"",suggestedName:getItemNameSuggestion(channelID,channelType.label),suggestedLabel:channelType.label,suggestedCategory:channelType.category?channelType.category:"",preSelectCreate:preSelect};$mdDialog.show({controller:"LinkChannelDialogController",templateUrl:"partials/dialog.linkchannel.html",targetEvent:event,hasBackdrop:!0,params:params}).then(function(newItem){newItem&&linkService.link({itemName:newItem.itemName,channelUID:$scope.thing.UID+":"+channelID},function(){$scope.getThing(!0);var item=$.grep($scope.items,function(item){return item.name==newItem.itemName});channel.items=channel.items?channel.items:[],item.length>0?channel.items.push(item[0]):channel.items.push({name:newItem.itemName,label:newItem.label}),toastService.showDefaultToast("Channel linked")})})},$scope.unlinkChannel=function(channelID,itemName,event){var channel=$scope.getChannelById(channelID);$mdDialog.show({controller:"UnlinkChannelDialogController",templateUrl:"partials/dialog.unlinkchannel.html",targetEvent:event,hasBackdrop:!0,locals:{itemName:itemName}}).then(function(){itemName&&linkService.unlink({itemName:itemName,channelUID:$scope.thing.UID+":"+channelID},function(){$scope.getThing(!0);var item=$.grep(channel.items,function(item){return item.name==itemName});item.length>0&&channel.items.splice(channel.items.indexOf(item[0]),1),toastService.showDefaultToast("Channel unlinked")})})},$scope.getChannelById=function(channelId){return $scope.thing?$.grep($scope.thing.channels,function(channel,i){return channelId==channel.id})[0]:void 0},$scope.getChannelTypeByUID=function(channelUID){return thingConfigService.getChannelTypeByUID($scope.thingType,$scope.channelTypes,channelUID)},$scope.getChannelFromChannelTypes=function(channelUID){return $scope.channelTypes?thingConfigService.getChannelFromChannelTypes($scope.channelTypes,channelUID):void 0};var getChannels=function(advanced){return $scope.thingType&&$scope.thing&&$scope.channelTypes?($scope.isAdvanced=checkAdvance($scope.thing.channels),thingConfigService.getThingChannels($scope.thing,$scope.thingType,$scope.channelTypes,advanced)):void 0};$scope.refreshChannels=function(showAdvanced){$scope.thingChannels=getChannels(showAdvanced)},$scope.getThing=function(refresh){thingRepository.getOne(function(thing){return thing.UID===thingUID},function(thing){angular.forEach(thing.channels,function(value,i){value.showItems=$scope.thing?$scope.thing.channels[i].showItems:!1,value.items=$scope.thing?$scope.thing.channels[i].items:null}),$scope.thing=thing,checkThingProperties(thing),$scope.thingTypeUID=thing.thingTypeUID,getThingType(),$scope.setSubtitle(["Things",thing.label])},refresh)},$scope.getThing(!0),$scope.configChannel=function(channel,thing,event){var channelType=this.getChannelFromChannelTypes(channel.channelTypeUID);$mdDialog.show({controller:"ChannelConfigController",templateUrl:"partials/dialog.channelconfig.html",targetEvent:event,hasBackdrop:!0,locals:{channelType:channelType,channel:channel,thing:thing}})},$scope.getLinkedItems=function(channel){channel.showItems=!channel.showItems,(channel.showItems&&null===channel.items||void 0===channel.items)&&(channel.items=$.grep($scope.items,function(item){return $.grep(channel.linkedItems,function(linkedItemName){return linkedItemName==item.name}).length>0}))},$scope.showDescription=function(channel,channelType){var description=channel.description?channel.description:channel.channelType?channel.channelType.description:null;description&&(popup=$mdDialog.alert({title:channel.label?channel.label:channel.channelType?channel.channelType.label:channel.id,textContent:description,ok:"Close"}),$mdDialog.show(popup))},$scope.$watch("thing.channels",function(){$scope.refreshChannels($scope.showAdvanced)}),$scope.isExtensible=function(){var thingType=$scope.thingType;return thingType&&thingType.extensibleChannelTypeIds&&thingType.extensibleChannelTypeIds.length>0},$scope.isExtensibleChannel=function(channelTypeUID){if(!channelTypeUID||!$scope.isExtensible())return!1;var channelTypeId=channelTypeUID.split(":")[1];return $scope.thingType.extensibleChannelTypeIds.indexOf(channelTypeId)>=0},$scope.addChannel=function(event){$mdDialog.show({controller:"AddChannelController",templateUrl:"partials/dialog.addchannel.html",targetEvent:event,hasBackdrop:!0,locals:{thing:$scope.thing,thingType:$scope.thingType}})},$scope.removeChannel=function(channel,event){event.stopImmediatePropagation(),$mdDialog.show({controller:"RemoveChannelDialogController",templateUrl:"partials/dialog.removechannel.html",targetEvent:event,hasBackdrop:!0,locals:{thing:$scope.thing,channel:channel}}).then(function(){$scope.getThing(!1)})}}).controller("AddChannelController",function($scope,$mdDialog,toastService,channelTypeRepository,configService,thingService,thingType,thing){$scope.channelTypes=[],$scope.parameters=void 0,$scope.channelType=void 0,$scope.channelId=void 0,$scope.channelLabel=void 0,$scope.configuration={};var refreshChannelTypes=function(){angular.forEach(thingType.extensibleChannelTypeIds,function(channelTypeId){var channelTypeUID=thing.UID.split(":")[0]+":"+channelTypeId;channelTypeRepository.getOne(function(element){return element.UID===channelTypeUID},function(channelType){$scope.channelTypes.push(channelType)})})};$scope.$watch("channelType",function(){$scope.channelType&&($scope.parameters=configService.getRenderingModel($scope.channelType.parameters,$scope.channelType.parameterGroups))}),$scope.close=function(){$mdDialog.cancel()},$scope.save=function(){var channel={uid:thing.UID+":"+$scope.channelId,id:$scope.channelId,channelTypeUID:$scope.channelType.UID,itemType:$scope.channelType.itemType,label:$scope.channelLabel,configuration:$scope.configuration,defaultTags:$scope.channelType.tags};thing.channels.push(channel),thingService.update({thingUID:thing.UID},thing,function(){$mdDialog.hide(),toastService.showSuccessToast("Channel added.")},function(){$mdDialog.hide(),toastService.showErrorToast("Error adding channel.")})},refreshChannelTypes()}).controller("RemoveChannelDialogController",function($scope,$mdDialog,toastService,thingService,thing,channel){$scope.channel=channel,$scope.close=function(){$mdDialog.cancel()},$scope.remove=function(){var index=thing.channels.indexOf(channel);thing.channels.splice(index,1),thingService.update({thingUID:thing.UID},thing,function(){$mdDialog.hide(),toastService.showSuccessToast("Channel removed.")},function(){$mdDialog.hide(),toastService.showErrorToast("Error removing channel.")})}}),angular.module("PaperUI.controllers.things").controller("ThingController",function($scope,$timeout,$location,$mdDialog,thingRepository,thingTypeRepository,bindingRepository,thingService,toastService){function refreshThingTypes(){return thingTypeRepository.getAll(function(thingTypes){angular.forEach(thingTypes,function(thingType){$scope.thingTypes[thingType.UID]=thingType})})}function refreshBindings(){bindingRepository.getAll(function(bindings){var filteredBindings=new Set;angular.forEach($scope.things,function(thing){var binding=bindings.filter(function(binding){return binding.id===thing.bindingType});filteredBindings.add(binding[0])}),$scope.bindings=Array.from(filteredBindings)},!0)}$scope.navigateTo=function(path){path.startsWith("/")?$location.path(path):$location.path("configuration/things/"+path)},$scope.setSubtitle(["Things"]),$scope.setHeaderText("Shows all configured Things."),$scope.bindings=[],$scope.thingTypes=[],$scope.things,$scope.refresh=function(){refreshThingTypes().then(function(){thingRepository.getAll(function(things){angular.forEach(things,function(thing){thing.bindingType=thing.thingTypeUID.split(":")[0]}),$scope.things=things})})},$scope.remove=function(thing,event){event.stopImmediatePropagation(),$mdDialog.show({controller:"RemoveThingDialogController",templateUrl:"partials/dialog.removething.html",targetEvent:event,hasBackdrop:!0,locals:{thing:thing}}).then(function(){$scope.refresh()})},$scope.getThingTypeLabel=function(key){var thingType=$scope.thingTypes[key];return thingType?thingType.label:""},$scope.clearAll=function(){$scope.searchText="",$scope.$broadcast("ClearFilters")},$scope.$watch("things",function(newThings,oldThings){refreshBindings()}),$scope.refresh()}).controller("RemoveThingDialogController",function($scope,$mdDialog,toastService,thingService,thing){$scope.thing=thing,thing.statusInfo&&($scope.isRemoving="REMOVING"===thing.statusInfo.status),$scope.close=function(){$mdDialog.cancel()},$scope.remove=function(thingUID){var forceRemove=$scope.isRemoving?!0:!1;thingService.remove({thingUID:thing.UID,force:forceRemove},function(){forceRemove?toastService.showDefaultToast("Thing removed (forced)."):toastService.showDefaultToast("Thing removal initiated."),$mdDialog.hide()},function(){$mdDialog.hide()})}}).controller("LinkChannelDialogController",function($rootScope,$scope,$mdDialog,$filter,toastService,itemRepository,itemService,sharedProperties,params){$scope.itemName,$scope.linkedItems=params.linkedItems,$scope.acceptedItemType=[params.acceptedItemType],$scope.advancedMode=$rootScope.advancedMode,"Color"==params.acceptedItemType?($scope.acceptedItemType.push("Switch"),$scope.acceptedItemType.push("Dimmer")):"Dimmer"==params.acceptedItemType&&$scope.acceptedItemType.push("Switch"),$scope.category=params.category,$scope.itemFormVisible=!1,$scope.itemsList=[],itemRepository.getAll(function(items){$scope.items=items,$scope.itemsList=$.grep($scope.items,function(item){return-1!=$scope.acceptedItemType.indexOf(item.type)}),$scope.itemsList=$.grep($scope.itemsList,function(item){return-1==$scope.linkedItems.indexOf(item.name)}),$scope.itemsList.push({name:"_createNew",type:$scope.acceptedItemType}),$scope.itemsList=$filter("orderBy")($scope.itemsList,"name")}),$scope.checkCreateOption=function(){"_createNew"==$scope.itemName?($scope.itemFormVisible=!0,sharedProperties.resetParams(),sharedProperties.updateParams({linking:!0,acceptedItemType:$scope.acceptedItemType,suggestedName:params.suggestedName,suggestedLabel:params.suggestedLabel,suggestedCategory:params.suggestedCategory})):$scope.itemFormVisible=!1},$scope.createAndLink=function(){$scope.$broadcast("ItemLinkedClicked")},$scope.close=function(){$mdDialog.cancel(),sharedProperties.resetParams()},$scope.link=function(itemName,label){$mdDialog.hide({itemName:itemName,label:label})},$scope.$on("ItemCreated",function(event,args){event.preventDefault(),args.status?$scope.link(args.itemName,args.label):(toastService.showDefaultToast("Some error occurred"),$scope.close())}),params.preSelectCreate&&($scope.itemName="_createNew",$scope.checkCreateOption())}).controller("UnlinkChannelDialogController",function($scope,$mdDialog,toastService,linkService,itemName){$scope.itemName=itemName,$scope.close=function(){$mdDialog.cancel()},$scope.unlink=function(){$mdDialog.hide()}}).controller("ChannelConfigController",function($scope,$mdDialog,toastService,thingService,configService,channelType,channel,thing){$scope.parameters=configService.getRenderingModel(channelType.parameters,channelType.parameterGroups),$scope.configuration={},angular.copy(channel.configuration,$scope.configuration),$scope.close=function(){$mdDialog.cancel()},$scope.save=function(){channel.configuration=$scope.configuration,thingService.update({thingUID:thing.UID},thing,function(){$mdDialog.hide(),toastService.showDefaultToast("Channel updated")})}});var firmwareControllers=angular.module("PaperUI.controllers.firmware",["PaperUI.filters.firmware"]);firmwareControllers.controller("FirmwareController",function($scope,$mdDialog,toastService,eventService,thingService,thingTypeService,FIRMWARE_STATUS){$scope.updatingFirmware=!1,$scope.percentComplete=0,$scope.updateStep,$scope.firmwareStatus,$scope.firmwares=[],$scope.fvdetails=!1;var thingUID=$scope.path[4],refreshFirmwareStatus=function(thingUID){$scope.firmwareStatus=null,thingUID&&thingService.getFirmwareStatus({thingUID:thingUID},function(firmwareStatus){$scope.firmwareStatus=firmwareStatus});var thingTypeUID=$scope.$parent.thing.thingTypeUID;thingTypeUID&&thingTypeService.getFirmwares({thingTypeUID:thingTypeUID},function(firmwares){$scope.firmwares=firmwares})};refreshFirmwareStatus(thingUID),$scope.installFirmware=function(version){$scope.updatingFirmware||thingService.installFirmware({thingUID:thingUID,firmwareVersion:version},function(){$scope.updatingFirmware=!0,$scope.percentComplete=0},function(resp){toastService.showDefaultToast("Error: "+resp.data.error.message)})},$scope.showChangelog=function(firmwareVersion){var changelog=$scope.firmwares.filter(function(firmware){return firmware.version===firmwareVersion})[0].changelog;$mdDialog.show({controller:"ChangelogDialogController",templateUrl:"partials/dialog.changelog.html",targetEvent:event,hasBackdrop:!0,locals:{changelog:changelog,firmwareVersion:firmwareVersion}})},$scope.isFirmwareUpdateable=function(firmwareStatus){return firmwareStatus&&firmwareStatus.status==FIRMWARE_STATUS.UPDATE_EXECUTABLE&&firmwareStatus.updatableVersion},$scope.hasChangelog=function(firmwareStatus){if(firmwareStatus&&firmwareStatus.updatableVersion){var changelog=$scope.firmwares.filter(function(firmware){return firmware.version===firmwareStatus.updatableVersion})[0].changelog;return void 0!==changelog&&null!==changelog&&""!==changelog}return!1},eventService.onEvent("smarthome/things/*/firmware/update/progress",function(topic,updateStatus){updateStatus&&updateStatus.progress&&(100==updateStatus.progress&&($scope.updatingFirmware=!1),$scope.$apply(function(){$scope.percentComplete=updateStatus.progress,$scope.updateStep=updateStatus.progressStep}))}),eventService.onEvent("smarthome/things/*/firmware/update/result",function(topic,status){status&&"SUCCESS"==status.result?($scope.$parent.getThing(function(){refreshFirmwareStatus(thingUID)}),toastService.showDefaultToast("Firmware updated successfully.")):($scope.$parent.getThing(function(){refreshFirmwareStatus(thingUID)}),toastService.showDefaultToast("Firmware update failed."))}),eventService.onEvent("smarthome/things/*/firmware/status",function(topic,object){object&&($scope.firmwareStatus.status=object.firmwareStatus,object.updatableFirmwareUID&&object.updatableFirmwareUID.firmwareVersion?$scope.firmwareStatus.updateableVersion=object.updatableFirmwareUID.firmwareVersion:$scope.firmwareStatus.updateableVersion=null)})}).controller("ChangelogDialogController",function($scope,$mdDialog,firmwareVersion,changelog){$scope.changelog=changelog,$scope.firmwareVersion=firmwareVersion,$scope.close=function(){$mdDialog.hide()}});var configurableServiceDialogController=angular.module("PaperUI.controllers.configurableServiceDialog",["PaperUI.services","PaperUI.services.rest","ngMaterial","PaperUI.directive.parameterDescription"]);configurableServiceDialogController.controller("ConfigurableServiceDialogController",function($scope,$mdDialog,configService,serviceConfigService,configDescriptionService,toastService,serviceId,configDescriptionURI){var loadService=function(serviceId){serviceConfigService.getById({id:serviceId}).$promise.then(function(service){$scope.service=service})},loadServiceConfiguration=function(serviceId,configDescriptionURI){serviceConfigService.getConfigById({id:serviceId}).$promise.then(function(config){config&&($scope.configuration=configService.convertValues(config),$scope.configArray=configService.getConfigAsArray($scope.configuration))}).then(applyDefaults(configDescriptionURI))},applyDefaults=function(configDescriptionURI){configDescriptionURI&&configDescriptionService.getByUri({uri:configDescriptionURI}).$promise.then(function(configDescription){configDescription&&($scope.parameters=configService.getRenderingModel(configDescription.parameters,configDescription.parameterGroups),$scope.configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters))})};$scope.service=null,$scope.parameters=[],$scope.configuration={},$scope.expertMode=serviceId?!1:!0,$scope.newConfig=serviceId?!1:!0,serviceId?(loadService(serviceId),loadServiceConfiguration(serviceId,configDescriptionURI)):createEmptyConfig(),$scope.close=function(){$mdDialog.hide()},$scope.addParameter=function(){$scope.configArray.push({name:"",value:void 0})},$scope.save=function(){var configuration={};$scope.expertMode&&($scope.configuration=configService.getConfigAsObject($scope.configArray,$scope.parameters));var configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters,!0);serviceConfigService.updateConfig({id:serviceId?serviceId:$scope.serviceId},configuration,function(){toastService.showDefaultToast("Service config updated.")}),$mdDialog.hide()},$scope.$watch("expertMode",function(){$scope.expertMode?$scope.configArray=configService.getConfigAsArray($scope.configuration,$scope.parameters):$scope.configuration=configService.getConfigAsObject($scope.configArray,$scope.parameters);
})}),angular.module("PaperUI.controllers.configuration",["PaperUI.constants","PaperUI.controllers.firmware","PaperUI.controllers.configurableServiceDialog"]).controller("ServicesController",function($scope,$mdDialog,serviceConfigService,toastService){$scope.setSubtitle(["Services"]),$scope.setHeaderText("Shows all configurable services."),$scope.tabs=[],$scope.refresh=function(){serviceConfigService.getAll(function(services){var arrOfIndex=[],index=0;angular.forEach(services,function(value){void 0===arrOfIndex[value.category]&&(arrOfIndex[value.category]=index++),void 0===$scope.tabs[arrOfIndex[value.category]]&&($scope.tabs[arrOfIndex[value.category]]=[],$scope.tabs[arrOfIndex[value.category]].category=value.category),$scope.tabs[arrOfIndex[value.category]].push(value)})})},$scope.configure=function(serviceId,configDescriptionURI,event){$mdDialog.show({controller:"ConfigurableServiceDialogController",templateUrl:"partials/dialog.configureservice.html",targetEvent:event,hasBackdrop:!0,locals:{serviceId:serviceId,configDescriptionURI:configDescriptionURI}})},$scope.refresh()}),angular.module("PaperUI.controllers.configuration").controller("SystemController",function($scope,$mdDialog,serviceConfigService,toastService){$scope.setSubtitle(["System"]),$scope.setHeaderText("Shows all system configurations."),$scope.tabs=[],$scope.refresh=function(){serviceConfigService.getAll(function(services){$scope.services=$.grep(services,function(service){return service.category&&"SYSTEM"===service.category.toUpperCase()}),angular.forEach($scope.services,function(service){service.found=!0})})},$scope.$on("noConfigDesc",function(event,serviceId){var services=$.grep($scope.services,function(service){return service.id==serviceId});services[0].found=!1,event.stopPropagation(),event.preventDefault()}),$scope.refresh()}).controller("ConfigureSystemServiceController",function($rootScope,$scope,$mdDialog,configService,serviceConfigService,configDescriptionService,toastService){function replaceUndefWithEmpty(obj){for(var key in obj)obj.hasOwnProperty(key)&&(void 0===obj[key]||null===obj[key])&&(obj[key]="");return obj}$scope.editing=!1,$scope.service=null,$scope.parameters=[],$scope.configuration={},$scope.config={},$scope.serviceId,$scope.configDescriptionURI;var originalServiceConf={};$scope.getConfigDescription=function(){var serviceId=$scope.serviceId,configDescriptionURI=$scope.configDescriptionURI;configDescriptionURI&&configDescriptionService.getByUri({uri:configDescriptionURI},function(configDescription){configDescription&&($scope.parameters=configService.getRenderingModel(configDescription.parameters,configDescription.parameterGroups),$scope.configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters),$scope.configuration=replaceUndefWithEmpty($scope.configuration),angular.copy($scope.configuration,originalServiceConf))},function(){$scope.$emit("noConfigDesc",serviceId)}),serviceId&&(serviceConfigService.getById({id:serviceId},function(service){$scope.service=service}),serviceConfigService.getConfigById({id:serviceId}).$promise.then(function(config){config&&($scope.configuration=configService.convertValues(config),$scope.parameters&&$scope.parameters.length>0&&($scope.configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters),angular.copy($scope.configuration,originalServiceConf)))}))},$scope.save=function(){if(JSON.stringify($scope.configuration)!==JSON.stringify(originalServiceConf)){var configuration={},configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters,!0);serviceConfigService.updateConfig({id:$scope.serviceId},configuration,function(){angular.copy($scope.configuration,originalServiceConf),"org.eclipse.smarthome.links"===$scope.serviceId&&($rootScope.advancedMode=jQuery.isEmptyObject($scope.configuration)?$rootScope.advancedMode:!$scope.configuration.autoLinks),toastService.showDefaultToast("System config updated.")})}$scope.editing=!1},$scope.$watch("configuration",function(){$scope.configuration&&(JSON.stringify($scope.configuration)!==JSON.stringify(originalServiceConf)?$scope.editing=!0:$scope.editing=!1)},!0)}),angular.module("PaperUI.controllers.setup",[]).controller("SetupPageController",function($scope,$location,thingTypeRepository,bindingRepository){function getThingTypes(){thingTypeRepository.getAll(function(thingTypes){$.each(thingTypes,function(i,thingType){$scope.thingTypes[thingType.UID]=thingType})})}$scope.navigateTo=function(path){$location.path("inbox/"+path)},$scope.thingTypes=[],$scope.getThingTypeLabel=function(key){return $scope.thingTypes&&0!=Object.keys($scope.thingTypes).length?$scope.thingTypes[key]?$scope.thingTypes[key].label:"Unkown device":void thingTypeRepository.setDirty(!1)},getThingTypes()}).controller("InboxController",function($scope,$timeout,$mdDialog,$q,inboxService,discoveryResultRepository,thingTypeRepository,thingService,toastService){$scope.setHeaderText("Shows a list of found things in your home."),$scope.showScanDialog=function(event){$mdDialog.show({controller:"ScanDialogController",templateUrl:"partials/dialog.scan.html",targetEvent:event})},$scope.refresh=function(){discoveryResultRepository.getAll(!0)}}).controller("InboxEntryController",function($scope,$mdDialog,$q,inboxService,discoveryResultRepository,thingTypeRepository,thingService,toastService,thingRepository){function refreshBindings(){if($scope.bindings=[],$scope.data&&$scope.data.discoveryResults&&$scope.data.bindings&&$scope.data.bindings.length>0)for(var i=0;i<$scope.data.bindings.length;i++){var a=$.grep($scope.data.discoveryResults,function(result){return result.bindingType==$scope.data.bindings[i].id});a.length>0&&$scope.bindings.push($scope.data.bindings[i])}}$scope.approve=function(thingUID,thingTypeUID,event){$mdDialog.show({controller:"ApproveInboxEntryDialogController",templateUrl:"partials/dialog.approveinboxentry.html",targetEvent:event,locals:{discoveryResult:discoveryResultRepository.find(function(discoveryResult){return discoveryResult.thingUID===thingUID})}}).then(function(result){inboxService.approve({thingUID:thingUID,enableChannels:!$scope.advancedMode},result.label).$promise.then(function(){thingRepository.setDirty(!0),toastService.showDefaultToast("Thing added.","Show Thing","configuration/things/view/"+thingUID);var thingType=thingTypeRepository.find(function(thingType){return thingTypeUID===thingType.UID});thingType&&thingType.bridge?$scope.navigateTo("setup/search/"+thingUID.split(":")[0]):discoveryResultRepository.getAll(!0)})})},$scope.ignore=function(thingUID){inboxService.ignore({thingUID:thingUID},function(){$scope.refresh()})},$scope.unignore=function(thingUID){inboxService.unignore({thingUID:thingUID},function(){$scope.refresh()})},$scope.remove=function(thingUID,event){var discoveryResult=discoveryResultRepository.find(function(discoveryResult){return discoveryResult.thingUID===thingUID}),confirm=$mdDialog.confirm().title("Remove "+discoveryResult.label).content("Would you like to remove the discovery result from the inbox?").ariaLabel("Remove Discovery Result").ok("Remove").cancel("Cancel").targetEvent(event);$mdDialog.show(confirm).then(function(){inboxService.remove({thingUID:thingUID},function(){$scope.refresh(),toastService.showSuccessToast("Inbox entry removed")})})},$scope.bindings,$scope.$watch("data.discoveryResults",function(results){results&&refreshBindings()}),$scope.clearAll=function(){$scope.searchText="",$scope.$broadcast("ClearFilters")}}).controller("ScanDialogController",function($scope,$rootScope,$timeout,$mdDialog,discoveryService,bindingRepository){$scope.supportedBindings=[],$scope.activeScans=[],$scope.scan=function(bindingId){$scope.activeScans.push(bindingId),discoveryService.scan({bindingId:bindingId},function(response){var timeout=parseInt(response.timeout);timeout=1e3*(isNaN(timeout)?3:timeout),setTimeout(function(){$scope.$apply(function(){$scope.activeScans.splice($scope.activeScans.indexOf(bindingId),1)})},timeout)})},bindingRepository.getAll(),$scope.getBindingById=function(bindingId){for(var i=0;i<$rootScope.data.bindings.length;i++){var binding=$rootScope.data.bindings[i];if(binding.id===bindingId)return binding}return{}},discoveryService.getAll(function(response){$scope.supportedBindings=response}),$scope.close=function(){$mdDialog.hide()}}).controller("ApproveInboxEntryDialogController",function($scope,$mdDialog,discoveryResult,thingTypeRepository){$scope.discoveryResult=discoveryResult,$scope.label=discoveryResult.label,$scope.thingType=null,$scope.thingTypeUID=discoveryResult.thingTypeUID,thingTypeRepository.getOne(function(thingType){return thingType.UID===$scope.thingTypeUID},function(thingType){$scope.thingType=thingType}),$scope.close=function(){$mdDialog.cancel()},$scope.approve=function(label){$mdDialog.hide({label:label})}}).controller("ManualSetupConfigureController",function($scope,$routeParams,$mdDialog,$location,toastService,bindingRepository,thingTypeService,thingService,thingRepository,configService,linkService){function generateUUID(){var d=(new Date).getTime(),uuid="xxxxxxxx".replace(/[x]/g,function(c){var r=(d+16*Math.random())%16|0;return d=Math.floor(d/16),("x"==c?r:3&r|8).toString(16)});return uuid}var thingTypeUID=$routeParams.thingTypeUID;$scope.thingType=null,$scope.thing={UID:null,thingTypeUID:thingTypeUID,configuration:{},item:{label:null,groupNames:[]}},$scope.thingID=null,$scope.addThing=function(thing){thing.UID=thing.thingTypeUID+":"+thing.ID,thing.configuration=configService.setConfigDefaults(thing.configuration,$scope.parameters,!0),thingService.add(thing,function(){toastService.showDefaultToast("Thing added.","Show Thing","configuration/things/view/"+thing.UID),$location.path("configuration/things")})},thingTypeService.getByUid({thingTypeUID:thingTypeUID},function(thingType){$scope.setTitle("Configure "+thingType.label),$scope.setHeaderText(thingType.description),$scope.thingType=thingType,$scope.parameters=configService.getRenderingModel(thingType.configParameters,thingType.parameterGroups),$scope.thing.ID=generateUUID(),$scope.thing.item.label=thingType.label,$scope.thing.label=thingType.label,configService.setDefaults($scope.thing,$scope.thingType)})}).controller("SetupWizardController",function($scope,discoveryResultRepository){$scope.showIgnored=!1,$scope.toggleShowIgnored=function(){$scope.showIgnored=!$scope.showIgnored},$scope.refresh=function(){discoveryResultRepository.getAll(!0)},$scope.refresh(),$scope.filter=function(discoveryResult){return $scope.showIgnored||"NEW"===discoveryResult.flag},$scope.areEntriesIgnored=function(discoveryResults){return $.grep(discoveryResults,function(discoveryResult){return"IGNORED"===discoveryResult.flag}).length>0}}).controller("SetupWizardBindingsController",function($scope,bindingRepository,discoveryService){$scope.setSubtitle(["Choose Binding"]),$scope.setHeaderText("Choose a Binding for which you want to add new things."),bindingRepository.getAll(),$scope.selectBinding=function(bindingId){discoveryService.getAll(function(supportedBindings){supportedBindings.indexOf(bindingId)>=0?$scope.navigateTo("setup/search/"+bindingId):$scope.navigateTo("setup/thing-types/"+bindingId)})}}).controller("SetupWizardSearchBindingController",function($scope,discoveryResultRepository,discoveryService,thingTypeRepository,bindingRepository){$scope.showIgnored=!1,$scope.toggleShowIgnored=function(){$scope.showIgnored=!$scope.showIgnored},$scope.bindingId=$scope.path[4];var binding=bindingRepository.find(function(binding){return binding.id===$scope.bindingId});$scope.setSubtitle([binding?binding.name:"","Search"]),$scope.setHeaderText("Searching for new things for the "+(binding?binding.name:"")+"."),$scope.discoverySupported=!0,discoveryService.getAll(function(supportedBindings){supportedBindings.indexOf($scope.bindingId)>=0&&($scope.discoverySupported=!0,$scope.scan($scope.bindingId))}),$scope.scanning=!1,$scope.filter=function(discoveryResult){return($scope.showIgnored||"NEW"===discoveryResult.flag)&&discoveryResult.thingUID.split(":")[0]===$scope.bindingId},$scope.scan=function(bindingId){$scope.scanning=!0,discoveryService.scan({bindingId:bindingId},function(response){var timeout=parseInt(response.timeout);timeout=1e3*(isNaN(timeout)?10:timeout),setTimeout(function(){$scope.$apply(function(){$scope.scanning=!1})},timeout)})},$scope.refresh=function(){discoveryResultRepository.getAll(!0)},$scope.refresh()}).controller("SetupWizardThingTypesController",function($scope,bindingRepository){$scope.bindingId=$scope.path[4];var binding=bindingRepository.find(function(binding){return binding.id===$scope.bindingId});$scope.setSubtitle([binding?binding.name:"","Choose Thing"]),$scope.setHeaderText("Choose a Thing from the "+(binding?binding.name:"")+" which you want to add."),$scope.selectThingType=function(thingTypeUID){$scope.navigateTo("setup/add/"+thingTypeUID)},$scope.filter=function(thingType){return thingType.UID.split(":")[0]===$scope.bindingId&&thingType.listed}}),angular.module("PaperUI.controllers.rules",["PaperUI.controllers.extension"]).controller("RulesPageController",function($scope,$location,$mdDialog,toastService,$timeout,templateRepository){function fetchTemplate(id){templateRepository.getOne(function(template){return template.uid==id},function(template){template?$location.path("rules/template/"+template.uid):(toastService.showDefaultToast("Rule template could not be found."),$scope.inProgress=!1)})}$scope.navigateTo=function(path){$location.path("rules/"+path)},$scope.inProgress=!1,$scope.openDialog=function(ctrl,url,params){$mdDialog.show({controller:ctrl,templateUrl:url,targetEvent:params.event,hasBackdrop:!0,locals:params})},$scope.getRuleJSON=function(sharedProperties,uid,name,desc){var rule={tags:[],conditions:sharedProperties.getModuleJSON("condition"),description:desc,name:name,triggers:sharedProperties.getModuleJSON("trigger"),configDescriptions:[],actions:sharedProperties.getModuleJSON("action")};return uid&&(rule.uid=uid),rule},$scope.installRuleExtenstion=function(id,installed){installed?fetchTemplate(id):($scope.install(id),$timeout(function(){$scope.inProgress=!1},3e4),$scope.inProgress=!0)},$scope.$on("RuleExtensionFailed",function(){$scope.inProgress=!1}),$scope.$on("RuleExtensionInstalled",function(event,id){fetchTemplate(id)})}).controller("RulesController",function($scope,$timeout,ruleRepository,ruleService,toastService,extensionService,sharedProperties){$scope.setHeaderText("Shows all rules."),$scope.ruleOptions=["New rule","Rule from template"],$scope.refresh=function(force){ruleRepository.getAll(null,force),extensionService.getAll(function(extensions){var hasRuleExtensions=$.grep(extensions,function(extension){return"ruletemplate"==extension.type}).length>0;hasRuleExtensions&&$scope.ruleOptions.push("Rule from catalog")})},$scope.configure=function(rule){$scope.navigateTo("configure/"+rule.uid)},$scope.remove=function(rule,e){e.stopImmediatePropagation(),$scope.openDialog("RuleRemoveController","partials/dialog.remove.html",{event:e,rule:rule})},$scope.refresh(!1),$scope.removePart=function(opt,id){sharedProperties.removeFromArray(opt,id)},$scope.toggleEnabled=function(rule,e){e.stopImmediatePropagation(),ruleService.setEnabled({ruleUID:rule.uid},(!rule.enabled).toString(),function(){rule.enabled?toastService.showDefaultToast("Rule enabled."):toastService.showDefaultToast("Rule disabled.")})},$scope.ruleOptionSelected=function(event,value){0==value?$scope.navigateTo("new"):1==value?$scope.openDialog("TemplateDialogController","partials/dialog.ruletemplate.html",{event:event}):$scope.navigateTo("catalog")},$scope.runRule=function(ruleUID,e){e.stopImmediatePropagation(),ruleService.runRule({ruleUID:ruleUID},function(response){toastService.showDefaultToast("Rule executed.")})}}).controller("NewRuleController",function($scope,itemRepository,ruleService,ruleRepository,toastService,$mdDialog,sharedProperties,moduleTypeService){function setModuleArrays(data){moduleTypeService.getByType({mtype:"trigger"}).$promise.then(function(moduleData){sharedProperties.setModuleTypes(moduleData),sharedProperties.addArray("trigger",data.triggers),sharedProperties.addArray("action",data.actions),sharedProperties.addArray("condition",data.conditions)})}$scope.setSubtitle(["New Rule"]),itemRepository.getAll(),sharedProperties.reset(),$scope.editing=!1;var ruleUID=$scope.path[3];$scope.path[3]?(ruleRepository.getOne(function(rule){return rule.uid===ruleUID},function(data){$scope.name=data.name,$scope.description=data.description,$scope.status=data.status,setModuleArrays(data)}),$scope.setTitle("Edit "+ruleUID),$scope.setSubtitle([]),$scope.editing=!0):sharedProperties.getParams().length>0&&sharedProperties.getParams()[0]&&($scope.name=sharedProperties.getParams()[0].label,$scope.description=sharedProperties.getParams()[0].description,setModuleArrays(sharedProperties.getParams()[0])),$scope.saveUserRule=function(){var rule=$scope.getRuleJSON(sharedProperties,null,$scope.name,$scope.description);ruleService.add(rule).$promise.then(function(){toastService.showDefaultToast("Rule added."),$scope.navigateTo("")})},$scope.updateUserRule=function(){var rule=$scope.getRuleJSON(sharedProperties,$scope.path[3],$scope.name,$scope.description);ruleService.update({ruleUID:$scope.path[3]},rule).$promise.then(function(){toastService.showDefaultToast("Rule updated."),$scope.navigateTo("")})},$scope.openNewModuleDialog=function(event,type){$scope.openDialog("addModuleDialogController","partials/dialog.addmodule.html",{event:event,module:{},ruleID:$scope.path[3]||"",type:type})},$scope.openUpdateModuleDialog=function(event,type,module){$scope.openDialog("addModuleDialogController","partials/dialog.addmodule.html",{event:event,module:module,ruleID:$scope.path[3]||"",type:type})},$scope.aTriggers=sharedProperties.getTriggersArray(),$scope.aActions=sharedProperties.getActionsArray(),$scope.aConditions=sharedProperties.getConditionsArray(),$scope.sortableOptions={handle:".draggable",update:function(e,ui){},axis:"y"}}).controller("RuleConfigureController",function($scope,ruleRepository,ruleService,toastService){$scope.setSubtitle(["Configure"]);var ruleUID=$scope.path[3];ruleRepository.getOne(function(rule){return rule.uid===ruleUID},function(rule){$scope.setSubtitle(["Configure "+rule.name])}),ruleService.getModuleConfigParameter({ruleUID:ruleUID},function(data){$scope.script=data.content}),$scope.save=function(){ruleService.setModuleConfigParameter({ruleUID:ruleUID},$scope.script,function(){toastService.showDefaultToast("Rule updated successfully."),$scope.navigateTo("")})}}).controller("RuleTemplateController",function($scope,$location,templateRepository,ruleService,configService,toastService){$scope.setTitle("Configure rule");var templateUID=$scope.path[3];templateUID&&templateRepository.getOne(function(template){return template.uid==templateUID},function(template){template&&($scope.parameters=configService.getRenderingModel(template.configDescriptions),$scope.name=template.label,$scope.description=template.description,$scope.configuration=configService.setConfigDefaults({},$scope.parameters),$scope.templateUID=template.uid)}),$scope.saveRule=function(){$scope.configuration=configService.replaceEmptyValues($scope.configuration);var rule={templateUID:$scope.templateUID,name:$scope.name,description:$scope.description,configuration:$scope.configuration};ruleService.add(rule).$promise.then(function(){toastService.showDefaultToast("Rule added."),$location.path("rules/")})}}).controller("TemplateDialogController",function($scope,$mdDialog,toastService,templateRepository,$location){templateRepository.getAll(function(templates){$scope.templateData=templates}),$scope.openConfig=function(templateUID){$mdDialog.hide(),$location.path("rules/template/"+templateUID)},$scope.close=function(){$mdDialog.hide()}}).controller("RuleRemoveController",function($scope,$mdDialog,toastService,ruleService,rule){$scope.rule=rule,$scope.remove=function(ruleUID){ruleService.remove({ruleUID:ruleUID},function(){$mdDialog.hide(),toastService.showDefaultToast("Rule removed.")},function(){$mdDialog.hide()})},$scope.close=function(){$mdDialog.hide()}}).directive("dragdrop",function(){return{restrict:"AE",replace:!0,template:'<span class="draggable md-icon-reorder"></span>',link:function(scope,elem,attrs){var touchHandler=function(event){var touch=event.changedTouches[0],simulatedEvent=document.createEvent("MouseEvent");simulatedEvent.initMouseEvent({touchstart:"mousedown",touchmove:"mousemove",touchend:"mouseup"}[event.type],!0,!0,window,1,touch.screenX,touch.screenY,touch.clientX,touch.clientY,!1,!1,!1,!1,0,null),touch.target.dispatchEvent(simulatedEvent),event.preventDefault()};elem[0].addEventListener("touchstart",touchHandler,!0),elem[0].addEventListener("touchmove",touchHandler,!0),elem[0].addEventListener("touchend",touchHandler,!0),elem[0].addEventListener("touchcancel",touchHandler,!0)}}}).directive("scriptarea",function(){return{restrict:"A",require:"ngModel",link:function(scope,elem,attrs,ngModel){function validateAtrribute(){var modelArr=document.getElementsByName(attrs.name);if(modelArr&&modelArr.length>0){var modelValue=modelArr[0].value;modelValue&&(modelValue.length<localAttrs.ngMinlength||modelValue.length>localAttrs.ngMaxlength)?element.addClass("border-invalid"):void 0!==modelValue&&""!=modelValue||!localAttrs.ngRequired?element.removeClass("border-invalid"):element.addClass("border-invalid")}}elem.ready(function(){setTimeout(function(){elem[0].style.cssText="height:auto;",elem[0].style.cssText="height:"+elem[0].scrollHeight+"px"},500)});var localAttrs=attrs,element=elem,resizeHandler=function(event){elem[0].style.cssText="height:auto;",elem[0].value.length<1?elem[0].style.cssText="height:35px":elem[0].style.cssText="height:"+elem[0].scrollHeight+"px",validateAtrribute()};elem[0].addEventListener("keydown",resizeHandler,!0),elem[0].addEventListener("input",resizeHandler,!0),elem[0].addEventListener("cut",resizeHandler),elem[0].addEventListener("blur",function(){validateAtrribute()})}}}),angular.module("PaperUI.controllers.rules").controller("addModuleDialogController",function($rootScope,$scope,$mdDialog,moduleTypeService,sharedProperties,$filter,configService,module,ruleID,type){function getModulesByType(mtype,callback){moduleTypeService.getByType({mtype:mtype}).$promise.then(function(data){var modules=objectFilter(data,{visibility:"VISIBLE"});("trigger"!=mtype||"trigger"==type)&&($scope.moduleData=modules),callback?($scope.triggerData=modules,$scope.module&&callback()):getModulesByType("trigger",setConfigurations)})}function filterByUid(data,uid){return objectFilter(data,{uid:uid})}var objectFilter=$filter("filter");$scope.moduleData,$scope.triggerData,getModulesByType(type,"trigger"==type?setConfigurations:null),$scope.id=module.id,$scope.type=type,$scope.description="",$scope.module="",$scope.step=1,$scope.editMode=!1,$scope.configuration={},$scope.parameters=[];var originalConfiguration={};$scope.items=[],$scope.selectChip=function(chip,textAreaName){var textArea=$("textarea[name="+textAreaName+"]")[0],textBefore=textArea.value.substring(0,textArea.selectionStart),textAfter=textArea.value.substring(textArea.selectionStart,textArea.value.length);$scope.configuration[textAreaName]=textBefore+chip.name+textAfter};var setConfigurations=function(){if($scope.moduleData){var params=filterByUid($scope.moduleData,$scope.module);params&&params.length>0&&($scope.parameters=configService.getRenderingModel(params[0].configDescriptions));var hasScript=!1;angular.forEach($scope.parameters,function(value){sharedProperties.updateParams(value),hasScript=$.grep(value.parameters,function(parameter){return"script"==parameter.context}).length>0});var index=sharedProperties.searchArray(sharedProperties.getModuleArray(type),$scope.id);if(-1!=index&&($scope.configuration=configService.convertValues(sharedProperties.getModuleArray(type)[index].configuration),angular.copy($scope.configuration,originalConfiguration)),$scope.configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters),hasScript&&"trigger"!=type){var triggers=sharedProperties.getModuleArray("trigger");if(angular.forEach(triggers,function(trigger,i){var moduleType=filterByUid($scope.triggerData,trigger.type);moduleType&&moduleType.length>0&&($scope.items=$scope.items.concat(moduleType[0].outputs))}),"action"==type)for(var actions=sharedProperties.getModuleArray("action"),i=0;i<sharedProperties.searchArray(actions,$scope.id);i++){var moduleType=filterByUid($scope.moduleData,actions[i].type);moduleType[0]&&moduleType[0].outputs&&moduleType[0].outputs.length>0&&($scope.items=$scope.items.concat(moduleType[0].outputs))}}}};$scope.id&&($scope.editMode=!0,$scope.module=module.type,$scope.name=module.label,$scope.description=module.description,setConfigurations(),$scope.step=2),$scope.parameters=sharedProperties.getParams(),$scope.close=function(){sharedProperties.resetParams();var index=sharedProperties.searchArray(sharedProperties.getModuleArray(type),$scope.id);-1!=index&&(sharedProperties.getModuleArray(type)[index].configuration=originalConfiguration),$mdDialog.hide()},$scope.saveModule=function(){var tempModule=filterByUid($scope.moduleData,$scope.module);if(null!=tempModule&&tempModule.length>0){tempModule[0].label=$scope.name;var configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters,!0);configuration=configService.replaceEmptyValues(configuration);var obj={id:$scope.id,label:$scope.name,description:$scope.description,type:tempModule[0].uid,configuration:configuration};sharedProperties.updateModule($scope.type,obj)}sharedProperties.resetParams(),$mdDialog.hide()},$scope.deleteModule=function(opt){sharedProperties.removeFromArray(opt,$scope.id),sharedProperties.resetParams(),$mdDialog.hide()},$scope.secondStep=function(){var tempModule=filterByUid($scope.moduleData,$scope.module);null!=tempModule&&tempModule.length>0&&($scope.name=tempModule[0].label,$scope.description=tempModule[0].description,setConfigurations(),$scope.step=2)}}).directive("mdChips",function(){return{restrict:"E",require:"mdChips",link:function(scope,element,attributes,ctrl){function deferListeners(){for(var chipContents=element[0].getElementsByClassName("md-chip-content"),i=0;i<chipContents.length;i++)chipContents[i].addEventListener("blur",function(){ctrl.$scope.$apply()})}setTimeout(deferListeners,500)}}}),angular.module("PaperUI.controllers",["PaperUI.constants"]).controller("BodyController",function($rootScope,$scope,$http,$location,eventService,toastService,discoveryResultRepository,thingTypeRepository,bindingRepository,restConfig,util){function getItemIndex(itemName){if($rootScope.data.items)for(var it=0;it<$rootScope.data.items.length;it++)if($rootScope.data.items[it].name==itemName)return it;return-1}$scope.scrollTop=0,$(window).scroll(function(){$scope.$apply(function(scope){$scope.scrollTop=$("body").scrollTop()})}),$scope.isBigTitle=function(){return $scope.scrollTop<80&&!$rootScope.simpleHeader},$scope.setTitle=function(title){$rootScope.title=title},$scope.subtitles=[],$scope.setSubtitle=function(args){$scope.subtitles=[],$.each(args,function(i,subtitle){$scope.subtitles.push(subtitle)})},$scope.setHeaderText=function(headerText){$scope.headerText=headerText},$rootScope.$on("$routeChangeStart",function(){$scope.subtitles=[],$scope.headerText=null}),$scope.generateUUID=function(){var d=(new Date).getTime(),uuid="xxxxxxxx".replace(/[x]/g,function(c){var r=(d+16*Math.random())%16|0;return d=Math.floor(d/16),("x"==c?r:3&r|8).toString(16)});return uuid};var prevAudioUrl="";eventService.onEvent("smarthome/inbox/*/added",function(topic,discoveryResult){toastService.showDefaultToast("New Inbox Entry: "+discoveryResult.label,"Show Inbox","inbox/search")}),eventService.onEvent("smarthome/webaudio/playurl",function(topic,audioUrl){if(prevAudioUrl!==audioUrl){var context;if(window.AudioContext=window.AudioContext||window.webkitAudioContext,"undefined"!=typeof window.AudioContext)try{context=new AudioContext;var audioBuffer=null;$http({url:audioUrl,method:"GET",responseType:"arraybuffer"}).then(function(response){context.decodeAudioData(response.data,function(buffer){audioBuffer=buffer;var source=context.createBufferSource();source.buffer=buffer,source.connect(context.destination),source.onended=function(){context.close()},source.start(0)})})}catch(e){context&&context.close()}else angular.element("#audioSink").attr("src",audioUrl);prevAudioUrl=audioUrl}}),eventService.onEvent("smarthome/items/*/state",function(topic,stateObject){var itemName=topic.split("/")[2],state=stateObject.value;if(console.log("Item "+itemName+" updated: "+state),$rootScope.itemUpdates[itemName]+500>(new Date).getTime())return void console.log("Ignoring update for "+itemName+", because update was probably triggered through UI.");var changeStateRecursively=function(item){var updateState=!0;if(item.name===itemName){if("Dimmer"===item.type&&("ON"===state||"OFF"==state)&&(updateState=!1),"Number"===item.type||"Number"===item.groupType){var parsedValue=Number(state);isNaN(parsedValue)||(state=parsedValue)}"Rollershutter"===item.type&&("Percent"==stateObject.type||"Decimal"==stateObject.type)&&(state=parseInt(stateObject.value)),updateState?$scope.$apply(function(scope){item.state=state,item.stateText=util.getItemStateText(item)}):console.log("Ignoring state "+state+" for "+itemName)}item.members&&$.each(item.members,function(i,memberItem){changeStateRecursively(memberItem)})},index=getItemIndex(itemName);-1!==index&&changeStateRecursively($rootScope.data.items[index])}),eventService.onEvent("smarthome/items/*/statechanged",function(topic,stateObject){var itemName=topic.split("/")[2];if(itemName&&("Percent"==stateObject.type||"Decimal"==stateObject.type)){var index=getItemIndex(itemName);-1!==index&&$scope.$apply(function(scope){$rootScope.data.items[index].state=parseFloat(stateObject.value),$rootScope.data.items[index].stateText=util.getItemStateText($rootScope.data.items[index])})}}),$scope.getNumberOfNewDiscoveryResults=function(){var numberOfNewDiscoveryResults=0;if(!$scope.data.discoveryResults)return numberOfNewDiscoveryResults;for(var i=0;i<$scope.data.discoveryResults.length;i++){var discoveryResult=$scope.data.discoveryResults[i];"NEW"===discoveryResult.flag&&numberOfNewDiscoveryResults++}return numberOfNewDiscoveryResults},$http.get(restConfig.restPath+"/links/auto").then(function(response){void 0!==response.data&&($rootScope.advancedMode=!response.data,window.localStorage.setItem("paperui.advancedMode",!response.data))}),discoveryResultRepository.getAll(),bindingRepository.getAll()}).controller("PreferencesPageController",function($rootScope,$scope,$window,$location,toastService){$scope.setHeaderText("Edit user preferences.");var localStorage=window.localStorage,language=localStorage.getItem("paperui.language");$scope.language=language?language:"english",$scope.save=function(){localStorage.setItem("paperui.language",$scope.language),toastService.showSuccessToast("Preferences saved successfully."),setTimeout(function(){$window.location.reload()},1500)},$scope.getSelected=function(property){return $("select#"+property+" option:selected").val()}}).controller("NavController",function($scope,$location,$http,restConfig,moduleConfig){$scope.opened=null,$scope.extensionEnabled,$scope.ruleEnabled,$scope.open=function(viewLocation){$scope.opened=viewLocation},$scope.isActive=function(viewLocation){var active=viewLocation===$location.path().split("/")[1];return active||$scope.opened===viewLocation},$scope.isSubActive=function(viewLocation){var active=viewLocation===$location.path().split("/")[2];return active},$scope.isHidden=function(module){return(moduleConfig[module].hasOwnProperty("visible")?moduleConfig[module].visible:moduleConfig[module])===!1},$scope.getLabel=function(property){var object=moduleConfig&&moduleConfig[property]?moduleConfig[property]:"";return object&&object.hasOwnProperty("label")&&object.label?object.label:"Extensions";
},$scope.$on("$routeChangeSuccess",function(){$("body").removeClass("sml-open"),$(".mask").remove(),$scope.opened=null}),$http.get(restConfig.restPath).then(function(response){if($scope.extensionEnabled=!1,$scope.ruleEnabled=!1,response.data&&response.data.links)for(var i=0;i<response.data.links.length;i++)"extensions"===response.data.links[i].type?$scope.extensionEnabled=!0:"rules"===response.data.links[i].type&&($scope.ruleEnabled=!0)})}),angular.module("PaperUI.controllers.configuration").controller("ItemSetupController",function($scope,$timeout,$location,$mdDialog,$filter,itemRepository,toastService,sharedProperties){$scope.navigateTo=function(path){$location.path("configuration/"+path)},$scope.setSubtitle(["Items"]),$scope.setHeaderText("Shows all configured Items."),$scope.items=[],$scope.groups=[],$scope.types=[],$scope.refresh=function(){itemRepository.getAll(function(items){$scope.items=items;for(var groups=[],types=[],i=0;i<items.length;i++)items[i].type&&"Group"==items[i].type&&groups.push(items[i]),items[i].type&&-1==types.indexOf(items[i].type)&&types.push(items[i].type);$scope.groups=groups,$scope.types=types},!0)},$scope.remove=function(item,event){event.stopImmediatePropagation(),$mdDialog.show({controller:"ItemRemoveController",templateUrl:"partials/dialog.remove.html",targetEvent:event,hasBackdrop:!0,locals:{item:item}}).then(function(){$scope.refresh()})},$scope.getSrcURL=function(category,type){return category?"../icon/"+category.toLowerCase():type?"../icon/"+type.toLowerCase().replace("item",""):""},$scope.clearAll=function(){$scope.searchText="",$scope.$broadcast("ClearFilters")},$scope.createItem=function(selectedType,selectedGroup){sharedProperties.updateParams({selectedType:selectedType,selectedGroup:selectedGroup?selectedGroup.name:""}),$scope.navigateTo("item/create")},$scope.refresh()}).controller("ItemConfigController",function($scope,$mdDialog,$filter,$location,toastService,itemService,itemConfig,itemRepository,sharedProperties){function putItem(text){"Group"!==$scope.item.type?(delete $scope.item["function"],delete $scope.item.groupType):setItemToFunction(),JSON.stringify($scope.item)!==JSON.stringify(originalItem)?(""==$scope.item.category&&($scope.item.category=null),itemService.create({itemName:$scope.item.name},$scope.item).$promise.then(function(){toastService.showDefaultToast(text),itemRepository.setDirty(!0),$scope.linking?$scope.$emit("ItemCreated",{status:!0,itemName:$scope.item.name,label:$scope.item.label}):$location.path("configuration/items"),sharedProperties.resetParams()},function(failed){$scope.linking?$scope.$emit("ItemCreated",{status:!1}):$location.path("configuration/items"),sharedProperties.resetParams()})):(toastService.showDefaultToast(text),$location.path("configuration/items"))}function setItemToFunction(){if(-1==$scope.item.groupType.indexOf("None")){var splitValue=$scope.item["function"].name.split("_");$scope.item["function"].name=splitValue[0],splitValue.length>1&&($scope.item["function"].params=[splitValue[1],splitValue[2]])}$scope.item["function"]&&!$scope.item["function"].name&&($scope.item["function"]=null)}function setFunctionToItem(){$scope.item["function"]&&$scope.item["function"].name&&$scope.item["function"].params&&($scope.item["function"].name+="_"+$scope.item["function"].params[0]+"_"+$scope.item["function"].params[1])}$scope.items=[],$scope.oldCategory,$scope.types=itemConfig.types,$scope.groupTypes=itemConfig.groupTypes,$scope.functions=[],$scope.selectedMember=null,$scope.selectedParent=null,$scope.searchText=null,$scope.childItems=[],$scope.linking=!1;var itemName,originalItem={};sharedProperties.getParams().length>0&&sharedProperties.getParams()[0].linking?($scope.linking=!0,$scope.types=sharedProperties.getParams()[0].acceptedItemType):$scope.path&&$scope.path.length>4&&(itemName=$scope.path[4]),itemService.getAll(function(items){if($scope.items=items,itemName){var items=$filter("filter")(items,{name:itemName},!0);items.length>0&&($scope.item=items[0],setFunctionToItem(),angular.copy($scope.item,originalItem),$scope.item["function"]||($scope.item["function"]={name:""}),$scope.item.groupType||($scope.item.groupType="None"),$scope.configMode="edit",$scope.srcURL=$scope.getSrcURL($scope.item.category,$scope.item.type),$scope.oldCategory=$scope.item.category,$scope.setTitle("Edit "+$scope.item.name),$scope.setSubtitle([]))}else $scope.item={},$scope.item.groupNames=[],$scope.setTitle&&$scope.setTitle("Configuration"),$scope.setSubtitle&&$scope.setSubtitle(["New Item"]),$scope.types.length>0&&($scope.item.type=$scope.types[0]),sharedProperties.getParams().length>0&&(sharedProperties.getParams()[0].linking?($scope.item.name=sharedProperties.getParams()[0].suggestedName,$scope.item.label=sharedProperties.getParams()[0].suggestedLabel,$scope.item.category=sharedProperties.getParams()[0].suggestedCategory):(sharedProperties.getParams()[0].selectedType&&($scope.item.type=sharedProperties.getParams()[0].selectedType),sharedProperties.getParams()[0].selectedGroup&&($scope.item.groupNames=$scope.item.groupNames?$scope.item.groupNames:[],$scope.item.groupNames.push(sharedProperties.getParams()[0].selectedGroup)))),$scope.configMode="create"}),$scope.update=function(){putItem("Item updated.")},$scope.create=function(){putItem("Item created.")},$scope.renderIcon=function(){$scope.oldCategory=$scope.item.category,$scope.srcURL=$scope.getSrcURL($scope.item.category,$scope.item.type)},$scope.searchItem=function(searchText,onlyGroups){var criterion={name:searchText};onlyGroups&&(criterion.type="Group");var items=$filter("filter")($scope.items,criterion);return items=$filter("orderBy")(items,"name"),-1!=items.indexOf($scope.item.name)&&items.splice(items.indexOf($scope.item.name),1),items.map(function(item){return item.name})},$scope.openItem=function(){$location.path("configuration/item/edit/"+$scope.selectedItem)},$scope.setParentItem=function($chip){$chip?$scope.selectedParent=$chip:$scope.selectedParent=null},$scope.setMemberItem=function($chip){$chip?$scope.selectedMember=$chip:$scope.selectedMember=null},$scope.boxClicked=function(){$scope.selectedItem=null},$scope.$on("ItemLinkedClicked",function(event,args){event.preventDefault(),$scope.create()}),$scope.$watch("item.groupType",function(){if($scope.item){var groupType=$scope.item.groupType;switch(groupType){case"Number":case"Dimmer":case"Rollershutter":$scope.functions=itemConfig.arithmeticFunctions;break;case"Contact":$scope.functions=itemConfig.logicalOpenClosedFunctions;break;default:$scope.functions=itemConfig.logicalOnOffFunctions}}}),$scope.getSrcURL=function(category,type){return category?"../icon/"+category.toLowerCase():type?"../icon/"+type.toLowerCase().replace("item",""):""}}).controller("ItemRemoveController",function($scope,$mdDialog,$filter,$location,toastService,itemService,itemRepository,item){$scope.item=item,$scope.remove=function(itemName){itemService.remove({itemName:itemName},function(){itemRepository.setDirty(!0),toastService.showDefaultToast("Item removed.")}),$mdDialog.hide()},$scope.close=function(){$mdDialog.cancel()}}).directive("itemname",function(){return{restrict:"A",require:"ngModel",link:function(scope,element,attr,ctrl){function customValidator(ngModelValue){var items=getItems();return searchItemNameExists(ngModelValue,items)?(ctrl.$setValidity("nameValidator",!1),element.parent().addClass("md-input-invalid")):(ctrl.$setValidity("nameValidator",!0),null!=ngModelValue&&0!=ngModelValue.length&&element.parent().removeClass("md-input-invalid")),ngModelValue}function searchItemNameExists(value,arr){for(var i=0;i<arr.length;i++)if(arr[i].name==value)return!0;return!1}function getItems(){return scope.items}ctrl.$parsers.push(customValidator),setTimeout(function(){ctrl.$viewValue&&customValidator(ctrl.$viewValue)})}}}).directive("mdChips",function(){return{restrict:"E",require:"mdChips",link:function(scope,element,attributes,ctrl){function deferListeners(){for(var chipContents=element[0].getElementsByClassName("md-chip-content"),i=0;i<chipContents.length;i++)chipContents[i].addEventListener("blur",function(){ctrl.$scope.$apply()})}function addChipBlurEvent(){scope.$apply(),setTimeout(function(){scope.$apply()},300)}setTimeout(deferListeners,500),scope.createChip=function(chip){function deferListeners(){for(var chipContents=document.getElementsByClassName("md-chip-content"),i=0;i<chipContents.length;i++)chipContents[i].addEventListener("blur",addChipBlurEvent)}setTimeout(deferListeners,500)},scope.removeChip=function(chipIndex){var chipContents=document.getElementsByClassName("md-chip-content");chipContents.length>chipIndex&&chipContents[chipIndex].removeEventListener("blur",addChipBlurEvent)}}}}),angular.module("PaperUI.controllers.extension",["PaperUI.constants"]).controller("ExtensionPageController",function($scope,extensionService,bindingRepository,thingTypeRepository,eventService,toastService,$filter,$window,$timeout,$location,templateRepository){function registerWatchers(){function intern(local){var index=local;$scope.$watch(function(){return $scope.searchText[index]},function(newValue,oldValue){!$scope.showCards||void 0!==newValue&&newValue===oldValue||$scope.masonry(!0)})}for(var i=0;i<$scope.searchText.length;i++)intern(i)}$scope.navigateTo=function(path){$location.path("extensions/"+path)},$scope.extensionTypes=[];var view=window.localStorage.getItem("paperui.extension.view");$scope.showCards=view?"LIST"==view.toUpperCase()?!1:!0:!1,$scope.searchText=[],$scope.refresh=function(){extensionService.getAllTypes(function(extensionTypes){$scope.extensionTypes=[],$scope.searchText=new Array(extensionTypes.length),registerWatchers(),angular.forEach(extensionTypes,function(extensionType){$scope.extensionTypes.push({typeId:extensionType.id,label:extensionType.label,extensions:[],inProgress:!1})}),extensionService.getAll(function(extensions){angular.forEach(extensions,function(extension){var extensionType=$scope.getType(extension.type);void 0!==extensionType&&extensionType.extensions.push(extension)}),angular.forEach($scope.extensionTypes,function(extensionType){extensionType.extensions=$filter("orderBy")(extensionType.extensions,"label")})})})},$scope.changeView=function(showCards){showCards?window.localStorage.setItem("paperui.extension.view","card"):window.localStorage.setItem("paperui.extension.view","list"),$scope.showCards=showCards},$scope.getType=function(extensionTypeId){var result;return angular.forEach($scope.extensionTypes,function(extensionType){extensionType.typeId===extensionTypeId&&(result=extensionType)}),result},$scope.getExtension=function(extensionId){var result;return angular.forEach($scope.extensionTypes,function(extensionType){angular.forEach(extensionType.extensions,function(extension){extension.id===extensionId&&(result=extension)})}),result},$scope.refresh(),$scope.install=function(extensionId){var extension=$scope.getExtension(extensionId);extension.inProgress=!0,extensionService.install({id:extensionId}),bindingRepository.setDirty(!0),thingTypeRepository.setDirty(!0)},$scope.installExtensionFromURL=function(url){return extensionService.installFromURL({url:url})},$scope.uninstall=function(extensionId){var extension=$scope.getExtension(extensionId);extension.inProgress=!0,extensionService.uninstall({id:extensionId}),bindingRepository.setDirty(!0),thingTypeRepository.setDirty(!0)},$scope.openExternalLink=function(link){link&&$window.open(link,"_blank")},$scope.filterItems=function(lookupFields){return function(item){var searchText=$scope.searchText[$scope.selectedIndex];if(searchText&&searchText.length>0){for(var i=0;i<lookupFields.length;i++)if(item[lookupFields[i]]&&-1!=item[lookupFields[i]].toUpperCase().indexOf(searchText.toUpperCase()))return!0;return!1}return!0}},$scope.masonry=function(showCards){showCards&&$timeout(function(){var itemContainer="#extensions-"+($scope.selectedIndex?$scope.selectedIndex:0);new Masonry(itemContainer,{})},1,!0)},eventService.onEvent("smarthome/extensions/*",function(topic,extensionObject){var id=extensionObject;extensionObject&&Array.isArray(extensionObject)&&(id=extensionObject[0]);var extension=$scope.getExtension(id);if(extension)if(extension.inProgress=!1,topic.indexOf("uninstalled")>-1)extension.installed=!1,toastService.showDefaultToast("Extension "+extension.label+" uninstalled.");else if(topic.indexOf("installed")>-1)extension.installed=!0,toastService.showDefaultToast("Extension "+extension.label+" installed."),"ruletemplate"==extension.type&&$scope.$broadcast("RuleExtensionInstalled",extension.id);else{var msg=Array.isArray(extensionObject)?extensionObject[1]:"Install or uninstall of extension "+extension.label+" failed.";toastService.showDefaultToast(msg),$scope.$broadcast("RuleExtensionFailed")}})}).directive("droppable",function(toastService){return{restrict:"A",link:function(scope,element,attrs){scope.ondrag=!1;var counter=0;element[0].addEventListener("dragover",function(event){event.preventDefault()}),element[0].addEventListener("dragenter",function(event){event.preventDefault(),0==counter&&scope.$apply(function(){scope.ondrag=!0}),counter++}),element[0].addEventListener("dragleave",function(event){event.preventDefault(),counter--,0==counter&&scope.$apply(function(){scope.ondrag=!1})}),element[0].addEventListener("drop",function(event){event.preventDefault();var data=event.dataTransfer.getData("Text"),response=scope.installExtensionFromURL(data);response.$promise.then(function(){toastService.showDefaultToast("Extension installed from URL"),scope.ondrag=!1},function(){toastService.showDefaultToast("Extension installation from URL failed"),scope.ondrag=!1})})}}}),angular.module("PaperUI.controllers.control",[]).controller("ControlPageController",function($scope,$routeParams,$location,$timeout,$filter,itemRepository,thingTypeRepository,util,thingRepository,channelTypeRepository){function renderTabs(){thingRepository.getAll(function(things){$scope.tabs=getTabs(things)})}function getTabs(things){if(!things)return[];var locations=new Set;angular.forEach(things,function(thing){var location=thing.location?thing.location.toUpperCase():"OTHER";thing.location=location,locations.add(location)});var renderedTabs=Array.from(locations);return renderedTabs=renderedTabs.sort(function(a,b){return"OTHER"===a?1:"OTHER"===b?-1:b>a?-1:a>b?1:0}),renderedTabs.map(function(location){return{name:location,thingCount:1}})}$scope.tabs=[],$scope.navigateTo=function(path){$location.path(path)},$scope.refresh=function(){itemRepository.getAll(function(){channelTypeRepository.getAll(function(){thingTypeRepository.getAll(function(){renderTabs()})})})},$scope.refresh()}).controller("ControlController",function($scope,$timeout,$filter,itemService,util,$attrs,thingRepository,channelTypeRepository,thingTypeRepository,thingConfigService,imageService){function renderThing(thing,thingType,channelTypes){thing.thingChannels=thingConfigService.getThingChannels(thing,thingType,channelTypes,!0),angular.forEach(thing.thingChannels,function(thingChannel){thingChannel.channels=thingChannel.channels.filter(function(channel){return channel.linkedItems.length>0})});var hasChannels=!1;return angular.forEach(thing.thingChannels,function(channelGroup){angular.forEach(channelGroup.channels,function(channel){channel.items=getItems(channel.linkedItems),hasChannels=!0})}),hasChannels?thing:void 0}var tabName=$scope.$parent.tab.name,tabIndex=$scope.$parent.$index;$scope.things=[];var renderedThings=[],renderItems=function(){var redraw;thingRepository.getAll(function(things){var thingsForTab=things.filter(function(thing){var thingLocation=thing.location?thing.location.toUpperCase():"OTHER";return thingLocation===tabName});channelTypeRepository.getAll(function(channelTypes){angular.forEach(thingsForTab,function(thing){thingTypeRepository.getOne(function(thingType){return thingType.UID===thing.thingTypeUID},function(thingType){var renderedThing=renderThing(thing,thingType,channelTypes);renderedThing&&(renderedThings.push(renderedThing),renderedThings=renderedThings.sort(function(a,b){return a.label<b.label?-1:a.label>b.label?1:0}),$timeout.cancel(redraw),redraw=$timeout(function(){$scope.things=renderedThings,masonry()},0,!0))},!1)})},!1)},!1)},masonry=function(){$timeout(function(){new Masonry("#items-"+tabIndex,{})},100,!1)},getItems=function(itemNames){var items=$scope.data.items.filter(function(item){return itemNames.indexOf(item.name)>=0});return angular.forEach(items,function(item){if(item.type&&("Number"==item.type||"Number"==item.groupType||"Rollershutter"==item.type)){var parsedValue=Number(item.state);isNaN(parsedValue)?item.state=null:item.state=parsedValue}item.type&&"Image"==item.type&&(imageService.getItemState(item.name).then(function(state){item.state=state,item.imageLoaded=!0}),item.imageLoaded=!1),item.stateText=util.getItemStateText(item),item.readOnly=isReadOnly(item)}),items},isReadOnly=function(item){return item.stateDescription?item.stateDescription.readOnly:!1};$scope.getItemName=function(itemName){return itemName.replace(/_/g," ")},$scope.getMinText=function(item){return!item.stateDescription||isNaN(item.stateDescription.minimum)?"":item.stateDescription.pattern?sprintf(item.stateDescription.pattern,item.stateDescription.minimum):""+item.stateDescription.minimum},$scope.getMaxText=function(item){return!item.stateDescription||isNaN(item.stateDescription.maximum)?"":item.stateDescription.pattern?sprintf(item.stateDescription.pattern,item.stateDescription.maximum):""+item.stateDescription.maximum};var categories={Alarm:{},Battery:{},Blinds:{},ColorLight:{label:"Color",icon:"wb_incandescent"},Contact:{},DimmableLight:{label:"Brightness",icon:"wb_incandescent",showSwitch:!0},CarbonDioxide:{label:"CO2"},Door:{},Energy:{},Fan:{},Fire:{},Flow:{},GarageDoor:{},Gas:{},Humidity:{},Light:{},Motion:{},MoveControl:{},Player:{},PowerOutlet:{},Pressure:{},Rain:{},Recorder:{},Smoke:{},SoundVolume:{label:"Volume",icon:"volume_up"},Switch:{},Temperature:{label:"Temperature"},Water:{},Wind:{},Window:{},Zoom:{}};$scope.getLabel=function(item,defaultLabel){if(item.name)return item.label;if(item.category){var category=categories[item.category];return category?category.label?category.label:item.category:defaultLabel}return defaultLabel},$scope.getIcon=function(itemCategory,fallbackIcon){var defaultIcon=fallbackIcon?fallbackIcon:"radio_button_unchecked";return itemCategory&&categories[itemCategory]&&categories[itemCategory].icon?categories[itemCategory].icon:defaultIcon},$scope.showSwitch=function(itemCategory){if(itemCategory){var category=categories[itemCategory];if(category)return category.showSwitch}return!1},$scope.isOptionList=function(item){return null!=item.stateDescription&&item.stateDescription.options.length>0},renderItems()}).controller("ItemController",function($rootScope,$scope,itemService,util){$scope.editMode=!1,$scope.sendCommand=function(command,updateState){$rootScope.itemUpdates[$scope.item.name]=(new Date).getTime(),itemService.sendCommand({itemName:$scope.item.name},command),updateState&&($scope.item.state=command),$scope.item.stateText=util.getItemStateText($scope.item)},$scope.editState=function(){$scope.editMode=!0},$scope.updateState=function(){$scope.sendCommand($scope.item.state,!1),$scope.editMode=!1}}).controller("DefaultItemController",function($scope,itemService){$scope.longEditMode=$scope.shortEditMode=!1,$scope.optionListChanged=function(){$scope.sendCommand($scope.item.state,!1)},$scope.editState=function(shortField){shortField?$scope.shortEditMode=!0:$scope.longEditMode=!0},$scope.updateState=function(shortField){$scope.sendCommand($scope.item.state,!1),shortField?$scope.shortEditMode=!1:$scope.longEditMode=!1}}).controller("ImageItemController",function($scope,itemService){$scope.refreshCameraImage=function(){itemService.sendCommand({itemName:$scope.item.name},"REFRESH")}}).controller("SwitchItemController",function($scope,$timeout,itemService){("UNDEF"===$scope.item.state||"NULL"===$scope.item.state)&&($scope.item.state="-"),$scope.setOn=function(state){$scope.sendCommand(state)}}).controller("DimmerItemController",function($scope,$timeout){("UNDEF"===$scope.item.state||"NULL"===$scope.item.state)&&($scope.item.state="-"),$scope.state={switchState:parseInt($scope.item.state)>0},$scope.setSwitch=function(state){sendCommand(state?"ON":"OFF")},$scope.setBrightness=function(brightness){$scope.state.switchState=brightness>0,sendCommand(brightness)},$scope.$watch("item.state",function(brightness){$scope.state.switchState=brightness>0});var commandTimeout=void 0,sendCommand=function(command){commandTimeout&&$timeout.cancel(commandTimeout),commandTimeout=$timeout(function(){$scope.sendCommand(command),commandTimeout=void 0},300)}}).controller("ColorItemController",function($scope,$timeout,$element,itemService){function getStateAsObject(state){var stateParts=state.split(",");return 3==stateParts.length?{h:parseInt(stateParts[0]),s:parseInt(stateParts[1]),b:parseInt(stateParts[2])}:{h:0,s:0,b:0}}function toState(stateObject){return Math.ceil(stateObject.h)+","+Math.ceil(stateObject.s)+","+Math.ceil(stateObject.b)}function setColor(){$scope.pending||($timeout(function(){var stateObject=getStateAsObject($scope.item.state);stateObject.b=isNaN($scope.brightness)?"0":$scope.brightness,stateObject.s=isNaN($scope.saturation)?"0":$scope.saturation,stateObject.h=isNaN($scope.hue)?"0":$scope.hue,("UNDEF"==$scope.item.state||"NULL"===$scope.item.state||"-"===$scope.item.state)&&(stateObject.b=100,stateObject.s=100,$scope.brightness=stateObject.b,$scope.saturation=stateObject.s),$scope.item.state=toState(stateObject),$scope.sendCommand($scope.item.state),$scope.pending=!1},300),$scope.pending=!0)}("UNDEF"===$scope.item.state||"NULL"===$scope.item.state)&&($scope.item.state="-"),$scope.pending=!1,$scope.setBrightness=function(brightness){$scope.brightness=brightness,$scope.pending||($timeout(function(){var command=isNaN($scope.brightness)?"0":$scope.brightness;$scope.sendCommand(command),$scope.pending=!1},300),$scope.pending=!0)},$scope.setHue=function(hue){$scope.hue=hue,setColor()},$scope.setSaturation=function(saturation){$scope.saturation=saturation,setColor()},$scope.getHexColor=function(hue){var hsv=tinycolor({h:hue,s:1,v:1}).toHsv();return tinycolor(hsv).toHexString()};var setStates=function(){var stateObject=getStateAsObject($scope.item.state),hue=stateObject.h,brightness=stateObject.b,saturation=stateObject.s;$scope.hue=hue?hue:0,$scope.brightness=brightness?brightness:0,$scope.saturation=saturation?saturation:0};setStates(),$scope.$watch("item.state",function(){setStates()}),$scope.$watch("hue",function(){var hexColor=$scope.getHexColor($scope.hue);$($element).find(".hue .md-thumb").css("background-color",hexColor)});var hexColor=$scope.getHexColor();$($element).find(".hue .md-thumb").css("background-color",hexColor)}).controller("RollershutterItemController",function($scope){("UNDEF"===$scope.item.state||"NULL"===$scope.item.state)&&($scope.item.state="-")}).controller("PlayerItemController",function($scope,$timeout){var isInterrupted,time;$scope.onPrevDown=function(){isInterrupted=!1,time=(new Date).getTime(),$timeout(function(){isInterrupted||$scope.sendCommand("REWIND")},300)},$scope.onPrevUp=function(){var newTime=(new Date).getTime();time+300>newTime?(isInterrupted=!0,$scope.sendCommand("PREVIOUS")):$timeout(function(){$scope.sendCommand("PLAY")})},$scope.onNextDown=function(){isInterrupted=!1,time=(new Date).getTime(),$timeout(function(){isInterrupted||$scope.sendCommand("FASTFORWARD")},300)},$scope.onNextUp=function(){var newTime=(new Date).getTime();time+300>newTime?(isInterrupted=!0,$scope.sendCommand("NEXT")):$timeout(function(){$scope.sendCommand("PLAY")})}}).controller("LocationItemController",function($scope,$sce){$scope.init=function(){if("UNDEF"!==$scope.item.state&&"NULL"!==$scope.item.state){var latitude=parseFloat($scope.item.state.split(",")[0]),longitude=parseFloat($scope.item.state.split(",")[1]),bbox=longitude-.01+","+(latitude-.01)+","+(longitude+.01)+","+(latitude+.01),marker=latitude+","+longitude;$scope.formattedState=latitude+"°N "+longitude+"°E",$scope.url=$sce.trustAsResourceUrl("https://www.openstreetmap.org/export/embed.html?bbox="+bbox+"&marker="+marker)}else $scope.formattedState="- °N - °E"},$scope.$watch("item.state",function(){$scope.init()}),$scope.init()}).directive("itemStateDropdown",function(){return{restrict:"A",templateUrl:"partials/item.state.dropdown.html"}}),angular.module("PaperUI.controllers.configuration.bindings",["ngRoute","PaperUI.directive.searchField"]).config(["$routeProvider",function($routeProvider){$routeProvider.when("/configuration/bindings",{templateUrl:"partials/configuration.bindings.html",controller:"BindingController",title:"Configuration"}).when("/configuration/bindings/:bindingId",{templateUrl:"partials/configuration.binding.html",controller:"BindingDetailController",title:"Configuration"})}]).controller("BindingController",function($scope,$location,$mdDialog,bindingRepository,extensionService){$scope.navigateTo=function(path){$location.path(path)},$scope.bindings=[],$scope.extensionServiceAvailable=!1,extensionService.isAvailable(function(available){$scope.extensionServiceAvailable=available}),$scope.setSubtitle(["Bindings"]),$scope.setHeaderText("Shows all installed bindings."),$scope.refresh=function(){bindingRepository.getAll(function(bindings){$scope.bindings=bindings},!0)},$scope.configure=function(binding,event){event.stopPropagation(),$mdDialog.show({controller:"ConfigureBindingDialogController",templateUrl:"partials/dialog.configurebinding.html",targetEvent:event,hasBackdrop:!0,locals:{binding:binding}})},$scope.isConfigurable=function(binding){return binding.configDescriptionURI?!0:!1},$scope.refresh()}).controller("BindingDetailController",function($scope,$location,$mdExpansionPanel,$mdDialog,thingTypeRepository,bindingRepository,extensionService){var bindingId=$scope.path[3];$scope.filter={text:""},$scope.navigateTo=function(path){$location.path(path)},$scope.filterItems=function(lookupFields,searchText){return function(item){if(searchText&&searchText.length>0){for(var i=0;i<lookupFields.length;i++)if(item[lookupFields[i]]&&-1!=item[lookupFields[i]].toUpperCase().indexOf(searchText.toUpperCase()))return!0;return!1}return!0}},$scope.clearFilter=function(event){event&&27!==event.keyCode||($scope.filter.text="")},$scope.binding=void 0,bindingRepository.getOne(function(binding){return binding.id===bindingId},function(binding){$scope.setSubtitle(["Bindings",binding.name]),$scope.setHeaderText("Shows detailed binding information."),$scope.binding=binding,$scope.binding.thingTypes=[],thingTypeRepository.getAll(function(thingTypes){angular.forEach(thingTypes,function(thingType){thingType.UID.split(":")[0]===binding.id&&$scope.binding.thingTypes.push(thingType)})})}),$scope.configure=function(event){$mdDialog.show({controller:"ConfigureBindingDialogController",templateUrl:"partials/dialog.configurebinding.html",targetEvent:event,hasBackdrop:!0,locals:{binding:$scope.binding}})},$scope.isConfigurable=function(){return $scope.binding.configDescriptionURI?!0:!1}}).controller("ConfigureBindingDialogController",function($scope,$mdDialog,bindingRepository,bindingService,configService,configDescriptionService,toastService,binding){$scope.binding=binding,$scope.parameters=[],$scope.config={},binding.configDescriptionURI&&($scope.expertMode=!1,configDescriptionService.getByUri({uri:binding.configDescriptionURI},function(configDescription){configDescription&&($scope.parameters=configService.getRenderingModel(configDescription.parameters,configDescription.parameterGroups),$scope.configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters),$scope.configArray=configService.getConfigAsArray($scope.configuration,$scope.parameters))})),binding?bindingService.getConfigById({id:binding.id}).$promise.then(function(config){$scope.configuration=configService.convertValues(config),$scope.configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters),$scope.configArray=configService.getConfigAsArray($scope.configuration,$scope.parameters)},function(failed){$scope.configuration={},$scope.configArray=configService.getConfigAsArray($scope.configuration)}):($scope.newConfig=!0,$scope.serviceId="",$scope.configuration={"":""},$scope.configArray=[],$scope.expertMode=!0),$scope.close=function(){$mdDialog.hide()},$scope.addParameter=function(){$scope.configArray.push({name:"",value:void 0})},$scope.save=function(){$scope.expertMode&&($scope.configuration=configService.getConfigAsObject($scope.configArray,$scope.parameters));var configuration=configService.setConfigDefaults($scope.configuration,$scope.parameters,!0);bindingService.updateConfig({id:binding.id},configuration,function(){$mdDialog.hide(),toastService.showDefaultToast("Binding config updated.")})},$scope.$watch("expertMode",function(){$scope.expertMode?$scope.configArray=configService.getConfigAsArray($scope.configuration,$scope.parameters):$scope.configuration=configService.getConfigAsObject($scope.configArray,$scope.parameters)})});