/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.auth.oauth2client.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.smarthome.auth.oauth2client.internal.OAuthConnector;
import org.eclipse.smarthome.auth.oauth2client.internal.OAuthStoreHandler;
import org.eclipse.smarthome.auth.oauth2client.internal.PersistedParams;
import org.eclipse.smarthome.core.auth.client.oauth2.AccessTokenRefreshListener;
import org.eclipse.smarthome.core.auth.client.oauth2.AccessTokenResponse;
import org.eclipse.smarthome.core.auth.client.oauth2.OAuthClientService;
import org.eclipse.smarthome.core.auth.client.oauth2.OAuthException;
import org.eclipse.smarthome.core.auth.client.oauth2.OAuthResponseException;
import org.eclipse.smarthome.io.net.http.HttpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OAuthClientServiceImpl
implements OAuthClientService {
    public static final int DEFAULT_TOKEN_EXPIRES_IN_BUFFER_SECOND = 10;
    private static final String EXCEPTION_MESSAGE_CLOSED = "Client service is closed";
    private final transient Logger logger = LoggerFactory.getLogger(OAuthClientServiceImpl.class);
    @NonNullByDefault(value={})
    private OAuthStoreHandler storeHandler;
    private final String handle;
    private final int tokenExpiresInSeconds;
    private final HttpClientFactory httpClientFactory;
    private final List<AccessTokenRefreshListener> accessTokenRefreshListeners = new ArrayList<AccessTokenRefreshListener>();
    private PersistedParams persistedParams = new PersistedParams();
    private volatile boolean closed = false;

    private OAuthClientServiceImpl(String handle, int tokenExpiresInSeconds, HttpClientFactory httpClientFactory) {
        this.handle = handle;
        this.tokenExpiresInSeconds = tokenExpiresInSeconds;
        this.httpClientFactory = httpClientFactory;
    }

    static @Nullable OAuthClientServiceImpl getInstance(String handle, OAuthStoreHandler storeHandler, int tokenExpiresInSeconds, HttpClientFactory httpClientFactory) {
        PersistedParams persistedParamsFromStore = storeHandler.loadPersistedParams(handle);
        if (persistedParamsFromStore == null) {
            return null;
        }
        OAuthClientServiceImpl clientService = new OAuthClientServiceImpl(handle, tokenExpiresInSeconds, httpClientFactory);
        clientService.storeHandler = storeHandler;
        clientService.persistedParams = persistedParamsFromStore;
        return clientService;
    }

    static OAuthClientServiceImpl createInstance(String handle, OAuthStoreHandler storeHandler, HttpClientFactory httpClientFactory, PersistedParams params) {
        OAuthClientServiceImpl clientService = new OAuthClientServiceImpl(handle, params.tokenExpiresInSeconds, httpClientFactory);
        clientService.storeHandler = storeHandler;
        clientService.persistedParams = params;
        storeHandler.savePersistedParams(handle, clientService.persistedParams);
        return clientService;
    }

    public String getAuthorizationUrl(@Nullable String redirectURI, @Nullable String scope, @Nullable String state) throws OAuthException {
        this.persistedParams.state = state == null ? this.createNewState() : state;
        String scopeToUse = scope == null ? this.persistedParams.scope : scope;
        this.persistedParams.redirectUri = redirectURI;
        String authorizationUrl = this.persistedParams.authorizationUrl;
        if (authorizationUrl == null) {
            throw new OAuthException("Missing authorization url");
        }
        String clientId = this.persistedParams.clientId;
        if (clientId == null) {
            throw new OAuthException("Missing client ID");
        }
        OAuthConnector connector = new OAuthConnector(this.httpClientFactory);
        return connector.getAuthorizationUrl(authorizationUrl, clientId, redirectURI, this.persistedParams.state, scopeToUse);
    }

    public String extractAuthCodeFromAuthResponse(@NonNull String redirectURLwithParams) throws OAuthException {
        try {
            URL redirectURLObject = new URL(redirectURLwithParams);
            UrlEncoded urlEncoded = new UrlEncoded(redirectURLObject.getQuery());
            String stateFromRedirectURL = (String)urlEncoded.getValue("state", 0);
            if (stateFromRedirectURL == null) {
                if (this.persistedParams.state == null) {
                    return (String)urlEncoded.getValue("code", 0);
                }
                throw new OAuthException(String.format("state from redirectURL is incorrect.  Expected: %s Found: %s", this.persistedParams.state, stateFromRedirectURL));
            }
            if (stateFromRedirectURL.equals(this.persistedParams.state)) {
                return (String)urlEncoded.getValue("code", 0);
            }
            throw new OAuthException(String.format("state from redirectURL is incorrect.  Expected: %s Found: %s", this.persistedParams.state, stateFromRedirectURL));
        }
        catch (MalformedURLException e) {
            throw new OAuthException("Redirect URL is malformed", (Throwable)e);
        }
    }

    public AccessTokenResponse getAccessTokenResponseByAuthorizationCode(String authorizationCode, String redirectURI) throws OAuthException, IOException, OAuthResponseException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        if (this.persistedParams.redirectUri != null && !this.persistedParams.redirectUri.equals(redirectURI)) {
            throw new OAuthException(String.format("redirectURI should be the same from previous call #getAuthorizationUrl.  Expected: %s Found: %s", this.persistedParams.redirectUri, redirectURI));
        }
        String tokenUrl = this.persistedParams.tokenUrl;
        if (tokenUrl == null) {
            throw new OAuthException("Missing token url");
        }
        String clientId = this.persistedParams.clientId;
        if (clientId == null) {
            throw new OAuthException("Missing client ID");
        }
        OAuthConnector connector = new OAuthConnector(this.httpClientFactory);
        AccessTokenResponse accessTokenResponse = connector.grantTypeAuthorizationCode(tokenUrl, authorizationCode, clientId, this.persistedParams.clientSecret, redirectURI, Boolean.TRUE.equals(this.persistedParams.supportsBasicAuth));
        this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
        return accessTokenResponse;
    }

    public AccessTokenResponse getAccessTokenByImplicit(@Nullable String redirectURI, @Nullable String scope, @Nullable String state) throws OAuthException, IOException, OAuthResponseException {
        throw new UnsupportedOperationException("Implicit Grant is not implemented");
    }

    public AccessTokenResponse getAccessTokenByResourceOwnerPasswordCredentials(String username, String password, @Nullable String scope) throws OAuthException, IOException, OAuthResponseException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        String tokenUrl = this.persistedParams.tokenUrl;
        if (tokenUrl == null) {
            throw new OAuthException("Missing token url");
        }
        OAuthConnector connector = new OAuthConnector(this.httpClientFactory);
        AccessTokenResponse accessTokenResponse = connector.grantTypePassword(tokenUrl, username, password, this.persistedParams.clientId, this.persistedParams.clientSecret, scope, Boolean.TRUE.equals(this.persistedParams.supportsBasicAuth));
        this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
        return accessTokenResponse;
    }

    public AccessTokenResponse getAccessTokenByClientCredentials(@Nullable String scope) throws OAuthException, IOException, OAuthResponseException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        String tokenUrl = this.persistedParams.tokenUrl;
        if (tokenUrl == null) {
            throw new OAuthException("Missing token url");
        }
        String clientId = this.persistedParams.clientId;
        if (clientId == null) {
            throw new OAuthException("Missing client ID");
        }
        OAuthConnector connector = new OAuthConnector(this.httpClientFactory);
        AccessTokenResponse accessTokenResponse = connector.grantTypeClientCredentials(tokenUrl, clientId, this.persistedParams.clientSecret, scope, Boolean.TRUE.equals(this.persistedParams.supportsBasicAuth));
        this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
        return accessTokenResponse;
    }

    public AccessTokenResponse refreshToken() throws OAuthException, IOException, OAuthResponseException {
        AccessTokenResponse lastAccessToken;
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        try {
            lastAccessToken = this.storeHandler.loadAccessTokenResponse(this.handle);
        }
        catch (GeneralSecurityException e) {
            throw new OAuthException("Cannot decrypt access token from store", (Throwable)e);
        }
        if (lastAccessToken == null) {
            throw new OAuthException("Cannot refresh token because last access token is not available from handle: " + this.handle);
        }
        if (lastAccessToken.getRefreshToken() == null) {
            throw new OAuthException("Cannot refresh token because last access token did not have a refresh token");
        }
        String tokenUrl = this.persistedParams.tokenUrl;
        if (tokenUrl == null) {
            throw new OAuthException("tokenUrl is required but null");
        }
        OAuthConnector connector = new OAuthConnector(this.httpClientFactory);
        AccessTokenResponse accessTokenResponse = connector.grantTypeRefreshToken(tokenUrl, lastAccessToken.getRefreshToken(), this.persistedParams.clientId, this.persistedParams.clientSecret, this.persistedParams.scope, Boolean.TRUE.equals(this.persistedParams.supportsBasicAuth));
        if (StringUtil.isBlank((String)accessTokenResponse.getRefreshToken())) {
            accessTokenResponse.setRefreshToken(lastAccessToken.getRefreshToken());
        }
        this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
        this.accessTokenRefreshListeners.forEach(l -> l.onAccessTokenResponse(accessTokenResponse));
        return accessTokenResponse;
    }

    public @Nullable AccessTokenResponse getAccessTokenResponse() throws OAuthException, IOException, OAuthResponseException {
        AccessTokenResponse lastAccessToken;
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        try {
            lastAccessToken = this.storeHandler.loadAccessTokenResponse(this.handle);
        }
        catch (GeneralSecurityException e) {
            throw new OAuthException("Cannot decrypt access token from store", (Throwable)e);
        }
        if (lastAccessToken == null) {
            return null;
        }
        if (lastAccessToken.isExpired(LocalDateTime.now(), this.tokenExpiresInSeconds) && lastAccessToken.getRefreshToken() != null) {
            return this.refreshToken();
        }
        return lastAccessToken;
    }

    public void importAccessTokenResponse(AccessTokenResponse accessTokenResponse) throws OAuthException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
    }

    public void setTokenExpiresInBuffer(int tokenExpiresInBuffer) {
        this.persistedParams.tokenExpiresInSeconds = tokenExpiresInBuffer;
    }

    public void remove() throws OAuthException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        this.logger.debug("removing handle: {}", (Object)this.handle);
        this.storeHandler.remove(this.handle);
        this.close();
    }

    public void close() {
        this.closed = true;
        this.storeHandler = null;
        this.logger.debug("closing oauth client, handle: {}", (Object)this.handle);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void addAccessTokenRefreshListener(AccessTokenRefreshListener listener) {
        this.accessTokenRefreshListeners.add(listener);
    }

    public boolean removeAccessTokenRefreshListener(AccessTokenRefreshListener listener) {
        return this.accessTokenRefreshListeners.remove(listener);
    }

    private String createNewState() {
        return UUID.randomUUID().toString();
    }
}

