/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseTriggerModuleHandler;
import org.eclipse.smarthome.automation.handler.TriggerHandlerCallback;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.thing.events.ChannelTriggeredEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelEventTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber,
EventFilter {
    private final Logger logger = LoggerFactory.getLogger(ChannelEventTriggerHandler.class);
    public static final String MODULE_TYPE_ID = "core.ChannelEventTrigger";
    private final String eventOnChannel;
    private final String channelUID;
    private final String TOPIC = "smarthome/channels/*/triggered";
    private final Set<String> types = new HashSet<String>();
    private final BundleContext bundleContext;
    private final String CFG_CHANNEL_EVENT = "event";
    private final String CFG_CHANNEL = "channelUID";
    private ServiceRegistration eventSubscriberRegistration;

    public ChannelEventTriggerHandler(Trigger module, BundleContext bundleContext) {
        super(module);
        this.eventOnChannel = (String)module.getConfiguration().get("event");
        this.channelUID = (String)module.getConfiguration().get("channelUID");
        this.bundleContext = bundleContext;
        this.types.add("ChannelTriggeredEvent");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "smarthome/channels/*/triggered");
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, properties);
    }

    public void receive(Event event) {
        if (this.callback != null) {
            this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
            HashMap<String, Event> values = new HashMap<String, Event>();
            values.put("event", event);
            ((TriggerHandlerCallback)this.callback).triggered((Trigger)this.module, values);
        }
    }

    public boolean apply(Event event) {
        ChannelTriggeredEvent cte;
        this.logger.trace("->FILTER: {}:{}", (Object)event.getTopic(), (Object)"smarthome/channels/*/triggered");
        boolean eventMatches = false;
        if (event instanceof ChannelTriggeredEvent && (cte = (ChannelTriggeredEvent)event).getTopic().contains(this.channelUID)) {
            this.logger.trace("->FILTER: {}:{}", (Object)cte.getEvent(), (Object)this.eventOnChannel);
            eventMatches = true;
            if (this.eventOnChannel != null && !this.eventOnChannel.isEmpty() && !this.eventOnChannel.equals(cte.getEvent())) {
                eventMatches = false;
            }
        }
        return eventMatches;
    }

    public EventFilter getEventFilter() {
        return this;
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public void dispose() {
        super.dispose();
        if (this.eventSubscriberRegistration != null) {
            this.eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
    }
}

