/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEnablementActionHandler
extends BaseModuleHandler<Action>
implements ActionHandler {
    public static final String UID = "core.RuleEnablementAction";
    private static final String ENABLE_KEY = "enable";
    private static final String RULE_UIDS_KEY = "ruleUIDs";
    private final Logger logger = LoggerFactory.getLogger(RuleEnablementActionHandler.class);
    private final List<String> UIDs;
    private final boolean enable;

    public RuleEnablementActionHandler(Action module) {
        super((Module)module);
        Configuration config = module.getConfiguration();
        Boolean enable = (Boolean)config.get(ENABLE_KEY);
        if (enable == null) {
            throw new IllegalArgumentException("'enable' property can not be null.");
        }
        this.enable = enable;
        this.UIDs = (List)config.get(RULE_UIDS_KEY);
        if (this.UIDs == null) {
            throw new IllegalArgumentException("'ruleUIDs' property can not be null.");
        }
    }

    public Map<String, Object> execute(Map<String, Object> context) {
        for (String uid : this.UIDs) {
            if (this.callback != null) {
                this.callback.setEnabled(uid, this.enable);
                continue;
            }
            this.logger.warn("Action is not applied to {} because rule engine is not available.", (Object)uid);
        }
        return null;
    }
}

