/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.rulesupport.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.AbstractScriptedModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.ScriptedHandler;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ScriptedPrivateModuleHandlerFactory.class, ModuleHandlerFactory.class})
public class ScriptedPrivateModuleHandlerFactory
extends AbstractScriptedModuleHandlerFactory {
    private static final String PRIV_ID = "privId";
    private static final Collection<String> TYPES = Arrays.asList("jsr223.ScriptedAction", "jsr223.ScriptedCondition", "jsr223.ScriptedTrigger");
    private final Logger logger = LoggerFactory.getLogger(ScriptedPrivateModuleHandlerFactory.class);
    private final HashMap<String, ScriptedHandler> privateTypes = new HashMap();
    private int nextId = 0;

    public Collection<String> getTypes() {
        return TYPES;
    }

    protected ModuleHandler internalCreate(Module module, String ruleUID) {
        ModuleHandler moduleHandler = null;
        ScriptedHandler scriptedHandler = null;
        try {
            scriptedHandler = this.privateTypes.get(module.getConfiguration().get(PRIV_ID));
        }
        catch (Exception exception) {
            this.logger.warn("ScriptedHandler {} for ruleUID {} not found", module.getConfiguration().get(PRIV_ID), (Object)ruleUID);
        }
        if (scriptedHandler != null) {
            moduleHandler = this.getModuleHandler(module, scriptedHandler);
        }
        return moduleHandler;
    }

    public String addHandler(String privId, ScriptedHandler scriptedHandler) {
        this.privateTypes.put(privId, scriptedHandler);
        return privId;
    }

    public String addHandler(ScriptedHandler scriptedHandler) {
        String privId = "i" + this.nextId++;
        this.privateTypes.put(privId, scriptedHandler);
        return privId;
    }

    public void removeHandler(String privId) {
        this.privateTypes.remove(privId);
    }
}

