/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.config;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class AstroThingConfig {
    private String geolocation;
    private Double altitude;
    private Double latitude;
    private Double longitude;
    private Integer interval;
    private String thingUid;

    public void parseGeoLocation() {
        String[] geoParts = StringUtils.split((String)this.geolocation, (String)",");
        if (geoParts.length == 2) {
            this.latitude = this.toDouble(geoParts[0]);
            this.longitude = this.toDouble(geoParts[1]);
        } else if (geoParts.length == 3) {
            this.latitude = this.toDouble(geoParts[0]);
            this.longitude = this.toDouble(geoParts[1]);
            this.altitude = this.toDouble(geoParts[2]);
        }
    }

    private Double toDouble(String value) {
        try {
            return Double.parseDouble(StringUtils.trimToNull((String)value));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getGeolocation() {
        return this.geolocation;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public String getThingUid() {
        return this.thingUid;
    }

    public void setThingUid(String thingUid) {
        this.thingUid = thingUid;
    }

    public String toString() {
        TimeZone tz = TimeZone.getDefault();
        StringBuilder tzInfo = new StringBuilder();
        tzInfo.append(tz.getID());
        tzInfo.append(" (").append(tz.getDisplayName(false, 0)).append(" ").append(new SimpleDateFormat("Z").format(Calendar.getInstance().getTime()));
        tzInfo.append(")");
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("thing", (Object)this.thingUid).append("geolocation", (Object)this.geolocation).append("altitude", (Object)this.altitude).append("interval", (Object)this.interval).append("systemTimezone", (Object)tzInfo.toString()).append("daylightSavings", Calendar.getInstance().get(16) != 0).toString();
    }
}

