/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.job;

import org.eclipse.smarthome.binding.astro.handler.AstroThingHandler;
import org.eclipse.smarthome.binding.astro.internal.job.AbstractJob;
import org.eclipse.smarthome.binding.astro.internal.job.Job;
import org.eclipse.smarthome.binding.astro.internal.model.Planet;
import org.eclipse.smarthome.binding.astro.internal.model.Sun;
import org.eclipse.smarthome.binding.astro.internal.model.SunEclipse;
import org.eclipse.smarthome.binding.astro.internal.model.SunPhaseName;

public final class DailyJobSun
extends AbstractJob {
    private final AstroThingHandler handler;

    public DailyJobSun(String thingUID, AstroThingHandler handler) {
        super(thingUID);
        DailyJobSun.checkArgument(handler != null, "The handler must not be null");
        this.handler = handler;
    }

    @Override
    public void run() {
        this.handler.publishDailyInfo();
        String thingUID = this.getThingUID();
        LOGGER.info("Scheduled Astro event-jobs for thing {}", (Object)thingUID);
        Planet planet = this.handler.getPlanet();
        if (planet == null) {
            LOGGER.error("Planet not instantiated");
            return;
        }
        Sun sun = (Sun)planet;
        Job.scheduleRange(thingUID, this.handler, sun.getRise(), "rise#event");
        Job.scheduleRange(thingUID, this.handler, sun.getSet(), "set#event");
        Job.scheduleRange(thingUID, this.handler, sun.getNoon(), "noon#event");
        Job.scheduleRange(thingUID, this.handler, sun.getNight(), "night#event");
        Job.scheduleRange(thingUID, this.handler, sun.getMorningNight(), "morningNight#event");
        Job.scheduleRange(thingUID, this.handler, sun.getAstroDawn(), "astroDawn#event");
        Job.scheduleRange(thingUID, this.handler, sun.getNauticDawn(), "nauticDawn#event");
        Job.scheduleRange(thingUID, this.handler, sun.getCivilDawn(), "civilDawn#event");
        Job.scheduleRange(thingUID, this.handler, sun.getAstroDusk(), "astroDusk#event");
        Job.scheduleRange(thingUID, this.handler, sun.getNauticDusk(), "nauticDusk#event");
        Job.scheduleRange(thingUID, this.handler, sun.getCivilDusk(), "civilDusk#event");
        Job.scheduleRange(thingUID, this.handler, sun.getEveningNight(), "eveningNight#event");
        Job.scheduleRange(thingUID, this.handler, sun.getDaylight(), "daylight#event");
        SunEclipse eclipse = sun.getEclipse();
        Job.scheduleEvent(thingUID, this.handler, eclipse.getPartial(), "PARTIAL", "eclipse#event", false);
        Job.scheduleEvent(thingUID, this.handler, eclipse.getTotal(), "TOTAL", "eclipse#event", false);
        Job.scheduleEvent(thingUID, this.handler, eclipse.getRing(), "RING", "eclipse#event", false);
        Job.schedulePublishPlanet(thingUID, this.handler, sun.getZodiac().getEnd());
        Job.schedulePublishPlanet(thingUID, this.handler, sun.getSeason().getNextSeason());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.SUN_RISE, sun.getRise().getStart());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.SUN_SET, sun.getSet().getStart());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.NIGHT, sun.getNight().getStart());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.DAYLIGHT, sun.getDaylight().getStart());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.ASTRO_DAWN, sun.getAstroDawn().getStart());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.NAUTIC_DAWN, sun.getNauticDawn().getStart());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.CIVIL_DAWN, sun.getCivilDawn().getStart());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.ASTRO_DUSK, sun.getAstroDusk().getStart());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.NAUTIC_DUSK, sun.getNauticDusk().getStart());
        Job.scheduleSunPhase(thingUID, this.handler, SunPhaseName.CIVIL_DUSK, sun.getCivilDusk().getStart());
    }

    public String toString() {
        return "Daily job sun " + this.getThingUID();
    }
}

