/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.model;

import java.util.Calendar;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.smarthome.binding.astro.internal.util.DateTimeUtils;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;

public class Range {
    private Calendar start;
    private Calendar end;

    public Range() {
    }

    public Range(Calendar start, Calendar end) {
        this.start = start;
        this.end = end;
    }

    public Calendar getStart() {
        return this.start;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public QuantityType<Time> getDuration() {
        if (this.start == null || this.end == null) {
            return null;
        }
        if (this.start.after(this.end)) {
            return new QuantityType((Number)0, SmartHomeUnits.MINUTE);
        }
        return new QuantityType((Number)(this.end.getTimeInMillis() - this.start.getTimeInMillis()), MetricPrefix.MILLI((Unit)SmartHomeUnits.SECOND)).toUnit(SmartHomeUnits.MINUTE);
    }

    public boolean matches(Calendar cal) {
        long matchEnd;
        if (this.start == null && this.end == null) {
            return false;
        }
        long matchStart = this.start != null ? this.start.getTimeInMillis() : DateTimeUtils.truncateToMidnight(cal).getTimeInMillis();
        long l = matchEnd = this.end != null ? this.end.getTimeInMillis() : DateTimeUtils.endOfDayDate(cal).getTimeInMillis();
        return cal.getTimeInMillis() >= matchStart && cal.getTimeInMillis() < matchEnd;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("start", (Object)DateTimeUtils.getDate(this.start)).append("end", (Object)DateTimeUtils.getDate(this.end)).toString();
    }
}

