/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluez.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAdapter;
import org.eclipse.smarthome.binding.bluetooth.bluez.BlueZAdapterConstants;
import org.eclipse.smarthome.binding.bluetooth.bluez.handler.BlueZBridgeHandler;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;

@Component(service={ThingHandlerFactory.class}, configurationPid="binding.bluetooth.bluez")
public class BlueZHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Collections.singleton(BlueZAdapterConstants.THING_TYPE_BLUEZ);
    private final Map<ThingUID, ServiceRegistration<?>> serviceRegs = new HashMap();

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)BlueZAdapterConstants.THING_TYPE_BLUEZ)) {
            BlueZBridgeHandler handler = new BlueZBridgeHandler((Bridge)thing);
            this.registerBluetoothAdapter(handler);
            return handler;
        }
        return null;
    }

    private synchronized void registerBluetoothAdapter(BluetoothAdapter adapter) {
        this.serviceRegs.put((ThingUID)adapter.getUID(), this.bundleContext.registerService(BluetoothAdapter.class.getName(), (Object)adapter, new Hashtable()));
    }

    protected synchronized void removeHandler(ThingHandler thingHandler) {
        UID uid;
        ServiceRegistration<?> serviceReg;
        if (thingHandler instanceof BluetoothAdapter && (serviceReg = this.serviceRegs.remove(uid = (UID)((BluetoothAdapter)thingHandler).getUID())) != null) {
            serviceReg.unregister();
        }
    }
}

