/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAdapter;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAddress;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCharacteristic;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCompanyIdentifiers;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCompletionStatus;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDescriptor;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDeviceListener;
import org.eclipse.smarthome.binding.bluetooth.BluetoothService;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothConnectionStatusNotification;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothScanNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BluetoothDevice {
    private final Logger logger = LoggerFactory.getLogger(BluetoothDevice.class);
    protected ConnectionState connectionState = ConnectionState.DISCOVERING;
    protected final BluetoothAdapter adapter;
    protected final BluetoothAddress address;
    protected Integer manufacturer = null;
    protected String name;
    protected final Map<UUID, BluetoothService> supportedServices = new HashMap<UUID, BluetoothService>();
    protected Integer rssi = null;
    protected Integer txPower = null;
    private final List<BluetoothDeviceListener> eventListeners = new CopyOnWriteArrayList<BluetoothDeviceListener>();

    public BluetoothDevice(BluetoothAdapter adapter, BluetoothAddress address) {
        this.address = address;
        this.adapter = adapter;
    }

    public String getName() {
        return this.name;
    }

    public BluetoothAddress getAddress() {
        return this.address;
    }

    public BluetoothAdapter getAdapter() {
        return this.adapter;
    }

    public void setManufacturerId(int manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Integer getManufacturerId() {
        return this.manufacturer;
    }

    public BluetoothService getServices(UUID uuid) {
        return this.supportedServices.get(uuid);
    }

    public Collection<BluetoothService> getServices() {
        return this.supportedServices.values();
    }

    public void setTxPower(int txPower) {
        this.txPower = txPower;
    }

    public Integer getTxPower() {
        return this.txPower;
    }

    public boolean setRssi(int rssi) {
        boolean changed = this.rssi == null || this.rssi != rssi;
        this.rssi = rssi;
        return changed;
    }

    public Integer getRssi() {
        return this.rssi;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean supportsService(UUID uuid) {
        return this.supportedServices.containsKey(uuid);
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public boolean connect() {
        return false;
    }

    public boolean disconnect() {
        return false;
    }

    public boolean discoverServices() {
        return false;
    }

    public BluetoothCharacteristic getCharacteristic(UUID uuid) {
        for (BluetoothService service : this.supportedServices.values()) {
            if (!service.providesCharacteristic(uuid)) continue;
            return service.getCharacteristic(uuid);
        }
        return null;
    }

    public boolean readCharacteristic(BluetoothCharacteristic characteristic) {
        return false;
    }

    public boolean writeCharacteristic(BluetoothCharacteristic characteristic) {
        return false;
    }

    public boolean enableNotifications(BluetoothCharacteristic characteristic) {
        return false;
    }

    public boolean disableNotifications(BluetoothCharacteristic characteristic) {
        return false;
    }

    public boolean enableNotifications(BluetoothDescriptor descriptor) {
        return false;
    }

    public boolean disableNotifications(BluetoothDescriptor descriptor) {
        return false;
    }

    protected boolean addService(BluetoothService service) {
        if (this.supportedServices.containsKey(service.getUuid())) {
            return false;
        }
        this.logger.trace("Adding new service to device {}: {}", (Object)this.address, (Object)service);
        this.supportedServices.put(service.getUuid(), service);
        return true;
    }

    protected void addServices(List<UUID> uuids) {
        for (UUID uuid : uuids) {
            if (this.supportsService(uuid)) continue;
            this.addService(new BluetoothService(uuid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BluetoothService getServiceByHandle(int handle) {
        Map<UUID, BluetoothService> map = this.supportedServices;
        synchronized (map) {
            for (BluetoothService service : this.supportedServices.values()) {
                if (service.getHandleStart() > handle || service.getHandleEnd() < handle) continue;
                return service;
            }
        }
        return null;
    }

    protected BluetoothCharacteristic getCharacteristicByHandle(int handle) {
        BluetoothService service = this.getServiceByHandle(handle);
        if (service != null) {
            return service.getCharacteristicByHandle(handle);
        }
        return null;
    }

    public void addListener(BluetoothDeviceListener listener) {
        if (listener == null) {
            return;
        }
        this.eventListeners.add(listener);
    }

    public void removeListener(BluetoothDeviceListener listener) {
        this.eventListeners.remove(listener);
    }

    protected void notifyListeners(BluetoothEventType event, Object ... args) {
        for (BluetoothDeviceListener listener : this.eventListeners) {
            try {
                switch (event) {
                    case SCAN_RECORD: {
                        listener.onScanRecordReceived((BluetoothScanNotification)args[0]);
                        break;
                    }
                    case CONNECTION_STATE: {
                        listener.onConnectionStateChange((BluetoothConnectionStatusNotification)args[0]);
                        break;
                    }
                    case SERVICES_DISCOVERED: {
                        listener.onServicesDiscovered();
                        break;
                    }
                    case CHARACTERISTIC_READ_COMPLETE: {
                        listener.onCharacteristicReadComplete((BluetoothCharacteristic)args[0], (BluetoothCompletionStatus)((Object)args[1]));
                        break;
                    }
                    case CHARACTERISTIC_WRITE_COMPLETE: {
                        listener.onCharacteristicWriteComplete((BluetoothCharacteristic)args[0], (BluetoothCompletionStatus)((Object)args[1]));
                        break;
                    }
                    case CHARACTERISTIC_UPDATED: {
                        listener.onCharacteristicUpdate((BluetoothCharacteristic)args[0]);
                        break;
                    }
                    case DESCRIPTOR_UPDATED: {
                        listener.onDescriptorUpdate((BluetoothDescriptor)args[0]);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to inform listener '{}': {}", new Object[]{listener, e.getMessage(), e});
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BluetoothDevice [address=");
        builder.append(this.address);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", rssi=");
        builder.append(this.rssi);
        builder.append(", manufacturer=");
        builder.append(this.manufacturer);
        if (BluetoothCompanyIdentifiers.get(this.manufacturer) != null) {
            builder.append(" (");
            builder.append(BluetoothCompanyIdentifiers.get(this.manufacturer));
            builder.append(')');
        }
        builder.append(']');
        return builder.toString();
    }

    protected static enum BluetoothEventType {
        CONNECTION_STATE,
        SCAN_RECORD,
        CHARACTERISTIC_READ_COMPLETE,
        CHARACTERISTIC_WRITE_COMPLETE,
        CHARACTERISTIC_UPDATED,
        DESCRIPTOR_UPDATED,
        SERVICES_DISCOVERED;

    }

    public static enum ConnectionState {
        DISCOVERING,
        DISCOVERED,
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

