/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.openweathermap.internal.handler;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.smarthome.binding.openweathermap.internal.OpenWeatherMapBindingConstants;
import org.eclipse.smarthome.binding.openweathermap.internal.config.OpenWeatherMapAPIConfiguration;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapConnection;
import org.eclipse.smarthome.binding.openweathermap.internal.handler.AbstractOpenWeatherMapHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OpenWeatherMapAPIHandler
extends BaseBridgeHandler {
    private final Logger logger = LoggerFactory.getLogger(OpenWeatherMapAPIHandler.class);
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(OpenWeatherMapBindingConstants.THING_TYPE_WEATHER_API);
    private static final long INITIAL_DELAY_IN_SECONDS = 15L;
    private @Nullable ScheduledFuture<?> refreshJob;
    private final HttpClient httpClient;
    private final LocaleProvider localeProvider;
    @NonNullByDefault(value={})
    private OpenWeatherMapConnection connection;
    @NonNullByDefault(value={})
    private OpenWeatherMapAPIConfiguration config;

    public OpenWeatherMapAPIHandler(Bridge bridge, HttpClient httpClient, LocaleProvider localeProvider) {
        super(bridge);
        this.httpClient = httpClient;
        this.localeProvider = localeProvider;
    }

    public void initialize() {
        String language;
        int refreshInterval;
        this.logger.debug("Initialize OpenWeatherMap API handler '{}'.", (Object)this.getThing().getUID());
        this.config = (OpenWeatherMapAPIConfiguration)this.getConfigAs(OpenWeatherMapAPIConfiguration.class);
        boolean configValid = true;
        if (StringUtils.trimToNull((String)this.config.getApikey()) == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-missing-apikey");
            configValid = false;
        }
        if ((refreshInterval = this.config.getRefreshInterval()) < 10) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-not-supported-refreshInterval");
            configValid = false;
        }
        if ((language = this.config.getLanguage()) != null) {
            if (!OpenWeatherMapAPIConfiguration.SUPPORTED_LANGUAGES.contains((language = StringUtils.trimToEmpty((String)language)).toLowerCase())) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-not-supported-language");
                configValid = false;
            }
        } else {
            language = this.localeProvider.getLocale().getLanguage();
            if (OpenWeatherMapAPIConfiguration.SUPPORTED_LANGUAGES.contains(language)) {
                this.logger.debug("Language set to '{}'.", (Object)language);
                Configuration editConfig = this.editConfiguration();
                editConfig.put("language", (Object)language);
                this.updateConfiguration(editConfig);
            }
        }
        if (configValid) {
            this.connection = new OpenWeatherMapConnection(this, this.httpClient);
            this.updateStatus(ThingStatus.UNKNOWN);
            if (this.refreshJob == null || this.refreshJob.isCancelled()) {
                this.logger.debug("Start refresh job at interval {} min.", (Object)refreshInterval);
                this.refreshJob = this.scheduler.scheduleWithFixedDelay(this::updateThings, 15L, TimeUnit.MINUTES.toSeconds(refreshInterval), TimeUnit.SECONDS);
            }
        }
    }

    public void dispose() {
        this.logger.debug("Dispose OpenWeatherMap API handler '{}'.", (Object)this.getThing().getUID());
        if (this.refreshJob != null && !this.refreshJob.isCancelled()) {
            this.logger.debug("Stop refresh job.");
            if (this.refreshJob.cancel(true)) {
                this.refreshJob = null;
            }
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (command instanceof RefreshType) {
            this.scheduler.schedule(this::updateThings, 15L, TimeUnit.SECONDS);
        } else {
            this.logger.debug("The OpenWeatherMap binding is a read-only binding and cannot handle command '{}'.", (Object)command);
        }
    }

    public void childHandlerInitialized(ThingHandler childHandler, Thing childThing) {
        this.scheduler.schedule(() -> {
            this.updateThing((AbstractOpenWeatherMapHandler)childHandler, childThing);
            this.determineBridgeStatus();
        }, 15L, TimeUnit.SECONDS);
    }

    public void childHandlerDisposed(ThingHandler childHandler, Thing childThing) {
        this.determineBridgeStatus();
    }

    private void determineBridgeStatus() {
        ThingStatus status = ThingStatus.OFFLINE;
        for (Thing thing : this.getThing().getThings()) {
            if (!ThingStatus.ONLINE.equals((Object)thing.getStatus())) continue;
            status = ThingStatus.ONLINE;
            break;
        }
        this.updateStatus(status);
    }

    private void updateThings() {
        ThingStatus status = ThingStatus.OFFLINE;
        for (Thing thing : this.getThing().getThings()) {
            if (!ThingStatus.ONLINE.equals((Object)this.updateThing((AbstractOpenWeatherMapHandler)thing.getHandler(), thing))) continue;
            status = ThingStatus.ONLINE;
        }
        this.updateStatus(status);
    }

    private ThingStatus updateThing(@Nullable AbstractOpenWeatherMapHandler handler, Thing thing) {
        if (handler != null && this.connection != null) {
            handler.updateData(this.connection);
            return thing.getStatus();
        }
        this.logger.debug("Cannot update weather data of thing '{}' as location handler is null.", (Object)thing.getUID());
        return ThingStatus.OFFLINE;
    }

    public OpenWeatherMapAPIConfiguration getOpenWeatherMapAPIConfig() {
        return this.config;
    }
}

