/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.usbserial.linuxsysfs.internal;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.eclipse.smarthome.config.discovery.usbserial.linuxsysfs.internal.UsbSerialScanner;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid="discovery.usbserial.linuxsysfs.usbserialscanner")
@NonNullByDefault
public class SysfsUsbSerialScanner
implements UsbSerialScanner {
    private final Logger logger = LoggerFactory.getLogger(SysfsUsbSerialScanner.class);
    public static final String SYSFS_TTY_DEVICES_DIRECTORY_ATTRIBUTE = "sysfsTtyDevicesPath";
    public static final String DEV_DIRECTORY_ATTRIBUTE = "devPath";
    private static final String SYSFS_TTY_DEVICES_DIRECTORY_DEFAULT = "/sys/class/tty";
    private static final String DEV_DIRECTORY_DEFAULT = "/dev";
    private String sysfsTtyDevicesDirectory = "/sys/class/tty";
    private String devDirectory = "/dev";
    private static final String SYSFS_FILENAME_USB_VENDOR_ID = "idVendor";
    private static final String SYSFS_FILENAME_USB_PRODUCT_ID = "idProduct";
    private static final String SYSFS_FILENAME_USB_SERIAL_NUMBER = "serial";
    private static final String SYSFS_FILENAME_USB_MANUFACTURER = "manufacturer";
    private static final String SYSFS_FILENAME_USB_PRODUCT = "product";
    private static final String SYSFS_FILENAME_USB_INTERFACE_NUMBER = "bInterfaceNumber";
    private static final String SYSFS_FILENAME_USB_INTERFACE = "interface";
    private static final Pattern SYSFS_USB_INTERFACE_DIRECTORY_PATTERN = Pattern.compile("\\d+-(\\d+\\.?)*\\d+:\\d+\\.\\d+");

    @Activate
    protected void activate(Map<String, Object> config) {
        this.extractConfiguration(config);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        this.extractConfiguration(config);
    }

    @Override
    public Set<UsbSerialDeviceInformation> scan() throws IOException {
        HashSet<UsbSerialDeviceInformation> result = new HashSet<UsbSerialDeviceInformation>();
        for (SerialPortInfo serialPortInfo : this.getSerialPortInfos()) {
            try {
                UsbSerialDeviceInformation usbSerialDeviceInfo = this.tryGetUsbSerialDeviceInformation(serialPortInfo);
                if (usbSerialDeviceInfo == null) continue;
                result.add(usbSerialDeviceInfo);
            }
            catch (IOException e) {
                this.logger.warn("Could not extract USB device information for serial port {}: {}", (Object)serialPortInfo, (Object)e.getMessage());
            }
        }
        return result;
    }

    @Override
    public boolean canPerformScans() {
        return Files.isReadable(Paths.get(this.sysfsTtyDevicesDirectory, new String[0])) && Files.isReadable(Paths.get(this.devDirectory, new String[0]));
    }

    private Set<SerialPortInfo> getSerialPortInfos() throws IOException {
        HashSet<SerialPortInfo> result = new HashSet<SerialPortInfo>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<Path> sysfsTtyPaths = Files.newDirectoryStream(Paths.get(this.sysfsTtyDevicesDirectory, new String[0]));){
            for (Path sysfsTtyPath : sysfsTtyPaths) {
                String serialPortName = sysfsTtyPath.getFileName().toString();
                Path devicePath = Paths.get(this.devDirectory, new String[0]).resolve(serialPortName);
                Path sysfsDevicePath = this.getSysfsDevicePath(sysfsTtyPath);
                if (sysfsDevicePath == null || !Files.isReadable(devicePath) || !Files.isWritable(devicePath)) continue;
                result.add(new SerialPortInfo(devicePath, sysfsDevicePath));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private @Nullable Path getSysfsDevicePath(Path ttyFile) {
        try {
            return ttyFile.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            this.logger.warn("Could not find the device path for {} in the sysfs: {}", (Object)ttyFile, (Object)e.getMessage());
            return null;
        }
    }

    private @Nullable UsbSerialDeviceInformation tryGetUsbSerialDeviceInformation(SerialPortInfo serialPortInfo) throws IOException {
        Path usbInterfacePath = this.getUsbInterfaceParentPath(serialPortInfo.getSysfsPath());
        if (usbInterfacePath == null) {
            return null;
        }
        Path usbDevicePath = usbInterfacePath.getParent();
        if (this.isUsbDevicePath(usbDevicePath)) {
            return this.createUsbSerialDeviceInformation(usbDevicePath, usbInterfacePath, serialPortInfo.getDevicePath().toString());
        }
        return null;
    }

    private @Nullable Path getUsbInterfaceParentPath(Path sysfsPath) {
        if (sysfsPath.getFileName() == null) {
            return null;
        }
        if (SYSFS_USB_INTERFACE_DIRECTORY_PATTERN.matcher(sysfsPath.getFileName().toString()).matches()) {
            return sysfsPath;
        }
        Path parentPath = sysfsPath.getParent();
        if (parentPath == null) {
            return null;
        }
        return this.getUsbInterfaceParentPath(parentPath);
    }

    private boolean isUsbDevicePath(Path path) {
        return this.containsFile(path, SYSFS_FILENAME_USB_PRODUCT_ID) && this.containsFile(path, SYSFS_FILENAME_USB_VENDOR_ID);
    }

    private UsbSerialDeviceInformation createUsbSerialDeviceInformation(Path usbDevicePath, Path usbInterfacePath, String serialPortName) throws IOException {
        int vendorId = Integer.parseInt(this.getContent(usbDevicePath.resolve(SYSFS_FILENAME_USB_VENDOR_ID)), 16);
        int productId = Integer.parseInt(this.getContent(usbDevicePath.resolve(SYSFS_FILENAME_USB_PRODUCT_ID)), 16);
        String serialNumber = this.getContentIfFileExists(usbDevicePath.resolve(SYSFS_FILENAME_USB_SERIAL_NUMBER));
        String manufacturer = this.getContentIfFileExists(usbDevicePath.resolve(SYSFS_FILENAME_USB_MANUFACTURER));
        String product = this.getContentIfFileExists(usbDevicePath.resolve(SYSFS_FILENAME_USB_PRODUCT));
        int interfaceNumber = Integer.parseInt(this.getContent(usbInterfacePath.resolve(SYSFS_FILENAME_USB_INTERFACE_NUMBER)), 16);
        String interfaceDescription = this.getContentIfFileExists(usbInterfacePath.resolve(SYSFS_FILENAME_USB_INTERFACE));
        return new UsbSerialDeviceInformation(vendorId, productId, serialNumber, manufacturer, product, interfaceNumber, interfaceDescription, serialPortName);
    }

    private boolean containsFile(Path directoryPath, String filename) {
        Path filePath = directoryPath.resolve(filename);
        return Files.exists(filePath, new LinkOption[0]) && !Files.isDirectory(filePath, new LinkOption[0]);
    }

    private String getContent(Path path) throws IOException {
        return new String(Files.readAllBytes(path)).trim();
    }

    private @Nullable String getContentIfFileExists(Path path) throws IOException {
        return Files.exists(path, new LinkOption[0]) ? this.getContent(path) : null;
    }

    private void extractConfiguration(Map<String, Object> config) {
        boolean configurationIsChanged;
        String newSysfsTtyDevicesDirectory = config.getOrDefault(SYSFS_TTY_DEVICES_DIRECTORY_ATTRIBUTE, SYSFS_TTY_DEVICES_DIRECTORY_DEFAULT).toString();
        String newDevDirectory = config.getOrDefault(DEV_DIRECTORY_ATTRIBUTE, DEV_DIRECTORY_DEFAULT).toString();
        boolean bl = configurationIsChanged = !Objects.equals(this.sysfsTtyDevicesDirectory, newSysfsTtyDevicesDirectory) || !Objects.equals(this.devDirectory, newDevDirectory);
        if (configurationIsChanged) {
            this.sysfsTtyDevicesDirectory = newSysfsTtyDevicesDirectory;
            this.devDirectory = newDevDirectory;
        }
        if (!this.canPerformScans()) {
            String logString = String.format("Cannot perform scans with this configuration: sysfsTtyDevicesDirectory: {}, devDirectory: {}", this.sysfsTtyDevicesDirectory, this.devDirectory);
            if (configurationIsChanged) {
                this.logger.warn(logString);
            } else {
                this.logger.debug(logString);
            }
        }
    }

    private static class SerialPortInfo {
        private final Path devicePath;
        private final Path sysfsPath;

        public SerialPortInfo(Path devicePath, Path sysfsPath) {
            this.devicePath = devicePath;
            this.sysfsPath = sysfsPath;
        }

        public Path getDevicePath() {
            return this.devicePath;
        }

        public Path getSysfsPath() {
            return this.sysfsPath;
        }
    }
}

