/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterGroup;
import org.eclipse.smarthome.config.xml.util.ConverterAssertion;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.GenericUnmarshaller;
import org.eclipse.smarthome.config.xml.util.NodeIterator;

public class ConfigDescriptionConverter
extends GenericUnmarshaller<ConfigDescription> {
    private ConverterAttributeMapValidator attributeMapValidator = new ConverterAttributeMapValidator(new String[][]{{"uri", "false"}});

    public ConfigDescriptionConverter() {
        super(ConfigDescription.class);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConfigDescription configDescription = null;
        Map<String, String> attributes = this.attributeMapValidator.readValidatedAttributes(reader);
        String uriText = attributes.get("uri");
        if (uriText == null) {
            uriText = (String)context.get((Object)"config-description.uri");
        }
        URI uri = null;
        if (uriText == null) {
            throw new ConversionException("No URI provided");
        }
        try {
            uri = new URI(uriText);
        }
        catch (URISyntaxException ex) {
            throw new ConversionException("The URI '" + uriText + "' in node '" + reader.getNodeName() + "' is invalid!", (Throwable)ex);
        }
        ArrayList<ConfigDescriptionParameter> configDescriptionParams = new ArrayList<ConfigDescriptionParameter>();
        ArrayList<ConfigDescriptionParameterGroup> configDescriptionGroups = new ArrayList<ConfigDescriptionParameterGroup>();
        List nodes = (List)context.convertAnother((Object)context, List.class);
        NodeIterator nodeIterator = new NodeIterator(nodes);
        while (nodeIterator.hasNext()) {
            Object node = nodeIterator.next();
            if (node instanceof ConfigDescriptionParameter) {
                configDescriptionParams.add((ConfigDescriptionParameter)node);
            }
            if (!(node instanceof ConfigDescriptionParameterGroup)) continue;
            configDescriptionGroups.add((ConfigDescriptionParameterGroup)node);
        }
        ConverterAssertion.assertEndOfType(reader);
        configDescription = new ConfigDescription(uri, configDescriptionParams, configDescriptionGroups);
        return configDescription;
    }
}

