/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.semantics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.semantics.model.Property;
import org.eclipse.smarthome.core.semantics.model.Tag;
import org.eclipse.smarthome.core.semantics.model.TagInfo;
import org.eclipse.smarthome.core.semantics.model.equipment.Equipments;
import org.eclipse.smarthome.core.semantics.model.location.Locations;
import org.eclipse.smarthome.core.semantics.model.point.Control;
import org.eclipse.smarthome.core.semantics.model.point.Measurement;
import org.eclipse.smarthome.core.semantics.model.point.Points;
import org.eclipse.smarthome.core.semantics.model.property.Properties;
import org.eclipse.smarthome.core.types.StateDescription;

public class SemanticTags {
    private static String TAGS_BUNDLE_NAME = "tags";
    private static final Map<String, Class<? extends Tag>> TAGS = new TreeMap<String, Class<? extends Tag>>();

    static {
        Locations.stream().forEach(location -> SemanticTags.addTagSet(location));
        Equipments.stream().forEach(equipment -> SemanticTags.addTagSet(equipment));
        Points.stream().forEach(point -> SemanticTags.addTagSet(point));
        Properties.stream().forEach(property -> SemanticTags.addTagSet(property));
    }

    public static @Nullable Class<? extends Tag> getById(String tagId) {
        return TAGS.get(tagId);
    }

    public static @Nullable Class<? extends Tag> getByLabel(String tagLabel, Locale locale) {
        return TAGS.values().stream().distinct().filter(t -> SemanticTags.getLabel(t, locale).equalsIgnoreCase(tagLabel)).findFirst().orElse(null);
    }

    public static List<Class<? extends @NonNull Tag>> getByLabelOrSynonym(String tagLabelOrSynonym, Locale locale) {
        return TAGS.values().stream().distinct().filter(t -> SemanticTags.getLabelAndSynonyms(t, locale).contains(tagLabelOrSynonym.toLowerCase(locale))).collect(Collectors.toList());
    }

    public static List<String> getLabelAndSynonyms(Class<? extends Tag> tag, Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle(TAGS_BUNDLE_NAME, locale);
        try {
            String entry = rb.getString(tag.getAnnotation(TagInfo.class).id());
            return Arrays.asList(entry.toLowerCase(locale).split(","));
        }
        catch (MissingResourceException missingResourceException) {
            return Collections.singletonList(tag.getAnnotation(TagInfo.class).label());
        }
    }

    public static String getLabel(Class<? extends Tag> tag, Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle(TAGS_BUNDLE_NAME, locale);
        try {
            String entry = rb.getString(tag.getAnnotation(TagInfo.class).id());
            if (entry.contains(",")) {
                return entry.substring(0, entry.indexOf(","));
            }
            return entry;
        }
        catch (MissingResourceException missingResourceException) {
            return tag.getAnnotation(TagInfo.class).label();
        }
    }

    public static @Nullable Class<? extends Tag> getSemanticType(Item item) {
        Set tags = item.getTags();
        for (String tag : tags) {
            Class<? extends Tag> type = SemanticTags.getById(tag);
            if (type == null || Property.class.isAssignableFrom(type)) continue;
            return type;
        }
        if (SemanticTags.getProperty(item) != null) {
            StateDescription stateDescription = item.getStateDescription();
            if (stateDescription != null && stateDescription.isReadOnly()) {
                return Measurement.class;
            }
            return Control.class;
        }
        return null;
    }

    public static @Nullable Class<? extends Property> getProperty(Item item) {
        Set tags = item.getTags();
        for (String tag : tags) {
            Class<? extends Tag> type = SemanticTags.getById(tag);
            if (type == null || !Property.class.isAssignableFrom(type)) continue;
            return type;
        }
        return null;
    }

    private static void addTagSet(Class<? extends Tag> tagSet) {
        String id = tagSet.getAnnotation(TagInfo.class).id();
        while (id.indexOf("_") != -1) {
            TAGS.put(id, tagSet);
            id = id.substring(id.indexOf("_") + 1);
        }
        TAGS.put(id, tagSet);
    }
}

