/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;

@NonNullByDefault
public class ChannelGroupUID
extends UID {
    ChannelGroupUID() {
    }

    public ChannelGroupUID(String channelGroupUid) {
        super(channelGroupUid);
    }

    public ChannelGroupUID(ThingUID thingUID, String id) {
        super(ChannelGroupUID.toSegments(thingUID, id));
    }

    private static List<String> toSegments(ThingUID thingUID, String id) {
        ArrayList<String> ret = new ArrayList<String>(thingUID.getAllSegments());
        ret.add(id);
        return ret;
    }

    public String getId() {
        List<String> segments = this.getAllSegments();
        return segments.get(segments.size() - 1);
    }

    protected int getMinimalNumberOfSegments() {
        return 4;
    }

    public ThingUID getThingUID() {
        List<String> allSegments = this.getAllSegments();
        return new ThingUID(allSegments.subList(0, allSegments.size() - 1).toArray(new String[allSegments.size() - 1]));
    }
}

