/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.dto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.builder.BridgeBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.dto.ChannelDTO;
import org.eclipse.smarthome.core.thing.dto.ChannelDTOMapper;
import org.eclipse.smarthome.core.thing.dto.ThingDTO;
import org.eclipse.smarthome.core.thing.util.ThingHelper;

public class ThingDTOMapper {
    public static ThingDTO map(Thing thing) {
        ArrayList<ChannelDTO> channelDTOs = new ArrayList<ChannelDTO>();
        for (Channel channel : thing.getChannels()) {
            ChannelDTO channelDTO = ChannelDTOMapper.map(channel);
            channelDTOs.add(channelDTO);
        }
        String thingTypeUID = thing.getThingTypeUID().getAsString();
        String thingUID = thing.getUID().toString();
        ThingUID bridgeUID = thing.getBridgeUID();
        return new ThingDTO(thingTypeUID, thingUID, thing.getLabel(), bridgeUID != null ? bridgeUID.toString() : null, channelDTOs, ThingDTOMapper.toMap(thing.getConfiguration()), thing.getProperties(), thing.getLocation());
    }

    public static Thing map(ThingDTO thingDTO, boolean isBridge) {
        ThingUID thingUID = new ThingUID(thingDTO.UID);
        ThingTypeUID thingTypeUID = thingDTO.thingTypeUID == null ? new ThingTypeUID("") : new ThingTypeUID(thingDTO.thingTypeUID);
        Thing thing = isBridge ? BridgeBuilder.create(thingTypeUID, thingUID).build() : ThingBuilder.create(thingTypeUID, thingUID).build();
        return ThingHelper.merge(thing, thingDTO);
    }

    private static Map<String, Object> toMap(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        HashMap<String, Object> configurationMap = new HashMap<String, Object>(configuration.keySet().size());
        for (String key : configuration.keySet()) {
            configurationMap.put(key, configuration.get(key));
        }
        return configurationMap;
    }
}

