/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.i18n;

import java.util.Arrays;
import java.util.Locale;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.util.BundleResolver;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThingStatusInfoI18nLocalizationService.class})
public final class ThingStatusInfoI18nLocalizationService {
    private TranslationProvider i18nProvider;
    private BundleResolver bundleResolver;

    public ThingStatusInfo getLocalizedThingStatusInfo(Thing thing, Locale locale) {
        if (thing == null) {
            throw new IllegalArgumentException("Thing must not be null.");
        }
        ThingHandler thingHandler = thing.getHandler();
        if (thingHandler == null) {
            return thing.getStatusInfo();
        }
        String description = thing.getStatusInfo().getDescription();
        if (description == null || !I18nUtil.isConstant((String)description)) {
            return thing.getStatusInfo();
        }
        String translatedDescription = this.translateDescription(description, locale, thingHandler);
        return new ThingStatusInfo(thing.getStatus(), thing.getStatusInfo().getStatusDetail(), translatedDescription);
    }

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }

    @Reference
    public void setBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    protected void unsetBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    private String translateDescription(String description, Locale locale, ThingHandler thingHandler) {
        ParsedDescription parsedDescription = new ParsedDescription(description);
        A[] translatedArgs = null;
        if (parsedDescription.args != null) {
            translatedArgs = Arrays.stream(parsedDescription.args).map(arg -> {
                if (I18nUtil.isConstant((String)arg)) {
                    return this.getTranslationForClass((String)arg, locale, thingHandler.getClass(), new Object[0]);
                }
                return arg;
            }).toArray(String[]::new);
        }
        return this.getTranslationForClass(parsedDescription.key, locale, thingHandler.getClass(), translatedArgs);
    }

    private String getTranslationForClass(String i18nConstant, Locale locale, Class<?> clazz, Object ... args) {
        if (clazz == null) {
            return i18nConstant;
        }
        Bundle bundle = this.bundleResolver.resolveBundle(clazz);
        if (bundle == null) {
            return this.getTranslationForClass(i18nConstant, locale, clazz.getSuperclass(), args);
        }
        String translatedDescription = this.i18nProvider.getText(bundle, I18nUtil.stripConstant((String)i18nConstant), null, locale, args);
        if (translatedDescription != null) {
            return translatedDescription;
        }
        return this.getTranslationForClass(i18nConstant, locale, clazz.getSuperclass(), args);
    }

    private final class ParsedDescription {
        private static final int LIMIT = 2;
        private final String key;
        private final String[] args;

        private ParsedDescription(String description) {
            String[] parts = description.split("\\s+", 2);
            this.key = parts[0];
            this.args = parts.length == 1 ? null : (String[])Arrays.stream(parts[1].replaceAll("\\[|\\]|\"", "").split(",")).filter(s -> s != null && !s.trim().isEmpty()).map(s -> s.trim()).toArray(String[]::new);
        }
    }
}

