/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.validation.ConfigDescriptionValidator;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.service.ReadyMarker;
import org.eclipse.smarthome.core.service.ReadyMarkerFilter;
import org.eclipse.smarthome.core.service.ReadyService;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelGroupUID;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingManager;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingTypeMigrationService;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.binding.BridgeHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerCallback;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingStatusInfoBuilder;
import org.eclipse.smarthome.core.thing.events.ThingEventFactory;
import org.eclipse.smarthome.core.thing.i18n.ThingStatusInfoI18nLocalizationService;
import org.eclipse.smarthome.core.thing.internal.BridgeImpl;
import org.eclipse.smarthome.core.thing.internal.CommunicationManager;
import org.eclipse.smarthome.core.thing.internal.ThingFactoryHelper;
import org.eclipse.smarthome.core.thing.internal.ThingImpl;
import org.eclipse.smarthome.core.thing.internal.ThingRegistryImpl;
import org.eclipse.smarthome.core.thing.internal.ThingTracker;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.thing.util.ThingHandlerHelper;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.util.BundleResolver;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ThingTypeMigrationService.class, ThingManager.class})
public class ThingManagerImpl
implements ThingManager,
ThingTracker,
ThingTypeMigrationService,
ReadyService.ReadyTracker {
    static final String XML_THING_TYPE = "esh.xmlThingTypes";
    private static final String THING_STATUS_STORAGE_NAME = "thing_status_storage";
    private static final String FORCEREMOVE_THREADPOOL_NAME = "forceRemove";
    private static final String THING_MANAGER_THREADPOOL_NAME = "thingManager";
    private final Logger logger = LoggerFactory.getLogger(ThingManagerImpl.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"thingManager");
    private EventPublisher eventPublisher;
    private CommunicationManager communicationManager;
    private ReadyService readyService;
    private final List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();
    private final Map<ThingUID, ThingHandler> thingHandlers = new ConcurrentHashMap<ThingUID, ThingHandler>();
    private final Map<ThingHandlerFactory, Set<ThingHandler>> thingHandlersByFactory = new HashMap<ThingHandlerFactory, Set<ThingHandler>>();
    private ThingTypeRegistry thingTypeRegistry;
    private ChannelTypeRegistry channelTypeRegistry;
    private ChannelGroupTypeRegistry channelGroupTypeRegistry;
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService;
    private final Map<ThingUID, Lock> thingLocks = new HashMap<ThingUID, Lock>();
    private final Set<String> loadedXmlThingTypes = new CopyOnWriteArraySet<String>();
    private SafeCaller safeCaller;
    private volatile boolean active = false;
    private StorageService storageService;
    private Storage<String> storage;
    private final ThingHandlerCallback thingHandlerCallback = new ThingHandlerCallback(){

        @Override
        public void stateUpdated(ChannelUID channelUID, State state) {
            ThingManagerImpl.this.communicationManager.stateUpdated(channelUID, state);
        }

        @Override
        public void postCommand(ChannelUID channelUID, Command command) {
            ThingManagerImpl.this.communicationManager.postCommand(channelUID, command);
        }

        @Override
        public void channelTriggered(Thing thing, ChannelUID channelUID, String event) {
            ThingManagerImpl.this.communicationManager.channelTriggered(thing, channelUID, event);
        }

        @Override
        public void statusUpdated(Thing thing, ThingStatusInfo statusInfo) {
            ThingStatusInfo oldStatusInfo = thing.getStatusInfo();
            this.ensureValidStatus(oldStatusInfo.getStatus(), statusInfo.getStatus());
            if (ThingStatus.REMOVING.equals((Object)oldStatusInfo.getStatus()) && !ThingStatus.REMOVED.equals((Object)statusInfo.getStatus())) {
                throw new IllegalArgumentException(MessageFormat.format("Illegal status transition from REMOVING to {0}, only REMOVED would have been allowed.", new Object[]{statusInfo.getStatus()}));
            }
            ThingManagerImpl.this.setThingStatus(thing, statusInfo);
            if (ThingManagerImpl.this.isBridge(thing)) {
                this.handleBridgeStatusUpdate((Bridge)thing, statusInfo, oldStatusInfo);
            }
            if (ThingManagerImpl.this.hasBridge(thing)) {
                this.handleBridgeChildStatusUpdate(thing, oldStatusInfo);
            }
            if (ThingStatus.REMOVED.equals((Object)thing.getStatus())) {
                ThingManagerImpl.this.notifyRegistryAboutForceRemove(thing);
            }
        }

        private void ensureValidStatus(ThingStatus oldStatus, ThingStatus newStatus) {
            if (!(ThingStatus.UNKNOWN.equals((Object)newStatus) || ThingStatus.ONLINE.equals((Object)newStatus) || ThingStatus.OFFLINE.equals((Object)newStatus) || ThingStatus.REMOVED.equals((Object)newStatus))) {
                throw new IllegalArgumentException(MessageFormat.format("Illegal status {0}. Bindings only may set {1}, {2}, {3} or {4}.", new Object[]{newStatus, ThingStatus.UNKNOWN, ThingStatus.ONLINE, ThingStatus.OFFLINE, ThingStatus.REMOVED}));
            }
            if (ThingStatus.REMOVED.equals((Object)newStatus) && !ThingStatus.REMOVING.equals((Object)oldStatus)) {
                throw new IllegalArgumentException(MessageFormat.format("Illegal status {0}. The thing was in state {1} and not in {2}", new Object[]{newStatus, oldStatus, ThingStatus.REMOVING}));
            }
        }

        private void handleBridgeStatusUpdate(Bridge bridge, ThingStatusInfo statusInfo, ThingStatusInfo oldStatusInfo) {
            if (ThingHandlerHelper.isHandlerInitialized(bridge) && ThingStatus.INITIALIZING.equals((Object)oldStatusInfo.getStatus())) {
                ThingManagerImpl.this.registerChildHandlers(bridge);
            } else if (!statusInfo.equals(oldStatusInfo)) {
                ThingManagerImpl.this.notifyThingsAboutBridgeStatusChange(bridge, statusInfo);
            }
        }

        private void handleBridgeChildStatusUpdate(Thing thing, ThingStatusInfo oldStatusInfo) {
            if (ThingHandlerHelper.isHandlerInitialized(thing) && ThingStatus.INITIALIZING.equals((Object)oldStatusInfo.getStatus())) {
                ThingManagerImpl.this.notifyBridgeAboutChildHandlerInitialization(thing);
            }
        }

        @Override
        public void thingUpdated(final Thing thing) {
            ThingManagerImpl.this.thingUpdatedLock.add(thing.getUID());
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Provider provider = ThingManagerImpl.this.thingRegistry.getProvider(thing);
                    if (provider == null) {
                        throw new IllegalArgumentException(MessageFormat.format("Provider for thing {0} cannot be determined because it is not known to the registry", thing.getUID().getAsString()));
                    }
                    if (provider instanceof ManagedProvider) {
                        ManagedProvider managedProvider = (ManagedProvider)provider;
                        managedProvider.update((Identifiable)thing);
                    } else {
                        ThingManagerImpl.this.logger.debug("Only updating thing {} in the registry because provider {} is not managed.", (Object)thing.getUID().getAsString(), (Object)provider);
                        ThingManagerImpl.this.thingRegistry.updated(provider, (Thing)ThingManagerImpl.this.thingRegistry.get((Object)thing.getUID()), thing);
                    }
                    return null;
                }
            });
            ThingManagerImpl.this.thingUpdatedLock.remove((Object)thing.getUID());
        }

        @Override
        public void validateConfigurationParameters(Thing thing, Map<String, Object> configurationParameters) {
            ThingType thingType = ThingManagerImpl.this.thingTypeRegistry.getThingType(thing.getThingTypeUID());
            if (thingType != null && thingType.getConfigDescriptionURI() != null) {
                ThingManagerImpl.this.configDescriptionValidator.validate(configurationParameters, thingType.getConfigDescriptionURI());
            }
        }

        @Override
        public void configurationUpdated(Thing thing) {
            if (!ThingHandlerHelper.isHandlerInitialized(thing)) {
                ThingManagerImpl.this.initializeHandler(thing);
            }
        }

        @Override
        public void migrateThingType(Thing thing, ThingTypeUID thingTypeUID, Configuration configuration) {
            ThingManagerImpl.this.migrateThingType(thing, thingTypeUID, configuration);
        }

        @Override
        public ChannelBuilder createChannelBuilder(ChannelUID channelUID, ChannelTypeUID channelTypeUID) {
            ChannelType channelType = ThingManagerImpl.this.channelTypeRegistry.getChannelType(channelTypeUID);
            if (channelType == null) {
                throw new IllegalArgumentException(String.format("Channel type '%s' is not known", new Object[]{channelTypeUID}));
            }
            return ThingFactoryHelper.createChannelBuilder(channelUID, channelType, ThingManagerImpl.this.configDescriptionRegistry);
        }

        @Override
        public ChannelBuilder editChannel(Thing thing, ChannelUID channelUID) {
            Channel channel = thing.getChannel(channelUID.getId());
            if (channel == null) {
                throw new IllegalArgumentException(String.format("Channel '%s' does not exist for thing '%s'", new Object[]{channelUID, thing.getUID()}));
            }
            return ChannelBuilder.create(channel);
        }

        @Override
        public List<ChannelBuilder> createChannelBuilders(ChannelGroupUID channelGroupUID, ChannelGroupTypeUID channelGroupTypeUID) {
            ChannelGroupType channelGroupType = ThingManagerImpl.this.channelGroupTypeRegistry.getChannelGroupType(channelGroupTypeUID);
            if (channelGroupType == null) {
                throw new IllegalArgumentException(String.format("Channel group type '%s' is not known", new Object[]{channelGroupTypeUID}));
            }
            ArrayList<ChannelBuilder> channelBuilders = new ArrayList<ChannelBuilder>();
            for (ChannelDefinition channelDefinition : channelGroupType.getChannelDefinitions()) {
                ChannelType channelType = ThingManagerImpl.this.channelTypeRegistry.getChannelType(channelDefinition.getChannelTypeUID());
                if (channelType == null) continue;
                ChannelUID channelUID = new ChannelUID(channelGroupUID, channelDefinition.getId());
                channelBuilders.add(ThingFactoryHelper.createChannelBuilder(channelUID, channelType, ThingManagerImpl.this.configDescriptionRegistry));
            }
            return channelBuilders;
        }

        @Override
        public boolean isChannelLinked(ChannelUID channelUID) {
            return ThingManagerImpl.this.itemChannelLinkRegistry.isLinked(channelUID);
        }
    };
    private ThingRegistryImpl thingRegistry;
    private BundleResolver bundleResolver;
    private ConfigDescriptionRegistry configDescriptionRegistry;
    private ConfigDescriptionValidator configDescriptionValidator;
    private final Set<Thing> things = new CopyOnWriteArraySet<Thing>();
    private final Set<ThingUID> registerHandlerLock = new HashSet<ThingUID>();
    private final Set<ThingUID> thingUpdatedLock = new HashSet<ThingUID>();

    @Override
    public void migrateThingType(final Thing thing, final ThingTypeUID thingTypeUID, final Configuration configuration) {
        final ThingType thingType = this.thingTypeRegistry.getThingType(thingTypeUID);
        if (thingType == null) {
            throw new IllegalStateException(MessageFormat.format("No thing type {0}\u00a0registered, cannot change thing type for thing {1}", thingTypeUID.getAsString(), thing.getUID().getAsString()));
        }
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                Lock lock = ThingManagerImpl.this.getLockForThing(thing.getUID());
                try {
                    lock.lock();
                    ThingUID thingUID = thing.getUID();
                    this.waitForRunningHandlerRegistrations(thingUID);
                    ThingHandlerFactory oldThingHandlerFactory = ThingManagerImpl.this.findThingHandlerFactory(thing.getThingTypeUID());
                    if (oldThingHandlerFactory != null) {
                        ThingHandler thingHandler = thing.getHandler();
                        ThingManagerImpl.this.unregisterAndDisposeHandler(oldThingHandlerFactory, thing, thingHandler);
                        this.waitUntilHandlerUnregistered(thing, 60000);
                    } else {
                        ThingManagerImpl.this.logger.debug("No ThingHandlerFactory available that can handle {}", (Object)thing.getThingTypeUID());
                    }
                    List<Channel> channels = ThingFactoryHelper.createChannels(thingType, thingUID, ThingManagerImpl.this.configDescriptionRegistry);
                    ((ThingImpl)thing).setChannels(channels);
                    ThingFactoryHelper.applyDefaultConfiguration(configuration, thingType, ThingManagerImpl.this.configDescriptionRegistry);
                    ((ThingImpl)thing).setConfiguration(configuration);
                    for (Map.Entry<String, String> entry : thingType.getProperties().entrySet()) {
                        ((ThingImpl)thing).setProperty(entry.getKey(), entry.getValue());
                    }
                    ((ThingImpl)thing).setThingTypeUID(thingTypeUID);
                    ThingManagerImpl.this.thingRegistry.update(thing);
                    ThingHandler handler = thing.getHandler();
                    String handlerString = "NO HANDLER";
                    if (handler != null) {
                        handlerString = handler.toString();
                    }
                    ThingManagerImpl.this.logger.debug("Changed ThingType of Thing {} to {}. New ThingHandler is {}.", new Object[]{thing.getUID().toString(), thing.getThingTypeUID(), handlerString});
                }
                finally {
                    lock.unlock();
                }
            }

            private void waitUntilHandlerUnregistered(Thing thing2, int timeout) {
                int i = 0;
                while (i < timeout / 100) {
                    if (thing2.getHandler() == null && ThingManagerImpl.this.thingHandlers.get((Object)thing2.getUID()) == null) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                        ThingManagerImpl.this.logger.debug("Waiting for handler deregistration to complete for thing {}. Took already {}ms.", (Object)thing2.getUID().getAsString(), (Object)((i + 1) * 100));
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    ++i;
                }
                String message = MessageFormat.format("Thing type migration failed for {0}. The handler deregistration did not complete within {1}ms.", thing2.getUID().getAsString(), timeout);
                ThingManagerImpl.this.logger.error(message);
                throw new IllegalStateException(message);
            }

            private void waitForRunningHandlerRegistrations(ThingUID thingUID) {
                int i = 0;
                while (i < 100) {
                    if (!ThingManagerImpl.this.registerHandlerLock.contains((Object)thingUID)) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    ++i;
                }
                String message = MessageFormat.format("Thing type migration failed for {0}. Could not obtain lock for hander registration.", thingUID.getAsString());
                ThingManagerImpl.this.logger.error(message);
                throw new IllegalStateException(message);
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void thingAdded(Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        this.things.add(thing);
        this.logger.debug("Thing '{}' is tracked by ThingManager.", (Object)thing.getUID());
        if (!this.isHandlerRegistered(thing)) {
            this.registerAndInitializeHandler(thing, this.getThingHandlerFactory(thing));
        } else {
            this.logger.debug("Handler of tracked thing '{}' already registered.", (Object)thing.getUID());
        }
    }

    @Override
    public void thingRemoving(Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        this.setThingStatus(thing, ThingStatusInfoBuilder.create(ThingStatus.REMOVING).build());
        this.notifyThingHandlerAboutRemoval(thing);
    }

    @Override
    public void thingRemoved(Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        this.logger.debug("Thing '{}' is no longer tracked by ThingManager.", (Object)thing.getUID());
        ThingHandler thingHandler = this.thingHandlers.get((Object)thing.getUID());
        if (thingHandler != null) {
            ThingHandlerFactory thingHandlerFactory = this.findThingHandlerFactory(thing.getThingTypeUID());
            if (thingHandlerFactory != null) {
                this.unregisterAndDisposeHandler(thingHandlerFactory, thing, thingHandler);
                if (thingTrackerEvent == ThingTracker.ThingTrackerEvent.THING_REMOVED) {
                    ((ThingHandlerFactory)this.safeCaller.create((Object)thingHandlerFactory, ThingHandlerFactory.class).build()).removeThing(thing.getUID());
                }
            } else {
                this.logger.warn("Cannot unregister handler. No handler factory for thing '{}' found.", (Object)thing.getUID());
            }
        }
        this.storage.remove(thing.getUID().getAsString());
        this.things.remove(thing);
    }

    @Override
    public void thingUpdated(Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        ThingUID thingUID = thing.getUID();
        if (this.thingUpdatedLock.contains((Object)thingUID)) {
            this.replaceThing(this.getThing(thingUID), thing);
        } else {
            Lock lock1 = this.getLockForThing(thing.getUID());
            try {
                lock1.lock();
                Thing oldThing = this.getThing(thingUID);
                ThingHandler thingHandler = this.replaceThing(oldThing, thing);
                if (thingHandler != null) {
                    if (ThingHandlerHelper.isHandlerInitialized(thing) || this.isInitializing(thing)) {
                        if (oldThing != null) {
                            oldThing.setHandler(null);
                        }
                        thing.setHandler(thingHandler);
                        ((ThingHandler)this.safeCaller.create((Object)thingHandler, ThingHandler.class).build()).thingUpdated(thing);
                    } else {
                        this.logger.debug("Cannot notify handler about updated thing '{}', because handler is not initialized (thing must be in status UNKNOWN, ONLINE or OFFLINE).", (Object)thing.getThingTypeUID());
                        if (thingHandler.getThing() == thing) {
                            this.logger.debug("Initializing handler of thing '{}'", (Object)thing.getThingTypeUID());
                            if (oldThing != null) {
                                oldThing.setHandler(null);
                            }
                            thing.setHandler(thingHandler);
                            this.initializeHandler(thing);
                        } else {
                            this.logger.debug("Replacing uninitialized handler for updated thing '{}'", (Object)thing.getThingTypeUID());
                            ThingHandlerFactory thingHandlerFactory = this.getThingHandlerFactory(thing);
                            this.unregisterHandler(thingHandler.getThing(), thingHandlerFactory);
                            this.registerAndInitializeHandler(thing, thingHandlerFactory);
                        }
                    }
                } else {
                    this.registerAndInitializeHandler(thing, this.getThingHandlerFactory(thing));
                }
            }
            finally {
                lock1.unlock();
            }
        }
    }

    private ThingHandler replaceThing(Thing oldThing, Thing newThing) {
        ThingHandler thingHandler = this.thingHandlers.get((Object)newThing.getUID());
        if (oldThing != newThing) {
            this.things.remove(oldThing);
            this.things.add(newThing);
        }
        return thingHandler;
    }

    private Thing getThing(ThingUID id) {
        for (Thing thing : this.things) {
            if (!thing.getUID().equals((Object)id)) continue;
            return thing;
        }
        return null;
    }

    private ThingType getThingType(Thing thing) {
        return this.thingTypeRegistry.getThingType(thing.getThingTypeUID());
    }

    private ThingHandlerFactory findThingHandlerFactory(ThingTypeUID thingTypeUID) {
        for (ThingHandlerFactory factory : this.thingHandlerFactories) {
            if (!factory.supportsThingType(thingTypeUID)) continue;
            return factory;
        }
        return null;
    }

    private void registerHandler(Thing thing, ThingHandlerFactory thingHandlerFactory) {
        Lock lock = this.getLockForThing(thing.getUID());
        try {
            lock.lock();
            if (!this.isHandlerRegistered(thing)) {
                if (!this.hasBridge(thing)) {
                    this.doRegisterHandler(thing, thingHandlerFactory);
                } else {
                    Bridge bridge = this.getBridge(thing.getBridgeUID());
                    if (bridge != null && ThingHandlerHelper.isHandlerInitialized(bridge)) {
                        this.doRegisterHandler(thing, thingHandlerFactory);
                    } else {
                        this.setThingStatus(thing, this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.BRIDGE_UNINITIALIZED));
                    }
                }
            } else {
                this.logger.debug("Attempt to register a handler twice for thing {} at the same time will be ignored.", (Object)thing.getUID());
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegisterHandler(Thing thing, ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Calling '{}.registerHandler()' for thing '{}'.", (Object)thingHandlerFactory.getClass().getSimpleName(), (Object)thing.getUID());
        try {
            ThingHandler thingHandler = thingHandlerFactory.registerHandler(thing);
            thingHandler.setCallback(this.thingHandlerCallback);
            thing.setHandler(thingHandler);
            this.thingHandlers.put(thing.getUID(), thingHandler);
            Map<ThingHandlerFactory, Set<ThingHandler>> map = this.thingHandlersByFactory;
            synchronized (map) {
                this.thingHandlersByFactory.computeIfAbsent(thingHandlerFactory, unused -> new HashSet()).add(thingHandler);
            }
        }
        catch (Exception ex) {
            ThingStatusInfo statusInfo = this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.HANDLER_REGISTERING_ERROR, ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
            this.setThingStatus(thing, statusInfo);
            this.logger.error("Exception occurred while calling thing handler factory '{}': {}", new Object[]{thingHandlerFactory, ex.getMessage(), ex});
        }
    }

    private void registerChildHandlers(final Bridge bridge) {
        for (final Thing child : bridge.getThings()) {
            this.logger.debug("Register and initialize child '{}' of bridge '{}'.", (Object)child.getUID(), (Object)bridge.getUID());
            ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ThingManagerImpl.this.registerAndInitializeHandler(child, ThingManagerImpl.this.getThingHandlerFactory(child));
                    }
                    catch (Exception ex) {
                        ThingManagerImpl.this.logger.error("Registration resp. initialization of child '{}' of bridge '{}' has been failed: {}", new Object[]{child.getUID(), bridge.getUID(), ex.getMessage(), ex});
                    }
                }
            });
        }
    }

    private void initializeHandler(Thing thing) {
        if (this.isDisabledByStorage(thing.getUID())) {
            this.setThingStatus(thing, this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.DISABLED));
            this.logger.debug("Thing '{}' will not be initialized. It is marked as disabled.", (Object)thing.getUID());
            return;
        }
        if (!this.isHandlerRegistered(thing)) {
            return;
        }
        Lock lock = this.getLockForThing(thing.getUID());
        try {
            lock.lock();
            if (ThingHandlerHelper.isHandlerInitialized(thing)) {
                this.logger.debug("Attempt to initialize the already initialized thing '{}' will be ignored.", (Object)thing.getUID());
                return;
            }
            if (this.isInitializing(thing)) {
                this.logger.debug("Attempt to initialize a handler twice for thing '{}' at the same time will be ignored.", (Object)thing.getUID());
                return;
            }
            ThingHandler handler = thing.getHandler();
            if (handler == null) {
                throw new IllegalStateException("Handler should not be null here");
            }
            if (handler.getThing() != thing) {
                this.logger.warn("The model of {} is inconsistent [thing.getHandler().getThing() != thing]", (Object)thing.getUID());
            }
            ThingType thingType = this.getThingType(thing);
            this.applyDefaultConfiguration(thing, thingType);
            if (this.isInitializable(thing, thingType)) {
                this.setThingStatus(thing, this.buildStatusInfo(ThingStatus.INITIALIZING, ThingStatusDetail.NONE));
                this.doInitializeHandler(thing.getHandler());
            } else {
                this.logger.debug("Thing '{}' not initializable, check required configuration parameters.", (Object)thing.getUID());
                this.setThingStatus(thing, this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.HANDLER_CONFIGURATION_PENDING));
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void applyDefaultConfiguration(Thing thing, ThingType thingType) {
        if (thingType != null) {
            ThingFactoryHelper.applyDefaultConfiguration(thing.getConfiguration(), thingType, this.configDescriptionRegistry);
        }
    }

    private boolean isInitializable(Thing thing, ThingType thingType) {
        if (!this.isComplete(thingType, thing.getUID(), tt -> tt.getConfigDescriptionURI(), thing.getConfiguration())) {
            return false;
        }
        for (Channel channel : thing.getChannels()) {
            ChannelType channelType = this.channelTypeRegistry.getChannelType(channel.getChannelTypeUID());
            if (this.isComplete(channelType, channel.getUID(), ct -> ct.getConfigDescriptionURI(), channel.getConfiguration())) continue;
            return false;
        }
        return true;
    }

    private <T extends Identifiable<?>> boolean isComplete(T prototype, UID targetUID, Function<T, URI> configDescriptionURIFunction, Configuration configuration) {
        if (prototype == null) {
            this.logger.debug("Prototype for '{}' is not known, assuming it is initializable", (Object)targetUID);
            return true;
        }
        ConfigDescription description = this.resolve(configDescriptionURIFunction.apply(prototype), null);
        if (description == null) {
            this.logger.debug("Config description for '{}' is not resolvable, assuming '{}' is initializable", prototype.getUID(), (Object)targetUID);
            return true;
        }
        List<String> requiredParameters = this.getRequiredParameters(description);
        Set propertyKeys = configuration.getProperties().keySet();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configuration of '{}' needs {}, has {}.", new Object[]{targetUID, requiredParameters, propertyKeys});
        }
        return propertyKeys.containsAll(requiredParameters);
    }

    private ConfigDescription resolve(URI configDescriptionURI, Locale locale) {
        if (configDescriptionURI == null) {
            return null;
        }
        return this.configDescriptionRegistry != null ? this.configDescriptionRegistry.getConfigDescription(configDescriptionURI, locale) : null;
    }

    private List<String> getRequiredParameters(ConfigDescription description) {
        ArrayList<String> requiredParameters = new ArrayList<String>();
        for (ConfigDescriptionParameter param : description.getParameters()) {
            if (!param.isRequired()) continue;
            requiredParameters.add(param.getName());
        }
        return requiredParameters;
    }

    private void doInitializeHandler(ThingHandler thingHandler) {
        this.logger.debug("Calling initialize handler for thing '{}' at '{}'.", (Object)thingHandler.getThing().getUID(), (Object)thingHandler);
        ((ThingHandler)this.safeCaller.create((Object)thingHandler, ThingHandler.class).onTimeout(() -> this.logger.warn("Initializing handler for thing '{}' takes more than {}ms.", (Object)thingHandler.getThing().getUID(), (Object)SafeCaller.DEFAULT_TIMEOUT)).onException(e -> {
            ThingStatusInfo statusInfo = this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.HANDLER_INITIALIZING_ERROR, e.getMessage());
            this.setThingStatus(thingHandler.getThing(), statusInfo);
            this.logger.error("Exception occurred while initializing handler of thing '{}': {}", new Object[]{thingHandler.getThing().getUID(), e.getMessage(), e});
        }).build()).initialize();
    }

    private boolean isInitializing(Thing thing) {
        return thing.getStatus() == ThingStatus.INITIALIZING;
    }

    private boolean isHandlerRegistered(Thing thing) {
        ThingHandler handler = this.thingHandlers.get((Object)thing.getUID());
        return handler != null && handler == thing.getHandler();
    }

    private boolean isBridge(Thing thing) {
        return thing instanceof Bridge;
    }

    private boolean hasBridge(Thing thing) {
        return thing.getBridgeUID() != null;
    }

    private Bridge getBridge(ThingUID bridgeUID) {
        Thing bridge = (Thing)this.thingRegistry.get((Object)bridgeUID);
        return this.isBridge(bridge) ? (Bridge)bridge : null;
    }

    private void unregisterHandler(Thing thing, ThingHandlerFactory thingHandlerFactory) {
        Lock lock = this.getLockForThing(thing.getUID());
        try {
            lock.lock();
            if (this.isHandlerRegistered(thing)) {
                this.doUnregisterHandler(thing, thingHandlerFactory);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void doUnregisterHandler(Thing thing, ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Calling unregisterHandler handler for thing '{}' at '{}'.", (Object)thing.getUID(), (Object)thingHandlerFactory);
        ((Runnable)this.safeCaller.create(() -> {
            ThingHandler thingHandler = thing.getHandler();
            thingHandlerFactory.unregisterHandler(thing);
            if (thingHandler != null) {
                thingHandler.setCallback(null);
            }
            thing.setHandler(null);
            boolean enabled = !this.isDisabledByStorage(thing.getUID());
            ThingStatusDetail detail = enabled ? ThingStatusDetail.HANDLER_MISSING_ERROR : ThingStatusDetail.DISABLED;
            this.setThingStatus(thing, this.buildStatusInfo(ThingStatus.UNINITIALIZED, detail));
            this.thingHandlers.remove((Object)thing.getUID());
            Map<ThingHandlerFactory, Set<ThingHandler>> map = this.thingHandlersByFactory;
            synchronized (map) {
                Set<ThingHandler> thingHandlers = this.thingHandlersByFactory.get(thingHandlerFactory);
                if (thingHandlers != null) {
                    thingHandlers.remove(thingHandler);
                    if (thingHandlers.isEmpty()) {
                        this.thingHandlersByFactory.remove(thingHandlerFactory);
                    }
                }
            }
        }, Runnable.class).build()).run();
    }

    private void disposeHandler(Thing thing, ThingHandler thingHandler) {
        Lock lock = this.getLockForThing(thing.getUID());
        try {
            lock.lock();
            this.doDisposeHandler(thingHandler);
            if (this.hasBridge(thing)) {
                this.notifyBridgeAboutChildHandlerDisposal(thing, thingHandler);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void doDisposeHandler(ThingHandler thingHandler) {
        this.logger.debug("Calling dispose handler for thing '{}' at '{}'.", (Object)thingHandler.getThing().getUID(), (Object)thingHandler);
        this.setThingStatus(thingHandler.getThing(), this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.NONE));
        ((ThingHandler)this.safeCaller.create((Object)thingHandler, ThingHandler.class).onTimeout(() -> this.logger.warn("Disposing handler for thing '{}' takes more than {}ms.", (Object)thingHandler.getThing().getUID(), (Object)SafeCaller.DEFAULT_TIMEOUT)).onException(e -> this.logger.error("Exception occurred while disposing handler of thing '{}': {}", new Object[]{thingHandler.getThing().getUID(), e.getMessage(), e})).build()).dispose();
    }

    private void unregisterAndDisposeChildHandlers(Bridge bridge, ThingHandlerFactory thingHandlerFactory) {
        this.addThingsToBridge(bridge);
        for (Thing child : bridge.getThings()) {
            ThingHandler handler = child.getHandler();
            if (handler == null) continue;
            this.logger.debug("Unregister and dispose child '{}' of bridge '{}'.", (Object)child.getUID(), (Object)bridge.getUID());
            this.unregisterAndDisposeHandler(thingHandlerFactory, child, handler);
        }
    }

    private void unregisterAndDisposeHandler(ThingHandlerFactory thingHandlerFactory, Thing thing, ThingHandler handler) {
        if (this.isBridge(thing)) {
            this.unregisterAndDisposeChildHandlers((Bridge)thing, thingHandlerFactory);
        }
        this.disposeHandler(thing, handler);
        this.unregisterHandler(thing, thingHandlerFactory);
    }

    private void addThingsToBridge(Bridge bridge) {
        Collection things = this.thingRegistry.getAll();
        for (Thing thing : things) {
            ThingUID bridgeUID = thing.getBridgeUID();
            if (bridgeUID == null || !bridgeUID.equals((Object)bridge.getUID()) || !(bridge instanceof BridgeImpl) || bridge.getThings().contains(thing)) continue;
            ((BridgeImpl)bridge).addThing(thing);
        }
    }

    private void notifyThingsAboutBridgeStatusChange(Bridge bridge, final ThingStatusInfo bridgeStatus) {
        if (ThingHandlerHelper.isHandlerInitialized(bridge)) {
            for (final Thing child : bridge.getThings()) {
                ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ThingHandler handler = child.getHandler();
                            if (handler != null && ThingHandlerHelper.isHandlerInitialized(child)) {
                                handler.bridgeStatusChanged(bridgeStatus);
                            }
                        }
                        catch (Exception e) {
                            ThingManagerImpl.this.logger.error("Exception occurred during notification about bridge status change on thing '{}': {}", new Object[]{child.getUID(), e.getMessage(), e});
                        }
                    }
                });
            }
        }
    }

    private void notifyBridgeAboutChildHandlerInitialization(final Thing thing) {
        final Bridge bridge = this.getBridge(thing.getBridgeUID());
        if (bridge != null) {
            ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ThingHandler thingHandler;
                        BridgeHandler bridgeHandler = bridge.getHandler();
                        if (bridgeHandler != null && (thingHandler = thing.getHandler()) != null) {
                            bridgeHandler.childHandlerInitialized(thingHandler, thing);
                        }
                    }
                    catch (Exception e) {
                        ThingManagerImpl.this.logger.error("Exception occurred during bridge handler ('{}') notification about handler initialization of child '{}': {}", new Object[]{bridge.getUID(), thing.getUID(), e.getMessage(), e});
                    }
                }
            });
        }
    }

    private void notifyBridgeAboutChildHandlerDisposal(final Thing thing, final ThingHandler thingHandler) {
        final Bridge bridge = this.getBridge(thing.getBridgeUID());
        if (bridge != null) {
            ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BridgeHandler bridgeHandler = bridge.getHandler();
                        if (bridgeHandler != null) {
                            bridgeHandler.childHandlerDisposed(thingHandler, thing);
                        }
                    }
                    catch (Exception ex) {
                        ThingManagerImpl.this.logger.error("Exception occurred during bridge handler ('{}') notification about handler disposal of child '{}': {}", new Object[]{bridge.getUID(), thing.getUID(), ex.getMessage(), ex});
                    }
                }
            });
        }
    }

    private void notifyThingHandlerAboutRemoval(final Thing thing) {
        this.logger.trace("Asking handler of thing '{}' to handle its removal.", (Object)thing.getUID());
        ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ThingHandler handler = thing.getHandler();
                    if (handler != null) {
                        handler.handleRemoval();
                        ThingManagerImpl.this.logger.trace("Handler of thing '{}' returned from handling its removal.", (Object)thing.getUID());
                    } else {
                        ThingManagerImpl.this.logger.trace("No handler of thing '{}' available, so deferring the removal call.", (Object)thing.getUID());
                    }
                }
                catch (Exception ex) {
                    ThingManagerImpl.this.logger.error("The ThingHandler caused an exception while handling the removal of its thing", (Throwable)ex);
                }
            }
        });
    }

    private void notifyRegistryAboutForceRemove(final Thing thing) {
        this.logger.debug("Removal handling of thing '{}' completed. Going to remove it now.", (Object)thing.getUID());
        ThreadPoolManager.getPool((String)FORCEREMOVE_THREADPOOL_NAME).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            ThingManagerImpl.this.thingRegistry.forceRemove(thing.getUID());
                            return null;
                        }
                    });
                }
                catch (IllegalStateException ex) {
                    ThingManagerImpl.this.logger.debug("Could not remove thing {}. Most likely because it is not managed.", (Object)thing.getUID(), (Object)ex);
                }
                catch (Exception ex) {
                    ThingManagerImpl.this.logger.error("Could not remove thing {}, because an unknwon Exception occurred. Most likely because it is not managed.", (Object)thing.getUID(), (Object)ex);
                }
            }
        });
    }

    @Activate
    protected synchronized void activate(ComponentContext componentContext) {
        this.readyService.registerTracker((ReadyService.ReadyTracker)this, new ReadyMarkerFilter().withType(XML_THING_TYPE));
        for (ThingHandlerFactory factory : this.thingHandlerFactories) {
            this.handleThingHandlerFactoryAddition(this.getBundleName(factory));
        }
        this.thingRegistry.addThingTracker(this);
        this.active = true;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Thing handler factory '{}' added", (Object)thingHandlerFactory.getClass().getSimpleName());
        this.thingHandlerFactories.add(thingHandlerFactory);
        if (this.active) {
            this.handleThingHandlerFactoryAddition(this.getBundleName(thingHandlerFactory));
        }
    }

    @Reference
    public void setReadyService(ReadyService readyService) {
        this.readyService = readyService;
    }

    public void unsetReadyService(ReadyService readyService) {
        this.readyService = null;
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        String bsn = readyMarker.getIdentifier();
        this.loadedXmlThingTypes.add(bsn);
        this.handleThingHandlerFactoryAddition(bsn);
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        String bsn = readyMarker.getIdentifier();
        this.loadedXmlThingTypes.remove(bsn);
    }

    private void handleThingHandlerFactoryAddition(String bsn) {
        this.thingHandlerFactories.stream().filter(it -> this.getBundleName((ThingHandlerFactory)it).equals(bsn)).forEach(thingHandlerFactory -> this.things.forEach(thing -> {
            if (thingHandlerFactory.supportsThingType(thing.getThingTypeUID())) {
                if (!this.isHandlerRegistered((Thing)thing)) {
                    this.registerAndInitializeHandler((Thing)thing, (ThingHandlerFactory)thingHandlerFactory);
                } else {
                    this.logger.debug("Thing handler for thing '{}' already registered", (Object)thing.getUID());
                }
            }
        }));
    }

    private String getBundleName(ThingHandlerFactory thingHandlerFactory) {
        return this.bundleResolver.resolveBundle(thingHandlerFactory.getClass()).getSymbolicName();
    }

    private void registerAndInitializeHandler(Thing thing, ThingHandlerFactory thingHandlerFactory) {
        if (thingHandlerFactory != null) {
            String bsn = this.getBundleName(thingHandlerFactory);
            if (this.loadedXmlThingTypes.contains(bsn)) {
                this.registerHandler(thing, thingHandlerFactory);
                this.initializeHandler(thing);
            } else {
                this.logger.debug("Not registering a handler at this point. The thing types of bundle {} are not fully loaded yet.", (Object)bsn);
            }
        } else {
            this.logger.debug("Not registering a handler at this point. No handler factory for thing '{}' found.", (Object)thing.getUID());
        }
    }

    private ThingHandlerFactory getThingHandlerFactory(Thing thing) {
        ThingHandlerFactory thingHandlerFactory = this.findThingHandlerFactory(thing.getThingTypeUID());
        if (thingHandlerFactory != null) {
            return thingHandlerFactory;
        }
        this.logger.debug("Not registering a handler at this point since no handler factory for thing '{}' found.", (Object)thing.getUID());
        return null;
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext componentContext) {
        this.active = false;
        this.thingRegistry.removeThingTracker(this);
        for (ThingHandlerFactory factory : this.thingHandlerFactories) {
            this.removeThingHandlerFactory(factory);
        }
        this.readyService.unregisterTracker((ReadyService.ReadyTracker)this);
    }

    protected synchronized void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Thing handler factory '{}' removed", (Object)thingHandlerFactory.getClass().getSimpleName());
        this.thingHandlerFactories.remove(thingHandlerFactory);
        if (this.active) {
            this.handleThingHandlerFactoryRemoval(thingHandlerFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleThingHandlerFactoryRemoval(ThingHandlerFactory thingHandlerFactory) {
        Set<ThingHandler> handlers;
        Map<ThingHandlerFactory, Set<ThingHandler>> map = this.thingHandlersByFactory;
        synchronized (map) {
            handlers = this.thingHandlersByFactory.remove(thingHandlerFactory);
        }
        if (handlers != null) {
            for (ThingHandler thingHandler : handlers) {
                Thing thing = thingHandler.getThing();
                if (!this.isHandlerRegistered(thing)) continue;
                this.unregisterAndDisposeHandler(thingHandlerFactory, thing, thingHandler);
            }
        }
    }

    private synchronized Lock getLockForThing(ThingUID thingUID) {
        if (this.thingLocks.get((Object)thingUID) == null) {
            ReentrantLock lock = new ReentrantLock();
            this.thingLocks.put(thingUID, lock);
        }
        return this.thingLocks.get((Object)thingUID);
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = (ThingRegistryImpl)thingRegistry;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    @Reference
    protected void setConfigDescriptionValidator(ConfigDescriptionValidator configDescriptionValidator) {
        this.configDescriptionValidator = configDescriptionValidator;
    }

    protected void unsetConfigDescriptionValidator(ConfigDescriptionValidator configDescriptionValidator) {
        this.configDescriptionValidator = null;
    }

    @Reference
    protected void setBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    protected void unsetBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    private ThingStatusInfo buildStatusInfo(ThingStatus thingStatus, ThingStatusDetail thingStatusDetail, String description) {
        ThingStatusInfoBuilder statusInfoBuilder = ThingStatusInfoBuilder.create(thingStatus, thingStatusDetail);
        statusInfoBuilder.withDescription(description);
        return statusInfoBuilder.build();
    }

    private ThingStatusInfo buildStatusInfo(ThingStatus thingStatus, ThingStatusDetail thingStatusDetail) {
        return this.buildStatusInfo(thingStatus, thingStatusDetail, null);
    }

    private void setThingStatus(Thing thing, ThingStatusInfo thingStatusInfo) {
        ThingStatusInfo oldStatusInfo = this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, null);
        thing.setStatusInfo(thingStatusInfo);
        ThingStatusInfo newStatusInfo = this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, null);
        try {
            this.eventPublisher.post((Event)ThingEventFactory.createStatusInfoEvent(thing.getUID(), newStatusInfo));
            if (!oldStatusInfo.equals(newStatusInfo)) {
                this.eventPublisher.post((Event)ThingEventFactory.createStatusInfoChangedEvent(thing.getUID(), newStatusInfo, oldStatusInfo));
            }
        }
        catch (Exception ex) {
            this.logger.error("Could not post 'ThingStatusInfoEvent' event: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    @Override
    public void setEnabled(ThingUID thingUID, boolean enabled) {
        Thing thing = this.getThing(thingUID);
        this.persistThingEnableStatus(thingUID, enabled);
        if (thing == null) {
            this.logger.debug("Thing with the UID {} is unknown, cannot set its enabled status.", (Object)thingUID);
            return;
        }
        if (enabled) {
            if (thing.getStatus().equals((Object)ThingStatus.ONLINE)) {
                this.logger.debug("Thing {} is already in the required state.", (Object)thingUID);
                return;
            }
            this.logger.debug("Thing {} will be enabled.", (Object)thingUID);
            if (this.isHandlerRegistered(thing)) {
                this.initializeHandler(thing);
            } else {
                this.registerAndInitializeHandler(thing, this.findThingHandlerFactory(thing.getThingTypeUID()));
            }
        } else {
            if (!thing.isEnabled()) {
                this.logger.debug("Thing {} is already in the required state.", (Object)thingUID);
                return;
            }
            this.logger.debug("Thing {} will be disabled.", (Object)thingUID);
            if (this.isHandlerRegistered(thing)) {
                ThingHandlerFactory thingHandlerFactory = this.findThingHandlerFactory(thing.getThingTypeUID());
                this.unregisterAndDisposeHandler(thingHandlerFactory, thing, thing.getHandler());
            } else {
                this.setThingStatus(thing, this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.DISABLED));
            }
            if (this.isBridge(thing)) {
                this.updateChildThingStatusForDisabledBridges((Bridge)thing);
            }
        }
    }

    private void updateChildThingStatusForDisabledBridges(Bridge bridge) {
        for (Thing childThing : bridge.getThings()) {
            ThingStatusDetail statusDetail = childThing.getStatusInfo().getStatusDetail();
            if (childThing.getStatus() != ThingStatus.UNINITIALIZED || statusDetail == ThingStatusDetail.DISABLED) continue;
            this.setThingStatus(childThing, this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.BRIDGE_UNINITIALIZED));
        }
    }

    private void persistThingEnableStatus(ThingUID thingUID, boolean enabled) {
        if (this.storage == null) {
            this.logger.debug("Cannot persist enable status of thing with UID {}. Persistent storage unavailable.", (Object)thingUID);
            return;
        }
        this.logger.debug("Thing with UID {} will be persisted as {}.", (Object)thingUID, (Object)(enabled ? "enabled." : "disabled."));
        if (enabled) {
            this.storage.remove(thingUID.getAsString());
        } else {
            this.storage.put(thingUID.getAsString(), (Object)"");
        }
    }

    @Override
    public boolean isEnabled(ThingUID thingUID) {
        Thing thing = this.getThing(thingUID);
        if (thing != null) {
            return thing.isEnabled();
        }
        this.logger.debug("Thing with UID {} is unknown. Will try to get the enabled status from the persistent storage.");
        return !this.isDisabledByStorage(thingUID);
    }

    private boolean isDisabledByStorage(ThingUID thingUID) {
        return this.storage != null && this.storage.containsKey(thingUID.getAsString());
    }

    @Reference
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    @Reference
    protected void setChannelGroupTypeRegistry(ChannelGroupTypeRegistry channelGroupTypeRegistry) {
        this.channelGroupTypeRegistry = channelGroupTypeRegistry;
    }

    protected void unsetChannelGroupTypeRegistry(ChannelGroupTypeRegistry channelGroupTypeRegistry) {
        this.channelGroupTypeRegistry = null;
    }

    @Reference
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    @Reference
    protected void setThingStatusInfoI18nLocalizationService(ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService) {
        this.thingStatusInfoI18nLocalizationService = thingStatusInfoI18nLocalizationService;
    }

    protected void unsetThingStatusInfoI18nLocalizationService(ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService) {
        this.thingStatusInfoI18nLocalizationService = null;
    }

    @Reference
    protected void setInboundCommunication(CommunicationManager communicationManager) {
        this.communicationManager = communicationManager;
    }

    protected void unsetInboundCommunication(CommunicationManager communicationManager) {
        this.communicationManager = null;
    }

    @Reference
    protected void setSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = safeCaller;
    }

    protected void unsetSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setStorageService(StorageService storageService) {
        if (this.storageService != storageService) {
            this.storageService = storageService;
            this.storage = storageService.getStorage(THING_STATUS_STORAGE_NAME, this.getClass().getClassLoader());
        }
    }

    protected void unsetStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
            this.storage = null;
        }
    }
}

