/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.type.AutoUpdatePolicy;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

@NonNullByDefault
public class ChannelDefinitionBuilder {
    private final String id;
    private final ChannelTypeUID channelTypeUID;
    private @Nullable Map<String, String> properties;
    private @Nullable String label;
    private @Nullable String description;
    private @Nullable AutoUpdatePolicy autoUpdatePolicy;

    public ChannelDefinitionBuilder(ChannelDefinition channelDefinition) {
        this(channelDefinition.getId(), channelDefinition.getChannelTypeUID());
        this.properties = channelDefinition.getProperties();
        this.label = channelDefinition.getLabel();
        this.description = channelDefinition.getDescription();
        this.autoUpdatePolicy = channelDefinition.getAutoUpdatePolicy();
    }

    public ChannelDefinitionBuilder(String id, ChannelTypeUID channelTypeUID) {
        this.id = id;
        this.channelTypeUID = channelTypeUID;
    }

    public ChannelDefinitionBuilder withProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public ChannelDefinitionBuilder withLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    public ChannelDefinitionBuilder withDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public ChannelDefinitionBuilder withAutoUpdatePolicy(@Nullable AutoUpdatePolicy autoUpdatePolicy) {
        this.autoUpdatePolicy = autoUpdatePolicy;
        return this;
    }

    public ChannelDefinition build() {
        return new ChannelDefinition(this.id, this.channelTypeUID, this.label, this.description, this.properties, this.autoUpdatePolicy);
    }
}

