/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;

public class ChannelGroupDefinition {
    private String id;
    private ChannelGroupTypeUID typeUID;
    private final String label;
    private final String description;

    public ChannelGroupDefinition(String id, ChannelGroupTypeUID typeUID, String label, String description) throws IllegalArgumentException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("The ID must neither be null nor empty!");
        }
        if (typeUID == null) {
            throw new IllegalArgumentException("The channel group type UID must not be null");
        }
        this.id = id;
        this.typeUID = typeUID;
        this.label = label;
        this.description = description;
    }

    public ChannelGroupDefinition(String id, ChannelGroupTypeUID typeUID) throws IllegalArgumentException {
        this(id, typeUID, null, null);
    }

    public String getId() {
        return this.id;
    }

    public ChannelGroupTypeUID getTypeUID() {
        return this.typeUID;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ChannelGroupDefinition [id=" + this.id + ", typeUID=" + (Object)((Object)this.typeUID) + "]";
    }
}

