/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.type.AbstractDescriptionType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;

@NonNullByDefault
public class ThingType
extends AbstractDescriptionType {
    private final List<ChannelGroupDefinition> channelGroupDefinitions;
    private final List<ChannelDefinition> channelDefinitions;
    private final List<String> extensibleChannelTypeIds;
    private final List<String> supportedBridgeTypeUIDs;
    private final Map<String, String> properties;
    private final @Nullable String representationProperty;
    private final @Nullable URI configDescriptionURI;
    private final boolean listed;
    private final @Nullable String category;

    @Deprecated
    public ThingType(String bindingId, String thingTypeId, String label) throws IllegalArgumentException {
        this(new ThingTypeUID(bindingId, thingTypeId), null, label, null, null, true, null, null, null, null, null);
    }

    @Deprecated
    public ThingType(ThingTypeUID uid, List<String> supportedBridgeTypeUIDs, String label, String description, List<ChannelDefinition> channelDefinitions, List<ChannelGroupDefinition> channelGroupDefinitions, Map<String, String> properties, URI configDescriptionURI) throws IllegalArgumentException {
        this(uid, supportedBridgeTypeUIDs, label, description, null, true, null, channelDefinitions, channelGroupDefinitions, properties, configDescriptionURI);
    }

    @Deprecated
    public ThingType(ThingTypeUID uid, List<String> supportedBridgeTypeUIDs, String label, String description, String category, boolean listed, List<ChannelDefinition> channelDefinitions, List<ChannelGroupDefinition> channelGroupDefinitions, @Nullable Map<String, String> properties, URI configDescriptionURI) throws IllegalArgumentException {
        this(uid, supportedBridgeTypeUIDs, label, description, category, listed, null, channelDefinitions, channelGroupDefinitions, properties, configDescriptionURI);
    }

    @Deprecated
    public ThingType(ThingTypeUID uid, @Nullable List<String> supportedBridgeTypeUIDs, String label, @Nullable String description, @Nullable String category, boolean listed, @Nullable String representationProperty, @Nullable List<ChannelDefinition> channelDefinitions, @Nullable List<ChannelGroupDefinition> channelGroupDefinitions, @Nullable Map<String, String> properties, @Nullable URI configDescriptionURI) throws IllegalArgumentException {
        this(uid, supportedBridgeTypeUIDs, label, description, category, listed, representationProperty, channelDefinitions, channelGroupDefinitions, properties, configDescriptionURI, null);
    }

    ThingType(ThingTypeUID uid, @Nullable List<String> supportedBridgeTypeUIDs, String label, @Nullable String description, @Nullable String category, boolean listed, @Nullable String representationProperty, @Nullable List<ChannelDefinition> channelDefinitions, @Nullable List<ChannelGroupDefinition> channelGroupDefinitions, @Nullable Map<String, String> properties, @Nullable URI configDescriptionURI, @Nullable List<String> extensibleChannelTypeIds) throws IllegalArgumentException {
        super(uid, label, description);
        this.category = category;
        this.listed = listed;
        this.representationProperty = representationProperty;
        this.supportedBridgeTypeUIDs = supportedBridgeTypeUIDs != null ? Collections.unmodifiableList(supportedBridgeTypeUIDs) : Collections.emptyList();
        this.channelDefinitions = channelDefinitions != null ? Collections.unmodifiableList(channelDefinitions) : Collections.emptyList();
        this.channelGroupDefinitions = channelGroupDefinitions != null ? Collections.unmodifiableList(channelGroupDefinitions) : Collections.emptyList();
        this.extensibleChannelTypeIds = extensibleChannelTypeIds != null ? Collections.unmodifiableList(extensibleChannelTypeIds) : Collections.emptyList();
        this.properties = properties != null ? Collections.unmodifiableMap(properties) : Collections.emptyMap();
        this.configDescriptionURI = configDescriptionURI;
    }

    @Override
    public ThingTypeUID getUID() {
        return (ThingTypeUID)super.getUID();
    }

    public String getBindingId() {
        return this.getUID().getBindingId();
    }

    public List<String> getSupportedBridgeTypeUIDs() {
        return this.supportedBridgeTypeUIDs;
    }

    public List<ChannelDefinition> getChannelDefinitions() {
        return this.channelDefinitions;
    }

    public List<ChannelGroupDefinition> getChannelGroupDefinitions() {
        return this.channelGroupDefinitions;
    }

    public @Nullable URI getConfigDescriptionURI() {
        return this.configDescriptionURI;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public @Nullable String getCategory() {
        return this.category;
    }

    public boolean isListed() {
        return this.listed;
    }

    public @Nullable String getRepresentationProperty() {
        return this.representationProperty;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThingType other = (ThingType)obj;
        return this.getUID().equals((Object)other.getUID());
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public String toString() {
        return this.getUID().toString();
    }

    public List<String> getExtensibleChannelTypeIds() {
        return this.extensibleChannelTypeIds;
    }
}

