/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.binding.builder.BridgeBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.dto.ChannelDTO;
import org.eclipse.smarthome.core.thing.dto.ChannelDTOMapper;
import org.eclipse.smarthome.core.thing.dto.ThingDTO;
import org.eclipse.smarthome.core.thing.internal.BridgeImpl;
import org.eclipse.smarthome.core.thing.internal.ThingImpl;

public class ThingHelper {
    public static boolean equals(Thing a, Thing b) {
        if (!a.getUID().equals((Object)b.getUID())) {
            return false;
        }
        if (!Objects.equals((Object)a.getBridgeUID(), (Object)b.getBridgeUID())) {
            return false;
        }
        if (!Objects.equals(a.getConfiguration(), b.getConfiguration())) {
            return false;
        }
        if (!Objects.equals(a.getLabel(), b.getLabel())) {
            return false;
        }
        if (!Objects.equals(a.getLocation(), b.getLocation())) {
            return false;
        }
        List<Channel> channelsOfA = a.getChannels();
        List<Channel> channelsOfB = b.getChannels();
        if (channelsOfA.size() != channelsOfB.size()) {
            return false;
        }
        return ThingHelper.toString(channelsOfA).equals(ThingHelper.toString(channelsOfB));
    }

    private static String toString(List<Channel> channels) {
        ArrayList<String> strings = new ArrayList<String>(channels.size());
        for (Channel channel : channels) {
            strings.add(String.valueOf(channel.getUID().toString()) + '#' + channel.getAcceptedItemType() + '#' + (Object)((Object)channel.getKind()));
        }
        Collections.sort(strings);
        return strings.stream().collect(Collectors.joining(","));
    }

    public static void addChannelsToThing(Thing thing, Collection<Channel> channels) {
        List<Channel> mutableChannels = ((ThingImpl)thing).getChannelsMutable();
        ThingHelper.ensureUniqueChannels(mutableChannels, channels);
        mutableChannels.addAll(channels);
    }

    public static void ensureUnique(Collection<Channel> channels) {
        HashSet<ChannelUID> ids = new HashSet<ChannelUID>();
        for (Channel channel : channels) {
            if (ids.add(channel.getUID())) continue;
            throw new IllegalArgumentException("Duplicate channels " + channel.getUID().getAsString());
        }
    }

    public static void ensureUniqueChannels(Channel[] channels) {
        ArrayIterator it = new ArrayIterator((Object)channels);
        ThingHelper.ensureUniqueChannels((Iterator<Channel>)it, new HashSet<UID>(channels.length));
    }

    public static void ensureUniqueChannels(Collection<Channel> channels) {
        ThingHelper.ensureUniqueChannels(channels.iterator(), new HashSet<UID>(channels.size()));
    }

    public static void ensureUniqueChannels(Collection<Channel> channels, Channel channel) {
        ThingHelper.ensureUniqueChannels(channels, Collections.singleton(channel));
    }

    private static void ensureUniqueChannels(Collection<Channel> channels1, Collection<Channel> channels2) {
        ThingHelper.ensureUniqueChannels(channels1.iterator(), ThingHelper.ensureUniqueChannels(channels2.iterator(), new HashSet<UID>(channels1.size() + channels2.size())));
    }

    private static HashSet<UID> ensureUniqueChannels(Iterator<Channel> channels, HashSet<UID> ids) {
        while (channels.hasNext()) {
            Channel channel = channels.next();
            if (ids.add(channel.getUID())) continue;
            throw new IllegalArgumentException("Duplicate channels " + channel.getUID().getAsString());
        }
        return ids;
    }

    public static Thing merge(Thing thing, ThingDTO updatedContents) {
        ThingBuilder builder = thing instanceof Bridge ? BridgeBuilder.create(thing.getThingTypeUID(), thing.getUID()) : ThingBuilder.create(thing.getThingTypeUID(), thing.getUID());
        if (updatedContents.label != null) {
            builder.withLabel(updatedContents.label);
        } else {
            builder.withLabel(thing.getLabel());
        }
        if (updatedContents.location != null) {
            builder.withLocation(updatedContents.location);
        } else {
            builder.withLocation(thing.getLocation());
        }
        if (updatedContents.bridgeUID != null) {
            builder.withBridge(new ThingUID(updatedContents.bridgeUID));
        } else {
            builder.withBridge(thing.getBridgeUID());
        }
        if (updatedContents.configuration != null && !updatedContents.configuration.keySet().isEmpty()) {
            builder.withConfiguration(new Configuration(updatedContents.configuration));
        } else {
            builder.withConfiguration(thing.getConfiguration());
        }
        if (updatedContents.properties != null) {
            builder.withProperties(updatedContents.properties);
        } else {
            builder.withProperties(thing.getProperties());
        }
        if (updatedContents.channels != null) {
            for (ChannelDTO channelDTO : updatedContents.channels) {
                builder.withChannel(ChannelDTOMapper.map(channelDTO));
            }
        } else {
            builder.withChannels(thing.getChannels());
        }
        if (updatedContents.location != null) {
            builder.withLocation(updatedContents.location);
        } else {
            builder.withLocation(thing.getLocation());
        }
        Thing mergedThing = builder.build();
        if (mergedThing instanceof BridgeImpl && thing instanceof Bridge) {
            Bridge bridge = (Bridge)thing;
            BridgeImpl mergedBridge = (BridgeImpl)mergedThing;
            for (Thing child : bridge.getThings()) {
                mergedBridge.addThing(child);
            }
        }
        return mergedThing;
    }
}

