/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.transform;

import java.util.Collection;
import java.util.IllegalFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class TransformationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformationHelper.class);
    public static final String FUNCTION_VALUE_DELIMITER = ":";
    protected static final Pattern EXTRACT_TRANSFORMFUNCTION_PATTERN = Pattern.compile("(.*?)\\((.*)\\):(.*)");

    public static boolean isTransform(String pattern) {
        return EXTRACT_TRANSFORMFUNCTION_PATTERN.matcher(pattern).matches();
    }

    public static @Nullable TransformationService getTransformationService(@Nullable BundleContext context, String transformationType) {
        if (context != null) {
            String filter = "(smarthome.transform=" + transformationType + ")";
            try {
                Collection refs = context.getServiceReferences(TransformationService.class, filter);
                if (refs != null && refs.size() > 0) {
                    return (TransformationService)context.getService((ServiceReference)refs.iterator().next());
                }
                LOGGER.debug("Cannot get service reference for transformation service of type {}", (Object)transformationType);
            }
            catch (InvalidSyntaxException e) {
                LOGGER.debug("Cannot get service reference for transformation service of type {}", (Object)transformationType, (Object)e);
            }
        }
        return null;
    }

    public static @Nullable String transform(BundleContext context, String stateDescPattern, String state) throws TransformationException {
        Matcher matcher = EXTRACT_TRANSFORMFUNCTION_PATTERN.matcher(stateDescPattern);
        if (matcher.find()) {
            String type = matcher.group(1);
            String pattern = matcher.group(2);
            String value = matcher.group(3);
            TransformationService transformation = TransformationHelper.getTransformationService(context, type);
            if (transformation != null) {
                return TransformationHelper.transform(transformation, pattern, value, state);
            }
            throw new TransformationException("Couldn't transform value because transformation service of type '" + type + "' is not available.");
        }
        return state;
    }

    public static @Nullable String transform(TransformationService service, String function, String format, String state) throws TransformationException {
        try {
            String value = String.format(format, state);
            return service.transform(function, value);
        }
        catch (IllegalFormatException e) {
            throw new TransformationException("Cannot format state '" + state + "' to format '" + format + "'", e);
        }
    }
}

