/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.transform.actions;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.eclipse.smarthome.core.transform.internal.TransformationActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class Transformation {
    private static @Nullable String trans(String type, String function, String value) throws TransformationException {
        TransformationService service = TransformationHelper.getTransformationService(TransformationActivator.getContext(), type);
        if (service == null) {
            throw new TransformationException("No transformation service '" + type + "' could be found.");
        }
        String result = service.transform(function, value);
        return result;
    }

    public static @Nullable String transform(String type, String function, String value) {
        String result;
        Logger logger = LoggerFactory.getLogger(Transformation.class);
        try {
            result = Transformation.trans(type, function, value);
        }
        catch (TransformationException e) {
            logger.debug("Error executing the transformation '{}': {}", (Object)type, (Object)e.getMessage());
            result = value;
        }
        return result;
    }

    public static @Nullable String transformRaw(String type, String function, String value) throws TransformationException {
        return Transformation.trans(type, function, value);
    }
}

