/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.events;

import com.google.gson.Gson;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFactory;

public abstract class AbstractEventFactory
implements EventFactory {
    private final Set<String> supportedEventTypes;
    private static final Gson JSONCONVERTER = new Gson();

    public AbstractEventFactory(Set<String> supportedEventTypes) {
        this.supportedEventTypes = Collections.unmodifiableSet(new HashSet<String>(supportedEventTypes));
    }

    @Override
    public Event createEvent(String eventType, String topic, String payload, String source) throws Exception {
        this.assertValidArguments(eventType, topic, payload);
        if (!this.getSupportedEventTypes().contains(eventType)) {
            throw new IllegalArgumentException("The event type '" + eventType + "' is not supported by this factory.");
        }
        return this.createEventByType(eventType, topic, payload, source);
    }

    @Override
    public Set<String> getSupportedEventTypes() {
        return this.supportedEventTypes;
    }

    private void assertValidArguments(String eventType, String topic, String payload) {
        AbstractEventFactory.checkNotNullOrEmpty(eventType, "eventType");
        AbstractEventFactory.checkNotNullOrEmpty(topic, "topic");
        AbstractEventFactory.checkNotNullOrEmpty(payload, "payload");
    }

    protected abstract Event createEventByType(String var1, String var2, String var3, String var4) throws Exception;

    protected static String serializePayload(Object payloadObject) {
        return JSONCONVERTER.toJson(payloadObject);
    }

    protected static <T> T deserializePayload(String payload, Class<T> classOfPayload) {
        return (T)JSONCONVERTER.fromJson(payload, classOfPayload);
    }

    protected String[] getTopicElements(String topic) {
        return topic.split("/");
    }

    protected static void checkNotNull(Object object, String argumentName) {
        if (object == null) {
            throw new IllegalArgumentException("The argument '" + argumentName + "' must not be null.");
        }
    }

    protected static void checkNotNullOrEmpty(String string, String argumentName) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The argument '" + argumentName + "' must not be null or empty.");
        }
    }
}

