/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.events;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.events.EventFactory;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EventHandler {
    private final Logger logger = LoggerFactory.getLogger(EventHandler.class);
    private final Map<String, Set<EventSubscriber>> typedEventSubscribers;
    private final Map<String, EventFactory> typedEventFactories;
    private final SafeCaller safeCaller;

    public EventHandler(Map<String, Set<EventSubscriber>> typedEventSubscribers, Map<String, EventFactory> typedEventFactories, SafeCaller safeCaller) {
        this.typedEventSubscribers = typedEventSubscribers;
        this.typedEventFactories = typedEventFactories;
        this.safeCaller = safeCaller;
    }

    public void handleEvent(Event osgiEvent) {
        this.logger.trace("Handle OSGi event (event: {})", (Object)osgiEvent);
        Object typeObj = osgiEvent.getProperty("type");
        Object payloadObj = osgiEvent.getProperty("payload");
        Object topicObj = osgiEvent.getProperty("topic");
        Object sourceObj = osgiEvent.getProperty("source");
        if (typeObj instanceof String && payloadObj instanceof String && topicObj instanceof String) {
            String sourceStr;
            String typeStr = (String)typeObj;
            String payloadStr = (String)payloadObj;
            String topicStr = (String)topicObj;
            String string = sourceStr = sourceObj instanceof String ? (String)sourceObj : null;
            if (!(typeStr.isEmpty() || payloadStr.isEmpty() || topicStr.isEmpty())) {
                this.handleEvent(typeStr, payloadStr, topicStr, sourceStr);
            }
        } else {
            this.logger.error("The handled OSGi event is invalid. Expect properties as string named 'type', 'payload' and 'topic'. Received event properties are: {}", (Object)Arrays.toString(osgiEvent.getPropertyNames()));
        }
    }

    private void handleEvent(String type, String payload, String topic, @Nullable String source) {
        EventFactory eventFactory = this.typedEventFactories.get(type);
        if (eventFactory == null) {
            this.logger.debug("Could not find an Event Factory for the event type '{}'.", (Object)type);
            return;
        }
        Set<EventSubscriber> eventSubscribers = this.getEventSubscribers(type);
        if (eventSubscribers.isEmpty()) {
            return;
        }
        org.eclipse.smarthome.core.events.Event eshEvent = this.createESHEvent(eventFactory, type, payload, topic, source);
        if (eshEvent == null) {
            return;
        }
        this.dispatchESHEvent(eventSubscribers, eshEvent);
    }

    private Set<EventSubscriber> getEventSubscribers(String eventType) {
        Set<EventSubscriber> eventTypeSubscribers = this.typedEventSubscribers.get(eventType);
        Set<EventSubscriber> allEventTypeSubscribers = this.typedEventSubscribers.get("ALL");
        HashSet<EventSubscriber> subscribers = new HashSet<EventSubscriber>();
        if (eventTypeSubscribers != null) {
            subscribers.addAll(eventTypeSubscribers);
        }
        if (allEventTypeSubscribers != null) {
            subscribers.addAll(allEventTypeSubscribers);
        }
        return subscribers;
    }

    private @Nullable org.eclipse.smarthome.core.events.Event createESHEvent(EventFactory eventFactory, String type, String payload, String topic, @Nullable String source) {
        org.eclipse.smarthome.core.events.Event eshEvent = null;
        try {
            eshEvent = eventFactory.createEvent(type, topic, payload, source);
        }
        catch (Exception e) {
            this.logger.error("Creation of ESH-Event failed, because one of the registered event factories has thrown an exception: {}", (Object)e.getMessage(), (Object)e);
        }
        return eshEvent;
    }

    private synchronized void dispatchESHEvent(Set<EventSubscriber> eventSubscribers, org.eclipse.smarthome.core.events.Event event) {
        for (EventSubscriber eventSubscriber : eventSubscribers) {
            EventFilter filter = eventSubscriber.getEventFilter();
            if (filter != null && !filter.apply(event)) continue;
            this.safeCaller.create(eventSubscriber, EventSubscriber.class).withAsync().onTimeout(() -> this.logger.warn("Dispatching event to subscriber '{}' takes more than {}ms.", (Object)eventSubscriber.toString(), (Object)SafeCaller.DEFAULT_TIMEOUT)).onException(e -> this.logger.error("Dispatching/filtering event for subscriber '{}' failed: {}", new Object[]{EventSubscriber.class.getName(), e.getMessage(), e})).build().receive(event);
        }
    }
}

